/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.segment.column.RowSignature;

public class ScanQueryLimitRowIterator
implements CloseableIterator<ScanResultValue> {
    private Yielder<ScanResultValue> yielder;
    private ScanQuery.ResultFormat resultFormat;
    private long limit;
    private long count = 0L;
    private ScanQuery query;

    ScanQueryLimitRowIterator(QueryRunner<ScanResultValue> baseRunner, QueryPlus<ScanResultValue> queryPlus, ResponseContext responseContext) {
        this.query = (ScanQuery)queryPlus.getQuery();
        this.resultFormat = this.query.getResultFormat();
        this.limit = this.query.getScanRowsLimit();
        Query<ScanResultValue> historicalQuery = queryPlus.getQuery().withOverriddenContext((Map<String, Object>)ImmutableMap.of((Object)"scanOutermost", (Object)false));
        Sequence<ScanResultValue> baseSequence = baseRunner.run(QueryPlus.wrap(historicalQuery), responseContext);
        this.yielder = baseSequence.toYielder(null, new YieldingAccumulator<ScanResultValue, ScanResultValue>(){

            @Override
            public ScanResultValue accumulate(ScanResultValue accumulated, ScanResultValue in) {
                this.yield();
                return in;
            }
        });
    }

    @Override
    public boolean hasNext() {
        return !this.yielder.isDone() && this.count < this.limit;
    }

    @Override
    public ScanResultValue next() {
        if (ScanQuery.ResultFormat.RESULT_FORMAT_VALUE_VECTOR.equals((Object)this.resultFormat)) {
            throw new UOE((Object)((Object)ScanQuery.ResultFormat.RESULT_FORMAT_VALUE_VECTOR) + " is not supported yet", new Object[0]);
        }
        if (this.query.getTimeOrder() == ScanQuery.Order.NONE || !this.query.context().getBoolean("scanOutermost", true)) {
            ScanResultValue batch = this.yielder.get();
            List events = (List)batch.getEvents();
            if ((long)events.size() <= this.limit - this.count) {
                this.count += (long)events.size();
                this.yielder = this.yielder.next(null);
                return batch;
            }
            int numLeft = (int)(this.limit - this.count);
            this.count = this.limit;
            return new ScanResultValue(batch.getSegmentId(), batch.getColumns(), events.subList(0, numLeft), batch.getRowSignature());
        }
        int batchSize = this.query.getBatchSize();
        ArrayList<Object> eventsToAdd = new ArrayList<Object>(batchSize);
        ArrayList<String> columns = new ArrayList<String>();
        RowSignature rowSignature = null;
        while (eventsToAdd.size() < batchSize && !this.yielder.isDone() && this.count < this.limit) {
            ScanResultValue srv = this.yielder.get();
            columns = columns.isEmpty() ? srv.getColumns() : columns;
            rowSignature = rowSignature == null ? srv.getRowSignature() : rowSignature;
            eventsToAdd.add(Iterables.getOnlyElement((Iterable)((List)srv.getEvents())));
            this.yielder = this.yielder.next(null);
            ++this.count;
        }
        return new ScanResultValue(null, columns, eventsToAdd, rowSignature);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.yielder.close();
    }
}

