/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.ColumnSelectorPlus;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.SimpleDoubleBufferAggregator;
import org.apache.druid.query.monomorphicprocessing.HotLoopCallee;
import org.apache.druid.query.monomorphicprocessing.SpecializationService;
import org.apache.druid.query.monomorphicprocessing.SpecializationState;
import org.apache.druid.query.monomorphicprocessing.StringRuntimeShape;
import org.apache.druid.query.topn.BaseTopNAlgorithm;
import org.apache.druid.query.topn.Generic1AggPooledTopNScanner;
import org.apache.druid.query.topn.Generic1AggPooledTopNScannerPrototype;
import org.apache.druid.query.topn.Generic2AggPooledTopNScanner;
import org.apache.druid.query.topn.Generic2AggPooledTopNScannerPrototype;
import org.apache.druid.query.topn.Historical1AggPooledTopNScanner;
import org.apache.druid.query.topn.Historical1SimpleDoubleAggPooledTopNScannerPrototype;
import org.apache.druid.query.topn.HistoricalSingleValueDimSelector1SimpleDoubleAggPooledTopNScannerPrototype;
import org.apache.druid.query.topn.TopNMetricSpecBuilder;
import org.apache.druid.query.topn.TopNParams;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNResultBuilder;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.FilteredOffset;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.Offset;
import org.apache.druid.segment.historical.HistoricalColumnSelector;
import org.apache.druid.segment.historical.HistoricalCursor;
import org.apache.druid.segment.historical.HistoricalDimensionSelector;
import org.apache.druid.segment.historical.SingleValueHistoricalDimensionSelector;
import org.apache.druid.utils.CloseableUtils;

public class PooledTopNAlgorithm
extends BaseTopNAlgorithm<int[], BufferAggregator[], PooledTopNParams> {
    private static boolean SPECIALIZE_GENERIC_ONE_AGG_POOLED_TOPN = !Boolean.getBoolean("dontSpecializeGeneric1AggPooledTopN");
    private static boolean SPECIALIZE_GENERIC_TWO_AGG_POOLED_TOPN = !Boolean.getBoolean("dontSpecializeGeneric2AggPooledTopN");
    private static boolean SPECIALIZE_HISTORICAL_ONE_SIMPLE_DOUBLE_AGG_POOLED_TOPN = !Boolean.getBoolean("dontSpecializeHistorical1SimpleDoubleAggPooledTopN");
    private static boolean SPECIALIZE_HISTORICAL_SINGLE_VALUE_DIM_SELECTOR_ONE_SIMPLE_DOUBLE_AGG_POOLED_TOPN = !Boolean.getBoolean("dontSpecializeHistoricalSingleValueDimSelector1SimpleDoubleAggPooledTopN");
    private static final Generic1AggPooledTopNScanner DEFAULT_GENERIC_ONE_AGG_SCANNER = new Generic1AggPooledTopNScannerPrototype();
    private static final Generic2AggPooledTopNScanner DEFAULT_GENERIC_TWO_AGG_SCANNER = new Generic2AggPooledTopNScannerPrototype();
    private static final Historical1AggPooledTopNScanner DEFAULT_HISTORICAL_ONE_SIMPLE_DOUBLE_AGG_SCANNER = new Historical1SimpleDoubleAggPooledTopNScannerPrototype();
    private static final Historical1AggPooledTopNScanner DEFAULT_HISTORICAL_SINGLE_VALUE_DIM_SELECTOR_ONE_SIMPLE_DOUBLE_AGG_SCANNER = new HistoricalSingleValueDimSelector1SimpleDoubleAggPooledTopNScannerPrototype();
    private static final List<ScanAndAggregate> SPECIALIZED_SCAN_AND_AGGREGATE_IMPLEMENTATIONS = new ArrayList<ScanAndAggregate>();
    private final TopNQuery query;
    private final NonBlockingPool<ByteBuffer> bufferPool;
    private static final int AGG_UNROLL_COUNT = 8;

    @VisibleForTesting
    static void setSpecializeGeneric1AggPooledTopN(boolean value) {
        SPECIALIZE_GENERIC_ONE_AGG_POOLED_TOPN = value;
        PooledTopNAlgorithm.computeSpecializedScanAndAggregateImplementations();
    }

    @VisibleForTesting
    static void setSpecializeGeneric2AggPooledTopN(boolean value) {
        SPECIALIZE_GENERIC_TWO_AGG_POOLED_TOPN = value;
        PooledTopNAlgorithm.computeSpecializedScanAndAggregateImplementations();
    }

    @VisibleForTesting
    static void setSpecializeHistorical1SimpleDoubleAggPooledTopN(boolean value) {
        SPECIALIZE_HISTORICAL_ONE_SIMPLE_DOUBLE_AGG_POOLED_TOPN = value;
        PooledTopNAlgorithm.computeSpecializedScanAndAggregateImplementations();
    }

    @VisibleForTesting
    static void setSpecializeHistoricalSingleValueDimSelector1SimpleDoubleAggPooledTopN(boolean value) {
        SPECIALIZE_HISTORICAL_SINGLE_VALUE_DIM_SELECTOR_ONE_SIMPLE_DOUBLE_AGG_POOLED_TOPN = value;
        PooledTopNAlgorithm.computeSpecializedScanAndAggregateImplementations();
    }

    private static void computeSpecializedScanAndAggregateImplementations() {
        SPECIALIZED_SCAN_AND_AGGREGATE_IMPLEMENTATIONS.clear();
        if (SPECIALIZE_HISTORICAL_SINGLE_VALUE_DIM_SELECTOR_ONE_SIMPLE_DOUBLE_AGG_POOLED_TOPN) {
            SPECIALIZED_SCAN_AND_AGGREGATE_IMPLEMENTATIONS.add((params, positions, theAggregators) -> {
                if (theAggregators.length == 1) {
                    BufferAggregator aggregator = theAggregators[0];
                    Cursor cursor = params.getCursor();
                    if (cursor instanceof HistoricalCursor && !(((HistoricalCursor)cursor).getOffset() instanceof FilteredOffset) && aggregator instanceof SimpleDoubleBufferAggregator && params.getDimSelector() instanceof SingleValueHistoricalDimensionSelector && ((SimpleDoubleBufferAggregator)aggregator).getSelector() instanceof HistoricalColumnSelector) {
                        return PooledTopNAlgorithm.scanAndAggregateHistorical1SimpleDoubleAgg(params, positions, (SimpleDoubleBufferAggregator)aggregator, (HistoricalCursor)cursor, DEFAULT_HISTORICAL_SINGLE_VALUE_DIM_SELECTOR_ONE_SIMPLE_DOUBLE_AGG_SCANNER);
                    }
                }
                return -1L;
            });
        }
        if (SPECIALIZE_HISTORICAL_ONE_SIMPLE_DOUBLE_AGG_POOLED_TOPN) {
            SPECIALIZED_SCAN_AND_AGGREGATE_IMPLEMENTATIONS.add((params, positions, theAggregators) -> {
                if (theAggregators.length == 1) {
                    BufferAggregator aggregator = theAggregators[0];
                    Cursor cursor = params.getCursor();
                    if (cursor instanceof HistoricalCursor && !(((HistoricalCursor)cursor).getOffset() instanceof FilteredOffset) && aggregator instanceof SimpleDoubleBufferAggregator && params.getDimSelector() instanceof HistoricalDimensionSelector && ((SimpleDoubleBufferAggregator)aggregator).getSelector() instanceof HistoricalColumnSelector) {
                        return PooledTopNAlgorithm.scanAndAggregateHistorical1SimpleDoubleAgg(params, positions, (SimpleDoubleBufferAggregator)aggregator, (HistoricalCursor)cursor, DEFAULT_HISTORICAL_ONE_SIMPLE_DOUBLE_AGG_SCANNER);
                    }
                }
                return -1L;
            });
        }
        if (SPECIALIZE_GENERIC_ONE_AGG_POOLED_TOPN) {
            SPECIALIZED_SCAN_AND_AGGREGATE_IMPLEMENTATIONS.add((params, positions, theAggregators) -> {
                if (theAggregators.length == 1) {
                    return PooledTopNAlgorithm.scanAndAggregateGeneric1Agg(params, positions, theAggregators[0], params.getCursor());
                }
                return -1L;
            });
        }
        if (SPECIALIZE_GENERIC_TWO_AGG_POOLED_TOPN) {
            SPECIALIZED_SCAN_AND_AGGREGATE_IMPLEMENTATIONS.add((params, positions, theAggregators) -> {
                if (theAggregators.length == 2) {
                    return PooledTopNAlgorithm.scanAndAggregateGeneric2Agg(params, positions, theAggregators, params.getCursor());
                }
                return -1L;
            });
        }
    }

    public PooledTopNAlgorithm(StorageAdapter storageAdapter, TopNQuery query, NonBlockingPool<ByteBuffer> bufferPool) {
        super(storageAdapter);
        this.query = query;
        this.bufferPool = bufferPool;
    }

    public PooledTopNParams makeInitParams(ColumnSelectorPlus selectorPlus, Cursor cursor) {
        DimensionSelector dimSelector = (DimensionSelector)selectorPlus.getSelector();
        final int cardinality = dimSelector.getValueCardinality();
        if (cardinality < 0) {
            throw new UnsupportedOperationException("Cannot operate on a dimension with no dictionary");
        }
        BaseTopNAlgorithm.BaseArrayProvider<int[]> arrayProvider = new BaseTopNAlgorithm.BaseArrayProvider<int[]>(dimSelector, this.query, this.storageAdapter){
            private final int[] positions;
            {
                super(dimSelector, query, storageAdapter);
                this.positions = new int[cardinality];
            }

            @Override
            public int[] build() {
                Pair<Integer, Integer> startEnd = this.computeStartEnd(cardinality);
                Arrays.fill(this.positions, 0, (int)((Integer)startEnd.lhs), -2);
                Arrays.fill(this.positions, (int)((Integer)startEnd.lhs), (int)((Integer)startEnd.rhs), -1);
                Arrays.fill(this.positions, (int)((Integer)startEnd.rhs), this.positions.length, -2);
                return this.positions;
            }
        };
        ResourceHolder<ByteBuffer> resultsBufHolder = this.bufferPool.take();
        try {
            ByteBuffer resultsBuf = resultsBufHolder.get();
            resultsBuf.clear();
            int numBytesToWorkWith = resultsBuf.remaining();
            int[] aggregatorSizes = new int[this.query.getAggregatorSpecs().size()];
            int numBytesPerRecord = 0;
            for (int i = 0; i < this.query.getAggregatorSpecs().size(); ++i) {
                aggregatorSizes[i] = this.query.getAggregatorSpecs().get(i).getMaxIntermediateSizeWithNulls();
                numBytesPerRecord += aggregatorSizes[i];
            }
            int numValuesPerPass = numBytesPerRecord > 0 ? numBytesToWorkWith / numBytesPerRecord : cardinality;
            return PooledTopNParams.builder().withSelectorPlus(selectorPlus).withCursor(cursor).withResultsBufHolder(resultsBufHolder).withResultsBuf(resultsBuf).withArrayProvider((TopNMetricSpecBuilder<int[]>)arrayProvider).withNumBytesPerRecord(numBytesPerRecord).withNumValuesPerPass(numValuesPerPass).withAggregatorSizes(aggregatorSizes).build();
        }
        catch (Throwable e) {
            resultsBufHolder.close();
            throw e;
        }
    }

    @Override
    protected int[] makeDimValSelector(PooledTopNParams params, int numProcessed, int numToProcess) {
        TopNMetricSpecBuilder<int[]> arrayProvider = params.getArrayProvider();
        if (!this.query.getDimensionSpec().preservesOrdering()) {
            return arrayProvider.build();
        }
        arrayProvider.ignoreFirstN(numProcessed);
        arrayProvider.keepOnlyN(numToProcess);
        return this.query.getTopNMetricSpec().configureOptimizer(arrayProvider).build();
    }

    @Override
    protected int computeNewLength(int[] dimValSelector, int numProcessed, int numToProcess) {
        int valid = 0;
        int length = 0;
        for (int i = numProcessed; i < dimValSelector.length && valid < numToProcess; ++i) {
            ++length;
            if (-2 == dimValSelector[i]) continue;
            ++valid;
        }
        return length;
    }

    @Override
    protected int[] updateDimValSelector(int[] dimValSelector, int numProcessed, int numToProcess) {
        int[] retVal = Arrays.copyOf(dimValSelector, dimValSelector.length);
        int validEnd = Math.min(retVal.length, numProcessed + numToProcess);
        int end = Math.max(retVal.length, validEnd);
        Arrays.fill(retVal, 0, numProcessed, -2);
        Arrays.fill(retVal, validEnd, end, -2);
        return retVal;
    }

    @Override
    protected BufferAggregator[] makeDimValAggregateStore(PooledTopNParams params) {
        return PooledTopNAlgorithm.makeBufferAggregators(params.getCursor(), this.query.getAggregatorSpecs());
    }

    @Override
    protected long scanAndAggregate(PooledTopNParams params, int[] positions, BufferAggregator[] theAggregators) {
        for (ScanAndAggregate specializedScanAndAggregate : SPECIALIZED_SCAN_AND_AGGREGATE_IMPLEMENTATIONS) {
            long processedRows = specializedScanAndAggregate.scanAndAggregate(params, positions, theAggregators);
            if (processedRows < 0L) continue;
            BaseQuery.checkInterrupted();
            return processedRows;
        }
        long processedRows = PooledTopNAlgorithm.scanAndAggregateDefault(params, positions, theAggregators);
        BaseQuery.checkInterrupted();
        return processedRows;
    }

    private static long scanAndAggregateHistorical1SimpleDoubleAgg(PooledTopNParams params, int[] positions, SimpleDoubleBufferAggregator aggregator, HistoricalCursor cursor, Historical1AggPooledTopNScanner prototypeScanner) {
        String runtimeShape = StringRuntimeShape.of((HotLoopCallee)aggregator);
        SpecializationState<?> specializationState = SpecializationService.getSpecializationState(prototypeScanner.getClass(), runtimeShape, ImmutableMap.of(Offset.class, cursor.getOffset().getClass()));
        Historical1AggPooledTopNScanner scanner = specializationState.getSpecializedOrDefault(prototypeScanner);
        long processedRows = scanner.scanAndAggregate((HistoricalDimensionSelector)params.getDimSelector(), aggregator.getSelector(), aggregator, params.getAggregatorSizes()[0], cursor, positions, params.getResultsBuf());
        specializationState.accountLoopIterations(processedRows);
        return processedRows;
    }

    private static long scanAndAggregateGeneric1Agg(PooledTopNParams params, int[] positions, BufferAggregator aggregator, Cursor cursor) {
        String runtimeShape = StringRuntimeShape.of((HotLoopCallee)aggregator);
        Class<Generic1AggPooledTopNScannerPrototype> prototypeClass = Generic1AggPooledTopNScannerPrototype.class;
        SpecializationState<Generic1AggPooledTopNScannerPrototype> specializationState = SpecializationService.getSpecializationState(prototypeClass, runtimeShape);
        Generic1AggPooledTopNScanner scanner = specializationState.getSpecializedOrDefault((Generic1AggPooledTopNScannerPrototype)DEFAULT_GENERIC_ONE_AGG_SCANNER);
        long processedRows = scanner.scanAndAggregate(params.getDimSelector(), aggregator, params.getAggregatorSizes()[0], cursor, positions, params.getResultsBuf());
        specializationState.accountLoopIterations(processedRows);
        return processedRows;
    }

    private static long scanAndAggregateGeneric2Agg(PooledTopNParams params, int[] positions, BufferAggregator[] theAggregators, Cursor cursor) {
        String runtimeShape = StringRuntimeShape.of(theAggregators);
        Class<Generic2AggPooledTopNScannerPrototype> prototypeClass = Generic2AggPooledTopNScannerPrototype.class;
        SpecializationState<Generic2AggPooledTopNScannerPrototype> specializationState = SpecializationService.getSpecializationState(prototypeClass, runtimeShape);
        Generic2AggPooledTopNScanner scanner = specializationState.getSpecializedOrDefault((Generic2AggPooledTopNScannerPrototype)DEFAULT_GENERIC_TWO_AGG_SCANNER);
        int[] aggregatorSizes = params.getAggregatorSizes();
        long processedRows = scanner.scanAndAggregate(params.getDimSelector(), theAggregators[0], aggregatorSizes[0], theAggregators[1], aggregatorSizes[1], cursor, positions, params.getResultsBuf());
        specializationState.accountLoopIterations(processedRows);
        return processedRows;
    }

    private static long scanAndAggregateDefault(PooledTopNParams params, int[] positions, BufferAggregator[] theAggregators) {
        if (params.getCardinality() < 0) {
            throw new UnsupportedOperationException("Cannot operate on a dimension with unknown cardinality");
        }
        ByteBuffer resultsBuf = params.getResultsBuf();
        int numBytesPerRecord = params.getNumBytesPerRecord();
        int[] aggregatorSizes = params.getAggregatorSizes();
        Cursor cursor = params.getCursor();
        DimensionSelector dimSelector = params.getDimSelector();
        int[] aggregatorOffsets = new int[aggregatorSizes.length];
        int offset = 0;
        for (int j = 0; j < aggregatorSizes.length; ++j) {
            aggregatorOffsets[j] = offset;
            offset += aggregatorSizes[j];
        }
        int aggSize = theAggregators.length;
        int aggExtra = aggSize % 8;
        int currentPosition = 0;
        long processedRows = 0L;
        while (!cursor.isDoneOrInterrupted()) {
            IndexedInts dimValues = dimSelector.getRow();
            int dimSize = dimValues.size();
            int dimExtra = dimSize % 8;
            switch (dimExtra) {
                case 7: {
                    currentPosition = PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(6), currentPosition);
                }
                case 6: {
                    currentPosition = PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(5), currentPosition);
                }
                case 5: {
                    currentPosition = PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(4), currentPosition);
                }
                case 4: {
                    currentPosition = PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(3), currentPosition);
                }
                case 3: {
                    currentPosition = PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(2), currentPosition);
                }
                case 2: {
                    currentPosition = PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(1), currentPosition);
                }
                case 1: {
                    currentPosition = PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(0), currentPosition);
                }
            }
            for (int i = dimExtra; i < dimSize; i += 8) {
                currentPosition = PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(i), currentPosition);
                currentPosition = PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(i + 1), currentPosition);
                currentPosition = PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(i + 2), currentPosition);
                currentPosition = PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(i + 3), currentPosition);
                currentPosition = PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(i + 4), currentPosition);
                currentPosition = PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(i + 5), currentPosition);
                currentPosition = PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(i + 6), currentPosition);
                currentPosition = PooledTopNAlgorithm.aggregateDimValue(positions, theAggregators, resultsBuf, numBytesPerRecord, aggregatorOffsets, aggSize, aggExtra, dimValues.get(i + 7), currentPosition);
            }
            cursor.advanceUninterruptibly();
            ++processedRows;
        }
        return processedRows;
    }

    private static int aggregateDimValue(int[] positions, BufferAggregator[] theAggregators, ByteBuffer resultsBuf, int numBytesPerRecord, int[] aggregatorOffsets, int aggSize, int aggExtra, int dimIndex, int currentPosition) {
        int j;
        if (-2 == positions[dimIndex]) {
            return currentPosition;
        }
        if (-1 == positions[dimIndex]) {
            positions[dimIndex] = currentPosition * numBytesPerRecord;
            ++currentPosition;
            int pos = positions[dimIndex];
            for (j = 0; j < aggSize; ++j) {
                theAggregators[j].init(resultsBuf, pos + aggregatorOffsets[j]);
            }
        }
        int position = positions[dimIndex];
        switch (aggExtra) {
            case 7: {
                theAggregators[6].aggregate(resultsBuf, position + aggregatorOffsets[6]);
            }
            case 6: {
                theAggregators[5].aggregate(resultsBuf, position + aggregatorOffsets[5]);
            }
            case 5: {
                theAggregators[4].aggregate(resultsBuf, position + aggregatorOffsets[4]);
            }
            case 4: {
                theAggregators[3].aggregate(resultsBuf, position + aggregatorOffsets[3]);
            }
            case 3: {
                theAggregators[2].aggregate(resultsBuf, position + aggregatorOffsets[2]);
            }
            case 2: {
                theAggregators[1].aggregate(resultsBuf, position + aggregatorOffsets[1]);
            }
            case 1: {
                theAggregators[0].aggregate(resultsBuf, position + aggregatorOffsets[0]);
            }
        }
        for (j = aggExtra; j < aggSize; j += 8) {
            theAggregators[j].aggregate(resultsBuf, position + aggregatorOffsets[j]);
            theAggregators[j + 1].aggregate(resultsBuf, position + aggregatorOffsets[j + 1]);
            theAggregators[j + 2].aggregate(resultsBuf, position + aggregatorOffsets[j + 2]);
            theAggregators[j + 3].aggregate(resultsBuf, position + aggregatorOffsets[j + 3]);
            theAggregators[j + 4].aggregate(resultsBuf, position + aggregatorOffsets[j + 4]);
            theAggregators[j + 5].aggregate(resultsBuf, position + aggregatorOffsets[j + 5]);
            theAggregators[j + 6].aggregate(resultsBuf, position + aggregatorOffsets[j + 6]);
            theAggregators[j + 7].aggregate(resultsBuf, position + aggregatorOffsets[j + 7]);
        }
        return currentPosition;
    }

    @Override
    protected void updateResults(PooledTopNParams params, int[] positions, BufferAggregator[] theAggregators, TopNResultBuilder resultBuilder) {
        if (params.getCardinality() < 0) {
            throw new UnsupportedOperationException("Cannot operate on a dimension with unknown cardinality");
        }
        ByteBuffer resultsBuf = params.getResultsBuf();
        int[] aggregatorSizes = params.getAggregatorSizes();
        DimensionSelector dimSelector = params.getDimSelector();
        for (int i = 0; i < positions.length; ++i) {
            int position = positions[i];
            if (position < 0) continue;
            Object[] vals = new Object[theAggregators.length];
            for (int j = 0; j < theAggregators.length; ++j) {
                vals[j] = theAggregators[j].get(resultsBuf, position);
                position += aggregatorSizes[j];
            }
            resultBuilder.addEntry((Comparable)((Object)dimSelector.lookupName(i)), i, vals);
        }
    }

    @Override
    protected void closeAggregators(BufferAggregator[] bufferAggregators) {
        for (BufferAggregator agg : bufferAggregators) {
            agg.close();
        }
    }

    @Override
    public void cleanup(PooledTopNParams params) {
        if (params != null) {
            ResourceHolder<ByteBuffer> resultsBufHolder = params.getResultsBufHolder();
            if (resultsBufHolder != null) {
                resultsBufHolder.get().clear();
            }
            CloseableUtils.closeAndWrapExceptions(resultsBufHolder);
        }
    }

    static {
        PooledTopNAlgorithm.computeSpecializedScanAndAggregateImplementations();
    }

    public static class PooledTopNParams
    extends TopNParams {
        private final ResourceHolder<ByteBuffer> resultsBufHolder;
        private final ByteBuffer resultsBuf;
        private final int[] aggregatorSizes;
        private final int numBytesPerRecord;
        private final TopNMetricSpecBuilder<int[]> arrayProvider;

        public PooledTopNParams(ColumnSelectorPlus selectorPlus, Cursor cursor, ResourceHolder<ByteBuffer> resultsBufHolder, ByteBuffer resultsBuf, int[] aggregatorSizes, int numBytesPerRecord, int numValuesPerPass, TopNMetricSpecBuilder<int[]> arrayProvider) {
            super(selectorPlus, cursor, numValuesPerPass);
            this.resultsBufHolder = resultsBufHolder;
            this.resultsBuf = resultsBuf;
            this.aggregatorSizes = aggregatorSizes;
            this.numBytesPerRecord = numBytesPerRecord;
            this.arrayProvider = arrayProvider;
        }

        public static Builder builder() {
            return new Builder();
        }

        public ResourceHolder<ByteBuffer> getResultsBufHolder() {
            return this.resultsBufHolder;
        }

        public ByteBuffer getResultsBuf() {
            return this.resultsBuf;
        }

        public int[] getAggregatorSizes() {
            return this.aggregatorSizes;
        }

        public int getNumBytesPerRecord() {
            return this.numBytesPerRecord;
        }

        public TopNMetricSpecBuilder<int[]> getArrayProvider() {
            return this.arrayProvider;
        }

        public static class Builder {
            private ColumnSelectorPlus selectorPlus;
            private Cursor cursor;
            private ResourceHolder<ByteBuffer> resultsBufHolder;
            private ByteBuffer resultsBuf;
            private int[] aggregatorSizes;
            private int numBytesPerRecord;
            private int numValuesPerPass;
            private TopNMetricSpecBuilder<int[]> arrayProvider;

            public Builder withSelectorPlus(ColumnSelectorPlus selectorPlus) {
                this.selectorPlus = selectorPlus;
                return this;
            }

            public Builder withCursor(Cursor cursor) {
                this.cursor = cursor;
                return this;
            }

            public Builder withResultsBufHolder(ResourceHolder<ByteBuffer> resultsBufHolder) {
                this.resultsBufHolder = resultsBufHolder;
                return this;
            }

            public Builder withResultsBuf(ByteBuffer resultsBuf) {
                this.resultsBuf = resultsBuf;
                return this;
            }

            public Builder withAggregatorSizes(int[] aggregatorSizes) {
                this.aggregatorSizes = aggregatorSizes;
                return this;
            }

            public Builder withNumBytesPerRecord(int numBytesPerRecord) {
                this.numBytesPerRecord = numBytesPerRecord;
                return this;
            }

            public Builder withNumValuesPerPass(int numValuesPerPass) {
                this.numValuesPerPass = numValuesPerPass;
                return this;
            }

            public Builder withArrayProvider(TopNMetricSpecBuilder<int[]> arrayProvider) {
                this.arrayProvider = arrayProvider;
                return this;
            }

            public PooledTopNParams build() {
                return new PooledTopNParams(this.selectorPlus, this.cursor, this.resultsBufHolder, this.resultsBuf, this.aggregatorSizes, this.numBytesPerRecord, this.numValuesPerPass, this.arrayProvider);
            }
        }
    }

    private static interface ScanAndAggregate {
        public long scanAndAggregate(PooledTopNParams var1, int[] var2, BufferAggregator[] var3);
    }
}

