/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn.types;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.topn.BaseTopNAlgorithm;
import org.apache.druid.query.topn.TopNParams;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNResultBuilder;
import org.apache.druid.query.topn.types.TopNColumnAggregatesProcessor;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.IndexedInts;

public class StringTopNColumnAggregatesProcessor
implements TopNColumnAggregatesProcessor<DimensionSelector> {
    private final ColumnCapabilities capabilities;
    private final Function<Object, Comparable<?>> dimensionValueConverter;
    private HashMap<Comparable<?>, Aggregator[]> aggregatesStore;

    public StringTopNColumnAggregatesProcessor(ColumnCapabilities capabilities, ColumnType dimensionType) {
        this.capabilities = capabilities;
        this.dimensionValueConverter = DimensionHandlerUtils.converterFromTypeToType(ColumnType.STRING, dimensionType);
    }

    @Override
    public int getCardinality(DimensionSelector selector) {
        if (this.capabilities.isDictionaryEncoded().isTrue()) {
            return selector.getValueCardinality();
        }
        return -1;
    }

    @Override
    public Aggregator[][] getRowSelector(TopNQuery query, TopNParams params, StorageAdapter storageAdapter) {
        if (params.getCardinality() < 0) {
            throw new UnsupportedOperationException("Cannot operate on a dimension with unknown cardinality");
        }
        BaseTopNAlgorithm.AggregatorArrayProvider provider = new BaseTopNAlgorithm.AggregatorArrayProvider((DimensionSelector)params.getSelectorPlus().getSelector(), query, params.getCardinality(), storageAdapter);
        return provider.build();
    }

    @Override
    public void updateResults(TopNResultBuilder resultBuilder) {
        for (Map.Entry<Comparable<?>, Aggregator[]> entry : this.aggregatesStore.entrySet()) {
            Aggregator[] aggs = entry.getValue();
            if (aggs == null) continue;
            Object[] vals = new Object[aggs.length];
            for (int i = 0; i < aggs.length; ++i) {
                vals[i] = aggs[i].get();
            }
            Comparable<?> key = this.dimensionValueConverter.apply(entry.getKey());
            resultBuilder.addEntry(key, key, vals);
        }
    }

    @Override
    public void closeAggregators() {
        for (Aggregator[] aggregators : this.aggregatesStore.values()) {
            for (Aggregator agg : aggregators) {
                agg.close();
            }
        }
    }

    @Override
    public long scanAndAggregate(TopNQuery query, DimensionSelector selector, Cursor cursor, Aggregator[][] rowSelector) {
        boolean notUnknown = selector.getValueCardinality() != -1;
        boolean hasDictionary = this.capabilities.isDictionaryEncoded().isTrue();
        if (notUnknown && hasDictionary) {
            return this.scanAndAggregateWithCardinalityKnown(query, cursor, selector, rowSelector);
        }
        return this.scanAndAggregateWithCardinalityUnknown(query, cursor, selector);
    }

    @Override
    public void initAggregateStore() {
        this.aggregatesStore = new HashMap();
    }

    private long scanAndAggregateWithCardinalityKnown(TopNQuery query, Cursor cursor, DimensionSelector selector, Aggregator[][] rowSelector) {
        long processedRows = 0L;
        while (!cursor.isDone()) {
            IndexedInts dimValues = selector.getRow();
            int size = dimValues.size();
            for (int i = 0; i < size; ++i) {
                int dimIndex = dimValues.get(i);
                Aggregator[] aggs = rowSelector[dimIndex];
                if (aggs == null) {
                    Comparable<?> key = this.dimensionValueConverter.apply(selector.lookupName(dimIndex));
                    aggs = this.aggregatesStore.computeIfAbsent(key, k -> BaseTopNAlgorithm.makeAggregators(cursor, query.getAggregatorSpecs()));
                    rowSelector[dimIndex] = aggs;
                }
                for (Aggregator aggregator : aggs) {
                    aggregator.aggregate();
                }
            }
            cursor.advance();
            ++processedRows;
        }
        return processedRows;
    }

    private long scanAndAggregateWithCardinalityUnknown(TopNQuery query, Cursor cursor, DimensionSelector selector) {
        long processedRows = 0L;
        while (!cursor.isDone()) {
            IndexedInts dimValues = selector.getRow();
            int size = dimValues.size();
            for (int i = 0; i < size; ++i) {
                Aggregator[] aggs;
                int dimIndex = dimValues.get(i);
                Comparable<?> key = this.dimensionValueConverter.apply(selector.lookupName(dimIndex));
                for (Aggregator aggregator : aggs = this.aggregatesStore.computeIfAbsent(key, k -> BaseTopNAlgorithm.makeAggregators(cursor, query.getAggregatorSpecs()))) {
                    aggregator.aggregate();
                }
            }
            cursor.advance();
            ++processedRows;
        }
        return processedRows;
    }
}

