/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.filter.AndFilter;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class FilteredStorageAdapter
implements StorageAdapter {
    private final DimFilter filterOnDataSource;
    private final StorageAdapter baseStorageAdapter;

    public FilteredStorageAdapter(StorageAdapter adapter, DimFilter filter) {
        this.baseStorageAdapter = adapter;
        this.filterOnDataSource = filter;
    }

    @Override
    public Sequence<Cursor> makeCursors(@Nullable Filter filter, Interval interval, VirtualColumns virtualColumns, Granularity gran, boolean descending, @Nullable QueryMetrics<?> queryMetrics) {
        Filter andFilter = filter == null ? (this.filterOnDataSource != null ? this.filterOnDataSource.toFilter() : null) : new AndFilter((List<Filter>)ImmutableList.of((Object)filter, (Object)this.filterOnDataSource.toFilter()));
        return this.baseStorageAdapter.makeCursors(andFilter, interval, virtualColumns, gran, descending, queryMetrics);
    }

    @Override
    public Interval getInterval() {
        return this.baseStorageAdapter.getInterval();
    }

    @Override
    public Indexed<String> getAvailableDimensions() {
        return this.baseStorageAdapter.getAvailableDimensions();
    }

    @Override
    public Iterable<String> getAvailableMetrics() {
        return this.baseStorageAdapter.getAvailableMetrics();
    }

    @Override
    public int getDimensionCardinality(String column) {
        return this.baseStorageAdapter.getDimensionCardinality(column);
    }

    @Override
    public DateTime getMinTime() {
        return this.baseStorageAdapter.getMinTime();
    }

    @Override
    public DateTime getMaxTime() {
        return this.baseStorageAdapter.getMaxTime();
    }

    @Override
    @Nullable
    public Comparable getMinValue(String column) {
        return null;
    }

    @Override
    @Nullable
    public Comparable getMaxValue(String column) {
        return null;
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        return this.baseStorageAdapter.getColumnCapabilities(column);
    }

    @Override
    public int getNumRows() {
        return 0;
    }

    @Override
    public DateTime getMaxIngestedEventTime() {
        return this.baseStorageAdapter.getMaxIngestedEventTime();
    }

    @Override
    @Nullable
    public Metadata getMetadata() {
        return this.baseStorageAdapter.getMetadata();
    }
}

