/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.common.utils.SerializerUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ByteBufferWriter;
import org.apache.druid.segment.data.ColumnarLongsSerializer;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class LongColumnSerializerV2
implements GenericColumnSerializer<Object> {
    private final String columnName;
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final String filenameBase;
    private final ByteOrder byteOrder;
    private final CompressionStrategy compression;
    private final CompressionFactory.LongEncodingStrategy encoding;
    private final BitmapSerdeFactory bitmapSerdeFactory;
    private ColumnarLongsSerializer writer;
    private ByteBufferWriter<ImmutableBitmap> nullValueBitmapWriter;
    private MutableBitmap nullRowsBitmap;
    private int rowCount = 0;

    public static LongColumnSerializerV2 create(String columnName, SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, CompressionStrategy compression, CompressionFactory.LongEncodingStrategy encoding, BitmapSerdeFactory bitmapSerdeFactory) {
        return new LongColumnSerializerV2(columnName, segmentWriteOutMedium, filenameBase, IndexIO.BYTE_ORDER, compression, encoding, bitmapSerdeFactory);
    }

    private LongColumnSerializerV2(String columnName, SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, ByteOrder byteOrder, CompressionStrategy compression, CompressionFactory.LongEncodingStrategy encoding, BitmapSerdeFactory bitmapSerdeFactory) {
        this.columnName = columnName;
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.filenameBase = filenameBase;
        this.byteOrder = byteOrder;
        this.compression = compression;
        this.encoding = encoding;
        this.bitmapSerdeFactory = bitmapSerdeFactory;
    }

    @Override
    public void open() throws IOException {
        this.writer = CompressionFactory.getLongSerializer(this.columnName, this.segmentWriteOutMedium, StringUtils.format("%s.long_column", this.filenameBase), this.byteOrder, this.encoding, this.compression);
        this.writer.open();
        this.nullValueBitmapWriter = new ByteBufferWriter<ImmutableBitmap>(this.segmentWriteOutMedium, this.bitmapSerdeFactory.getObjectStrategy());
        this.nullValueBitmapWriter.open();
        this.nullRowsBitmap = this.bitmapSerdeFactory.getBitmapFactory().makeEmptyMutableBitmap();
    }

    @Override
    public void serialize(ColumnValueSelector<?> selector) throws IOException {
        if (selector.isNull()) {
            this.nullRowsBitmap.add(this.rowCount);
            this.writer.add(0L);
        } else {
            this.writer.add(selector.getLong());
        }
        ++this.rowCount;
    }

    @Override
    public long getSerializedSize() throws IOException {
        this.nullValueBitmapWriter.write(this.bitmapSerdeFactory.getBitmapFactory().makeImmutableBitmap(this.nullRowsBitmap));
        long bitmapSize = this.nullRowsBitmap.isEmpty() ? 0L : this.nullValueBitmapWriter.getSerializedSize();
        return 4L + this.writer.getSerializedSize() + bitmapSize;
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        SerializerUtils.writeInt(channel, Ints.checkedCast((long)this.writer.getSerializedSize()));
        this.writer.writeTo(channel, smoosher);
        if (!this.nullRowsBitmap.isEmpty()) {
            this.nullValueBitmapWriter.writeTo(channel, smoosher);
        }
    }
}

