/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PriorityQueue;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.segment.data.Indexed;

public class SimpleDictionaryMergingIterator<T extends Comparable<T>>
implements CloseableIterator<T> {
    protected final PriorityQueue<PeekingIterator<T>> pQueue;
    protected int counter;

    public static <T extends Comparable<T>> Comparator<PeekingIterator<T>> makePeekingComparator() {
        return (lhs, rhs) -> {
            Comparable left = (Comparable)lhs.peek();
            Comparable right = (Comparable)rhs.peek();
            if (left == null) {
                return right == null ? 0 : -1;
            }
            if (right == null) {
                return 1;
            }
            return left.compareTo(right);
        };
    }

    public SimpleDictionaryMergingIterator(Indexed<T>[] dimValueLookups, Comparator<PeekingIterator<T>> comparator) {
        this.pQueue = new PriorityQueue<PeekingIterator<T>>(dimValueLookups.length, comparator);
        for (Indexed<T> dimValueLookup : dimValueLookups) {
            PeekingIterator iter;
            if (dimValueLookup == null || !(iter = Iterators.peekingIterator(dimValueLookup.iterator())).hasNext()) continue;
            this.pQueue.add(iter);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.pQueue.isEmpty();
    }

    @Override
    public T next() {
        PeekingIterator smallest = (PeekingIterator)this.pQueue.remove();
        if (smallest == null) {
            throw new NoSuchElementException();
        }
        Comparable value = (Comparable)smallest.next();
        if (smallest.hasNext()) {
            this.pQueue.add(smallest);
        }
        while (!this.pQueue.isEmpty() && Objects.equals(value, this.pQueue.peek().peek())) {
            PeekingIterator same = (PeekingIterator)this.pQueue.remove();
            same.next();
            if (!same.hasNext()) continue;
            this.pQueue.add(same);
        }
        ++this.counter;
        return (T)value;
    }

    public int getCardinality() {
        return this.counter;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public void close() {
    }
}

