/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import javax.annotation.Nullable;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DimensionSelectorUtils;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.data.IndexedInts;
import org.joda.time.DateTime;

public class UnnestDimensionCursor
implements Cursor {
    private final Cursor baseCursor;
    private final DimensionSelector dimSelector;
    private final VirtualColumn unnestColumn;
    private final String outputName;
    private final ColumnSelectorFactory baseColumnSelectorFactory;
    private int index;
    @Nullable
    private IndexedInts indexedIntsForCurrentRow;
    private boolean needInitialization;
    private SingleIndexInts indexIntsForRow;

    public UnnestDimensionCursor(Cursor cursor, ColumnSelectorFactory baseColumnSelectorFactory, VirtualColumn unnestColumn, String outputColumnName) {
        this.baseCursor = cursor;
        this.baseColumnSelectorFactory = baseColumnSelectorFactory;
        this.dimSelector = unnestColumn.makeDimensionSelector(DefaultDimensionSpec.of(unnestColumn.getOutputName()), this.baseColumnSelectorFactory);
        this.unnestColumn = unnestColumn;
        this.index = 0;
        this.outputName = outputColumnName;
        this.needInitialization = true;
    }

    @Override
    public ColumnSelectorFactory getColumnSelectorFactory() {
        return new ColumnSelectorFactory(){

            @Override
            public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
                if (!UnnestDimensionCursor.this.outputName.equals(dimensionSpec.getDimension())) {
                    return UnnestDimensionCursor.this.baseColumnSelectorFactory.makeDimensionSelector(dimensionSpec);
                }
                return new DimensionSelector(){

                    @Override
                    public IndexedInts getRow() {
                        return UnnestDimensionCursor.this.indexIntsForRow;
                    }

                    @Override
                    public ValueMatcher makeValueMatcher(@Nullable String value) {
                        final int idForLookup = this.idLookup().lookupId(value);
                        if (idForLookup < 0) {
                            return new ValueMatcher(){

                                @Override
                                public boolean matches(boolean includeUnknown) {
                                    if (includeUnknown) {
                                        if (UnnestDimensionCursor.this.indexedIntsForCurrentRow == null || UnnestDimensionCursor.this.indexedIntsForCurrentRow.size() <= 0) {
                                            return true;
                                        }
                                        int rowId = UnnestDimensionCursor.this.indexedIntsForCurrentRow.get(UnnestDimensionCursor.this.index);
                                        return this.lookupName(rowId) == null;
                                    }
                                    return false;
                                }

                                @Override
                                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                                    inspector.visit("selector", UnnestDimensionCursor.this.dimSelector);
                                }
                            };
                        }
                        return new ValueMatcher(){

                            @Override
                            public boolean matches(boolean includeUnknown) {
                                if (UnnestDimensionCursor.this.indexedIntsForCurrentRow == null) {
                                    return includeUnknown;
                                }
                                if (UnnestDimensionCursor.this.indexedIntsForCurrentRow.size() <= 0) {
                                    return includeUnknown;
                                }
                                int rowId = UnnestDimensionCursor.this.indexedIntsForCurrentRow.get(UnnestDimensionCursor.this.index);
                                return includeUnknown && this.lookupName(rowId) == null || idForLookup == rowId;
                            }

                            @Override
                            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                                inspector.visit("selector", UnnestDimensionCursor.this.dimSelector);
                            }
                        };
                    }

                    @Override
                    public ValueMatcher makeValueMatcher(DruidPredicateFactory predicateFactory) {
                        return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, predicateFactory);
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        UnnestDimensionCursor.this.dimSelector.inspectRuntimeShape(inspector);
                    }

                    @Override
                    @Nullable
                    public Object getObject() {
                        if (UnnestDimensionCursor.this.indexedIntsForCurrentRow == null || UnnestDimensionCursor.this.indexedIntsForCurrentRow.size() == 0) {
                            return null;
                        }
                        return this.lookupName(UnnestDimensionCursor.this.indexedIntsForCurrentRow.get(UnnestDimensionCursor.this.index));
                    }

                    @Override
                    public Class<?> classOfObject() {
                        return Object.class;
                    }

                    @Override
                    public int getValueCardinality() {
                        return UnnestDimensionCursor.this.dimSelector.getValueCardinality();
                    }

                    @Override
                    @Nullable
                    public String lookupName(int id) {
                        return UnnestDimensionCursor.this.dimSelector.lookupName(id);
                    }

                    @Override
                    public boolean nameLookupPossibleInAdvance() {
                        return UnnestDimensionCursor.this.dimSelector.nameLookupPossibleInAdvance();
                    }

                    @Override
                    @Nullable
                    public IdLookup idLookup() {
                        return UnnestDimensionCursor.this.dimSelector.idLookup();
                    }
                };
            }

            @Override
            public ColumnValueSelector makeColumnValueSelector(String columnName) {
                if (!UnnestDimensionCursor.this.outputName.equals(columnName)) {
                    return UnnestDimensionCursor.this.baseColumnSelectorFactory.makeColumnValueSelector(columnName);
                }
                return this.makeDimensionSelector(DefaultDimensionSpec.of(columnName));
            }

            @Override
            @Nullable
            public ColumnCapabilities getColumnCapabilities(String column) {
                if (!UnnestDimensionCursor.this.outputName.equals(column)) {
                    return UnnestDimensionCursor.this.baseColumnSelectorFactory.getColumnCapabilities(column);
                }
                ColumnCapabilities capabilities = UnnestDimensionCursor.this.unnestColumn.capabilities(UnnestDimensionCursor.this.baseColumnSelectorFactory, UnnestDimensionCursor.this.unnestColumn.getOutputName());
                if (capabilities.isArray()) {
                    return ColumnCapabilitiesImpl.copyOf(capabilities).setType(capabilities.getElementType());
                }
                if (capabilities.hasMultipleValues().isTrue()) {
                    return ColumnCapabilitiesImpl.copyOf(capabilities).setHasMultipleValues(false);
                }
                return capabilities;
            }
        };
    }

    @Override
    public DateTime getTime() {
        return this.baseCursor.getTime();
    }

    @Override
    public void advance() {
        this.advanceUninterruptibly();
        BaseQuery.checkInterrupted();
    }

    @Override
    public void advanceUninterruptibly() {
        this.advanceAndUpdate();
    }

    @Override
    public boolean isDone() {
        if (this.needInitialization && !this.baseCursor.isDone()) {
            this.initialize();
        }
        return this.baseCursor.isDone();
    }

    @Override
    public boolean isDoneOrInterrupted() {
        if (this.needInitialization && !this.baseCursor.isDoneOrInterrupted()) {
            this.initialize();
        }
        return this.baseCursor.isDoneOrInterrupted();
    }

    @Override
    public void reset() {
        this.index = 0;
        this.needInitialization = true;
        this.baseCursor.reset();
    }

    @Nullable
    private void initialize() {
        this.index = 0;
        this.indexIntsForRow = new SingleIndexInts();
        if (this.dimSelector.getObject() != null) {
            this.indexedIntsForCurrentRow = this.dimSelector.getRow();
        }
        this.needInitialization = false;
    }

    private void advanceAndUpdate() {
        if (this.indexedIntsForCurrentRow == null) {
            this.index = 0;
            if (!this.baseCursor.isDone()) {
                this.baseCursor.advanceUninterruptibly();
                if (!this.baseCursor.isDone()) {
                    this.indexedIntsForCurrentRow = this.dimSelector.getRow();
                }
            }
        } else if (this.index >= this.indexedIntsForCurrentRow.size() - 1) {
            if (!this.baseCursor.isDone()) {
                this.baseCursor.advanceUninterruptibly();
            }
            if (!this.baseCursor.isDone()) {
                this.indexedIntsForCurrentRow = this.dimSelector.getRow();
            }
            this.index = 0;
        } else {
            ++this.index;
        }
    }

    private class SingleIndexInts
    implements IndexedInts {
        private SingleIndexInts() {
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public int get(int idx) {
            if (UnnestDimensionCursor.this.indexedIntsForCurrentRow != null && UnnestDimensionCursor.this.indexedIntsForCurrentRow.size() > 0) {
                return UnnestDimensionCursor.this.indexedIntsForCurrentRow.get(UnnestDimensionCursor.this.index);
            }
            return 0;
        }
    }
}

