/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.segment.column.BaseTypeSignature;
import org.apache.druid.segment.column.ColumnTypeFactory;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.column.ValueType;

@JsonSerialize(using=ToStringSerializer.class)
public class ColumnType
extends BaseTypeSignature<ValueType> {
    public static final ColumnType STRING = new ColumnType(ValueType.STRING, null, null);
    public static final ColumnType LONG = new ColumnType(ValueType.LONG, null, null);
    public static final ColumnType DOUBLE = new ColumnType(ValueType.DOUBLE, null, null);
    public static final ColumnType FLOAT = new ColumnType(ValueType.FLOAT, null, null);
    public static final ColumnType STRING_ARRAY = ColumnType.ofArray(STRING);
    public static final ColumnType LONG_ARRAY = ColumnType.ofArray(LONG);
    public static final ColumnType DOUBLE_ARRAY = ColumnType.ofArray(DOUBLE);
    public static final ColumnType FLOAT_ARRAY = ColumnType.ofArray(FLOAT);
    public static final ColumnType NESTED_DATA = ColumnType.ofComplex("json");
    public static final ColumnType UNKNOWN_COMPLEX = ColumnType.ofComplex(null);

    @JsonCreator
    public ColumnType(@JsonProperty(value="type") ValueType type, @JsonProperty(value="complexTypeName") @Nullable String complexTypeName, @JsonProperty(value="elementType") @Nullable ColumnType elementType) {
        super(ColumnTypeFactory.getInstance(), type, complexTypeName, elementType);
    }

    @Nullable
    @JsonCreator
    public static ColumnType fromString(@Nullable String typeName) {
        return Types.fromString(ColumnTypeFactory.getInstance(), typeName);
    }

    public static ColumnType ofArray(ColumnType elementType) {
        return ColumnTypeFactory.getInstance().ofArray(elementType);
    }

    public static ColumnType ofComplex(@Nullable String complexTypeName) {
        return ColumnTypeFactory.getInstance().ofComplex(complexTypeName);
    }

    @Nullable
    public static ColumnType leastRestrictiveType(@Nullable ColumnType type, @Nullable ColumnType other) throws Types.IncompatibleTypeException {
        if (type == null) {
            return other;
        }
        if (other == null) {
            return type;
        }
        if (type.is(ValueType.COMPLEX) && other.is(ValueType.COMPLEX)) {
            if (type.getComplexTypeName() == null) {
                return other;
            }
            if (other.getComplexTypeName() == null) {
                return type;
            }
            if (!Objects.equals(type, other)) {
                throw new Types.IncompatibleTypeException(type, other);
            }
            return type;
        }
        if (type.is(ValueType.COMPLEX) || other.is(ValueType.COMPLEX)) {
            if (NESTED_DATA.equals(type) || NESTED_DATA.equals(other)) {
                return NESTED_DATA;
            }
            throw new Types.IncompatibleTypeException(type, other);
        }
        if (type.isArray()) {
            if (other.equals(type.getElementType())) {
                return type;
            }
            if (other.isArray()) {
                ColumnType commonElementType = ColumnType.leastRestrictiveType((ColumnType)type.getElementType(), (ColumnType)other.getElementType());
                return ColumnType.ofArray(commonElementType);
            }
            ColumnType commonElementType = ColumnType.leastRestrictiveType((ColumnType)type.getElementType(), other);
            return ColumnType.ofArray(commonElementType);
        }
        if (other.isArray()) {
            if (type.equals(type.getElementType())) {
                return type;
            }
            ColumnType commonElementType = ColumnType.leastRestrictiveType(type, (ColumnType)other.getElementType());
            return ColumnType.ofArray(commonElementType);
        }
        if (Types.is(type, ValueType.STRING) || Types.is(other, ValueType.STRING)) {
            return STRING;
        }
        if (Types.is(type, ValueType.LONG) && Types.isNullOr(other, ValueType.LONG)) {
            return LONG;
        }
        if (Types.is(type, ValueType.FLOAT) && Types.isNullOr(other, ValueType.FLOAT)) {
            return FLOAT;
        }
        return DOUBLE;
    }
}

