/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import java.nio.ByteBuffer;
import java.util.Comparator;
import javax.annotation.Nullable;
import org.apache.druid.segment.column.TypeStrategy;

public final class NullableTypeStrategy<T>
implements Comparator<T> {
    private final TypeStrategy<T> delegate;
    private final Comparator<T> delegateComparator;

    public NullableTypeStrategy(TypeStrategy<T> delegate) {
        this.delegate = delegate;
        this.delegateComparator = Comparator.nullsFirst(delegate::compare);
    }

    public int estimateSizeBytes(@Nullable T value) {
        if (value == null) {
            return 1;
        }
        return 1 + this.delegate.estimateSizeBytes(value);
    }

    @Nullable
    public T read(ByteBuffer buffer) {
        if ((buffer.get() & 1) == 1) {
            return null;
        }
        return this.delegate.read(buffer);
    }

    public int write(ByteBuffer buffer, @Nullable T value, int maxSizeBytes) {
        int max = Math.min(buffer.limit() - buffer.position(), maxSizeBytes);
        int remaining = max - 1;
        if (remaining >= 0) {
            if (value == null) {
                buffer.put((byte)1);
                return 1;
            }
            buffer.put((byte)0);
            int written = this.delegate.write(buffer, value, maxSizeBytes - 1);
            return written < 0 ? written : 1 + written;
        }
        if (value == null) {
            return remaining;
        }
        return remaining + this.delegate.write(buffer, value, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T read(ByteBuffer buffer, int offset) {
        int oldPosition = buffer.position();
        try {
            T value;
            buffer.position(offset);
            T t = value = this.read(buffer);
            return t;
        }
        finally {
            buffer.position(oldPosition);
        }
    }

    public boolean readRetainsBufferReference() {
        return this.delegate.readRetainsBufferReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer buffer, int offset, @Nullable T value, int maxSizeBytes) {
        int oldPosition = buffer.position();
        try {
            buffer.position(offset);
            int n = this.write(buffer, value, maxSizeBytes);
            return n;
        }
        finally {
            buffer.position(oldPosition);
        }
    }

    @Override
    public int compare(T o1, T o2) {
        return this.delegateComparator.compare(o1, o2);
    }
}

