/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.Supplier;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.segment.data.CompressedBlockReader;
import org.apache.druid.segment.data.CompressedLongsReader;
import org.apache.druid.segment.data.CompressedVariableSizedBlobColumn;
import org.apache.druid.segment.data.CompressedVariableSizedBlobColumnSerializer;

public class CompressedVariableSizedBlobColumnSupplier
implements Supplier<CompressedVariableSizedBlobColumn> {
    public static final byte VERSION = 1;
    private final int numElements;
    private final Supplier<CompressedLongsReader> offsetReaderSupplier;
    private final Supplier<CompressedBlockReader> blockDataReaderSupplier;

    public static CompressedVariableSizedBlobColumnSupplier fromByteBuffer(String filenameBase, ByteBuffer buffer, ByteOrder order, SmooshedFileMapper mapper) throws IOException {
        byte versionFromBuffer = buffer.get();
        if (versionFromBuffer == 1) {
            int numElements = buffer.getInt();
            ByteBuffer offsetsBuffer = mapper.mapFile(CompressedVariableSizedBlobColumnSerializer.getCompressedOffsetsFileName(filenameBase));
            ByteBuffer dataBuffer = mapper.mapFile(CompressedVariableSizedBlobColumnSerializer.getCompressedBlobsFileName(filenameBase));
            return new CompressedVariableSizedBlobColumnSupplier(offsetsBuffer, dataBuffer, order, numElements);
        }
        throw new IAE("Unknown version[%s]", versionFromBuffer);
    }

    public CompressedVariableSizedBlobColumnSupplier(ByteBuffer offsetsBuffer, ByteBuffer dataBuffer, ByteOrder order, int numElements) {
        this.numElements = numElements;
        this.offsetReaderSupplier = CompressedLongsReader.fromByteBuffer(offsetsBuffer, order);
        this.blockDataReaderSupplier = CompressedBlockReader.fromByteBuffer(dataBuffer, order);
    }

    @Override
    public CompressedVariableSizedBlobColumn get() {
        return new CompressedVariableSizedBlobColumn(this.numElements, this.offsetReaderSupplier.get(), this.blockDataReaderSupplier.get());
    }
}

