/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.JavaScriptDimFilter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.index.BitmapColumnIndex;

public class JavaScriptFilter
implements Filter {
    private final String dimension;
    private final JavaScriptDimFilter.JavaScriptPredicateFactory predicateFactory;
    private final FilterTuning filterTuning;

    public JavaScriptFilter(String dimension, JavaScriptDimFilter.JavaScriptPredicateFactory predicate, FilterTuning filterTuning) {
        this.dimension = dimension;
        this.predicateFactory = predicate;
        this.filterTuning = filterTuning;
    }

    @Override
    @Nullable
    public BitmapColumnIndex getBitmapColumnIndex(ColumnIndexSelector selector) {
        if (!Filters.checkFilterTuningUseIndex(this.dimension, selector, this.filterTuning)) {
            return null;
        }
        return Filters.makePredicateIndex(this.dimension, selector, this.predicateFactory);
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return Filters.makeValueMatcher(factory, this.dimension, this.predicateFactory);
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ImmutableSet.of((Object)this.dimension);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaScriptFilter that = (JavaScriptFilter)o;
        return Objects.equals(this.dimension, that.dimension) && Objects.equals(this.predicateFactory, that.predicateFactory) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.predicateFactory, this.filterTuning);
    }
}

