/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.Exprs;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.segment.join.Equality;

public class JoinConditionAnalysis {
    private final String originalExpression;
    private final String rightPrefix;
    private final List<Equality> equiConditions;
    private final List<Expr> nonEquiConditions;
    private final boolean isAlwaysFalse;
    private final boolean isAlwaysTrue;
    private final boolean canHashJoin;
    private final Set<String> rightKeyColumns;
    private final Set<String> requiredColumns;

    private JoinConditionAnalysis(String originalExpression, String rightPrefix, List<Equality> equiConditions, List<Expr> nonEquiConditions) {
        this.originalExpression = (String)Preconditions.checkNotNull((Object)originalExpression, (Object)"originalExpression");
        this.rightPrefix = (String)Preconditions.checkNotNull((Object)rightPrefix, (Object)"rightPrefix");
        this.equiConditions = Collections.unmodifiableList(equiConditions);
        this.nonEquiConditions = Collections.unmodifiableList(nonEquiConditions);
        this.isAlwaysFalse = nonEquiConditions.stream().anyMatch(expr -> expr.isLiteral() && !expr.eval(InputBindings.nilBindings()).asBoolean());
        this.isAlwaysTrue = equiConditions.isEmpty() && nonEquiConditions.stream().allMatch(expr -> expr.isLiteral() && expr.eval(InputBindings.nilBindings()).asBoolean());
        this.canHashJoin = nonEquiConditions.stream().allMatch(Expr::isLiteral);
        this.rightKeyColumns = this.getEquiConditions().stream().map(Equality::getRightColumn).collect(Collectors.toSet());
        this.requiredColumns = JoinConditionAnalysis.computeRequiredColumns(rightPrefix, equiConditions, nonEquiConditions);
    }

    public static JoinConditionAnalysis forExpression(String condition, String rightPrefix, ExprMacroTable macroTable) {
        return JoinConditionAnalysis.forExpression(condition, Parser.parse(condition, macroTable), rightPrefix);
    }

    public static JoinConditionAnalysis forExpression(String condition, Expr conditionExpr, String rightPrefix) {
        ArrayList<Equality> equiConditions = new ArrayList<Equality>();
        ArrayList<Expr> nonEquiConditions = new ArrayList<Expr>();
        List<Expr> exprs = Exprs.decomposeAnd(conditionExpr);
        for (Expr childExpr : exprs) {
            Optional<Equality> maybeEquality = Exprs.decomposeEquals(childExpr, rightPrefix);
            if (!maybeEquality.isPresent()) {
                nonEquiConditions.add(childExpr);
                continue;
            }
            equiConditions.add(maybeEquality.get());
        }
        return new JoinConditionAnalysis(condition, rightPrefix, equiConditions, nonEquiConditions);
    }

    public String getOriginalExpression() {
        return this.originalExpression;
    }

    public List<Equality> getEquiConditions() {
        return this.equiConditions;
    }

    public List<Expr> getNonEquiConditions() {
        return this.nonEquiConditions;
    }

    public boolean isAlwaysFalse() {
        return this.isAlwaysFalse;
    }

    public boolean isAlwaysTrue() {
        return this.isAlwaysTrue;
    }

    public boolean canHashJoin() {
        return this.canHashJoin;
    }

    public Set<String> getRightEquiConditionKeys() {
        return this.rightKeyColumns;
    }

    public Set<String> getRequiredColumns() {
        return this.requiredColumns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinConditionAnalysis that = (JoinConditionAnalysis)o;
        return Objects.equals(this.originalExpression, that.originalExpression) && Objects.equals(this.rightPrefix, that.rightPrefix);
    }

    public int hashCode() {
        return Objects.hash(this.originalExpression, this.rightPrefix);
    }

    public String toString() {
        return this.originalExpression;
    }

    private static Set<String> computeRequiredColumns(String rightPrefix, List<Equality> equiConditions, List<Expr> nonEquiConditions) {
        HashSet<String> requiredColumns = new HashSet<String>();
        for (Equality equality : equiConditions) {
            requiredColumns.add(rightPrefix + equality.getRightColumn());
            requiredColumns.addAll(equality.getLeftExpr().analyzeInputs().getRequiredBindings());
        }
        for (Expr expr : nonEquiConditions) {
            requiredColumns.addAll(expr.analyzeInputs().getRequiredBindings());
        }
        return requiredColumns;
    }
}

