/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.primitives.Ints;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import javax.annotation.Nullable;
import org.apache.druid.annotations.SuppressFBWarnings;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.ByteBufferUtils;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.druid.segment.column.StringEncodingStrategies;
import org.apache.druid.segment.column.TypeStrategies;
import org.apache.druid.segment.data.DictionaryWriter;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.FrontCodedIntArrayIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.nested.NestedCommonFormatColumnSerializer;

public final class DictionaryIdLookup
implements Closeable {
    private final String name;
    private final Path tempBasePath;
    @Nullable
    private final DictionaryWriter<String> stringDictionaryWriter;
    private Path stringDictionaryFile = null;
    private SmooshedFileMapper stringBufferMapper = null;
    private Indexed<ByteBuffer> stringDictionary = null;
    @Nullable
    private final DictionaryWriter<Long> longDictionaryWriter;
    private Path longDictionaryFile = null;
    private MappedByteBuffer longBuffer = null;
    private FixedIndexed<Long> longDictionary = null;
    @Nullable
    private final DictionaryWriter<Double> doubleDictionaryWriter;
    private Path doubleDictionaryFile = null;
    MappedByteBuffer doubleBuffer = null;
    FixedIndexed<Double> doubleDictionary = null;
    @Nullable
    private final DictionaryWriter<int[]> arrayDictionaryWriter;
    private Path arrayDictionaryFile = null;
    private MappedByteBuffer arrayBuffer = null;
    private FrontCodedIntArrayIndexed arrayDictionary = null;

    public DictionaryIdLookup(String name, Path tempBasePath, @Nullable DictionaryWriter<String> stringDictionaryWriter, @Nullable DictionaryWriter<Long> longDictionaryWriter, @Nullable DictionaryWriter<Double> doubleDictionaryWriter, @Nullable DictionaryWriter<int[]> arrayDictionaryWriter) {
        this.name = name;
        this.tempBasePath = tempBasePath;
        this.stringDictionaryWriter = stringDictionaryWriter;
        this.longDictionaryWriter = longDictionaryWriter;
        this.doubleDictionaryWriter = doubleDictionaryWriter;
        this.arrayDictionaryWriter = arrayDictionaryWriter;
    }

    public int lookupString(@Nullable String value) {
        byte[] bytes;
        int index;
        if (this.stringDictionary == null) {
            File stringSmoosh = FileUtils.createTempDirInLocation(this.tempBasePath, StringUtils.urlEncode(this.name) + "__stringTempSmoosh");
            this.stringDictionaryFile = stringSmoosh.toPath();
            String fileName = NestedCommonFormatColumnSerializer.getInternalFileName(this.name, "__stringDictionary");
            try (FileSmoosher smoosher = new FileSmoosher(stringSmoosh);
                 SmooshedWriter writer = smoosher.addWithSmooshedWriter(fileName, this.stringDictionaryWriter.getSerializedSize());){
                this.stringDictionaryWriter.writeTo(writer, smoosher);
                writer.close();
                smoosher.close();
                this.stringBufferMapper = SmooshedFileMapper.load(stringSmoosh);
                ByteBuffer stringBuffer = this.stringBufferMapper.mapFile(fileName);
                this.stringDictionary = (Indexed)StringEncodingStrategies.getStringDictionarySupplier(this.stringBufferMapper, stringBuffer, ByteOrder.nativeOrder()).get();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if ((index = this.stringDictionary.indexOf((bytes = StringUtils.toUtf8Nullable(value)) == null ? null : ByteBuffer.wrap(bytes))) < 0) {
            throw DruidException.defensive("Value not found in column[%s] string dictionary", this.name);
        }
        return index;
    }

    public int lookupLong(@Nullable Long value) {
        int index;
        if (this.longDictionary == null) {
            this.longDictionaryFile = this.makeTempFile(this.name + "__longDictionary");
            this.longBuffer = this.mapWriter(this.longDictionaryFile, this.longDictionaryWriter);
            this.longDictionary = (FixedIndexed)FixedIndexed.read(this.longBuffer, TypeStrategies.LONG, ByteOrder.nativeOrder(), 8).get();
            this.longBuffer.position(0);
        }
        if ((index = this.longDictionary.indexOf(value)) < 0) {
            throw DruidException.defensive("Value not found in column[%s] long dictionary", this.name);
        }
        return index + this.longOffset();
    }

    public int lookupDouble(@Nullable Double value) {
        int index;
        if (this.doubleDictionary == null) {
            this.doubleDictionaryFile = this.makeTempFile(this.name + "__doubleDictionary");
            this.doubleBuffer = this.mapWriter(this.doubleDictionaryFile, this.doubleDictionaryWriter);
            this.doubleDictionary = (FixedIndexed)FixedIndexed.read(this.doubleBuffer, TypeStrategies.DOUBLE, ByteOrder.nativeOrder(), 8).get();
            this.doubleBuffer.position(0);
        }
        if ((index = this.doubleDictionary.indexOf(value)) < 0) {
            throw DruidException.defensive("Value not found in column[%s] double dictionary", this.name);
        }
        return index + this.doubleOffset();
    }

    public int lookupArray(@Nullable int[] value) {
        int index;
        if (this.arrayDictionary == null) {
            this.arrayDictionaryFile = this.makeTempFile(this.name + "__arrayDictionary");
            this.arrayBuffer = this.mapWriter(this.arrayDictionaryFile, this.arrayDictionaryWriter);
            this.arrayDictionary = (FrontCodedIntArrayIndexed)FrontCodedIntArrayIndexed.read(this.arrayBuffer, ByteOrder.nativeOrder()).get();
            this.arrayBuffer.position(0);
        }
        if ((index = this.arrayDictionary.indexOf(value)) < 0) {
            throw DruidException.defensive("Value not found in column[%s] array dictionary", this.name);
        }
        return index + this.arrayOffset();
    }

    @Nullable
    public SmooshedFileMapper getStringBufferMapper() {
        return this.stringBufferMapper;
    }

    @Nullable
    public ByteBuffer getLongBuffer() {
        return this.longBuffer;
    }

    @Nullable
    public ByteBuffer getDoubleBuffer() {
        return this.doubleBuffer;
    }

    @Nullable
    public ByteBuffer getArrayBuffer() {
        return this.arrayBuffer;
    }

    @Override
    public void close() {
        if (this.stringBufferMapper != null) {
            this.stringBufferMapper.close();
            this.deleteTempFile(this.stringDictionaryFile);
        }
        if (this.longBuffer != null) {
            ByteBufferUtils.unmap(this.longBuffer);
            this.deleteTempFile(this.longDictionaryFile);
        }
        if (this.doubleBuffer != null) {
            ByteBufferUtils.unmap(this.doubleBuffer);
            this.deleteTempFile(this.doubleDictionaryFile);
        }
        if (this.arrayBuffer != null) {
            ByteBufferUtils.unmap(this.arrayBuffer);
            this.deleteTempFile(this.arrayDictionaryFile);
        }
    }

    private int longOffset() {
        return this.stringDictionaryWriter != null ? this.stringDictionaryWriter.getCardinality() : 0;
    }

    private int doubleOffset() {
        return this.longOffset() + (this.longDictionaryWriter != null ? this.longDictionaryWriter.getCardinality() : 0);
    }

    private int arrayOffset() {
        return this.doubleOffset() + (this.doubleDictionaryWriter != null ? this.doubleDictionaryWriter.getCardinality() : 0);
    }

    private Path makeTempFile(String name) {
        try {
            return Files.createTempFile(this.tempBasePath, StringUtils.urlEncode(name), null, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void deleteTempFile(Path path) {
        try {
            File file = path.toFile();
            if (file.isDirectory()) {
                FileUtils.deleteDirectory(file);
            } else {
                Files.delete(path);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    private MappedByteBuffer mapWriter(Path path, DictionaryWriter<?> writer) {
        EnumSet<StandardOpenOption> options = EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        try (FileChannel fileChannel = FileChannel.open(path, options, new FileAttribute[0]);){
            MappedByteBuffer mappedByteBuffer;
            block14: {
                GatheringByteChannel smooshChannel = this.makeWriter(fileChannel, writer.getSerializedSize());
                try {
                    writer.writeTo(smooshChannel, null);
                    mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, writer.getSerializedSize());
                    if (smooshChannel == null) break block14;
                }
                catch (Throwable throwable) {
                    if (smooshChannel != null) {
                        try {
                            smooshChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                smooshChannel.close();
            }
            return mappedByteBuffer;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private GatheringByteChannel makeWriter(final FileChannel channel, final long size) {
        return new GatheringByteChannel(){
            private boolean isClosed = false;
            private long currOffset = 0L;

            @Override
            public boolean isOpen() {
                return !this.isClosed;
            }

            @Override
            public void close() throws IOException {
                channel.close();
                this.isClosed = true;
            }

            public int bytesLeft() {
                return (int)(size - this.currOffset);
            }

            @Override
            public int write(ByteBuffer buffer) throws IOException {
                return this.addToOffset(channel.write(buffer));
            }

            @Override
            public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
                return this.addToOffset(channel.write(srcs, offset, length));
            }

            @Override
            public long write(ByteBuffer[] srcs) throws IOException {
                return this.addToOffset(channel.write(srcs));
            }

            public int addToOffset(long numBytesWritten) {
                if (numBytesWritten > (long)this.bytesLeft()) {
                    throw DruidException.defensive("Wrote more bytes[%,d] than available[%,d]. Don't do that.", numBytesWritten, this.bytesLeft());
                }
                this.currOffset += numBytesWritten;
                return Ints.checkedCast((long)numBytesWritten);
            }
        };
    }
}

