/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.vector;

import com.google.common.base.Preconditions;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.druid.query.filter.vector.VectorMatch;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorOffset;

public class FilteredVectorOffset
implements VectorOffset {
    private final VectorOffset baseOffset;
    private final VectorValueMatcher filterMatcher;
    private final int[] offsets;
    private int currentVectorSize = 0;
    private boolean allTrue = false;

    private FilteredVectorOffset(VectorOffset baseOffset, VectorValueMatcher filterMatcher) {
        this.baseOffset = baseOffset;
        this.filterMatcher = filterMatcher;
        this.offsets = new int[baseOffset.getMaxVectorSize()];
        this.advanceWhileVectorIsEmptyAndPopulateOffsets();
    }

    public static FilteredVectorOffset create(VectorOffset baseOffset, VectorColumnSelectorFactory baseColumnSelectorFactory, Filter filter) {
        Preconditions.checkState((boolean)filter.canVectorizeMatcher(baseColumnSelectorFactory), (Object)"Cannot vectorize");
        VectorValueMatcher filterMatcher = filter.makeVectorMatcher(baseColumnSelectorFactory);
        return new FilteredVectorOffset(baseOffset, filterMatcher);
    }

    @Override
    public int getId() {
        Preconditions.checkState((this.currentVectorSize > 0 ? 1 : 0) != 0, (Object)"currentVectorSize > 0");
        return this.baseOffset.getId();
    }

    @Override
    public void advance() {
        this.baseOffset.advance();
        this.advanceWhileVectorIsEmptyAndPopulateOffsets();
    }

    @Override
    public boolean isDone() {
        return this.currentVectorSize == 0;
    }

    @Override
    public boolean isContiguous() {
        return this.allTrue && this.baseOffset.isContiguous();
    }

    @Override
    public int getMaxVectorSize() {
        return this.baseOffset.getMaxVectorSize();
    }

    @Override
    public int getCurrentVectorSize() {
        return this.currentVectorSize;
    }

    @Override
    public int getStartOffset() {
        if (this.isContiguous()) {
            return this.baseOffset.getStartOffset();
        }
        throw new ISE("Cannot call getStartOffset when not contiguous!", new Object[0]);
    }

    @Override
    public int[] getOffsets() {
        if (this.isContiguous()) {
            throw new ISE("Cannot call getOffsets when not contiguous!", new Object[0]);
        }
        if (this.allTrue) {
            return this.baseOffset.getOffsets();
        }
        return this.offsets;
    }

    private void advanceWhileVectorIsEmptyAndPopulateOffsets() {
        this.allTrue = false;
        int j = 0;
        while (j == 0) {
            int i;
            if (this.baseOffset.isDone()) {
                this.currentVectorSize = 0;
                return;
            }
            ReadableVectorMatch match = this.filterMatcher.match(VectorMatch.allTrue(this.baseOffset.getCurrentVectorSize()), false);
            if (match.isAllTrue(this.baseOffset.getCurrentVectorSize())) {
                this.currentVectorSize = this.baseOffset.getCurrentVectorSize();
                this.allTrue = true;
                return;
            }
            if (match.isAllFalse()) {
                this.baseOffset.advance();
                continue;
            }
            int[] selection = match.getSelection();
            int selectionSize = match.getSelectionSize();
            if (this.baseOffset.isContiguous()) {
                int startOffset = this.baseOffset.getStartOffset();
                for (i = 0; i < selectionSize; ++i) {
                    this.offsets[j++] = startOffset + selection[i];
                }
            } else {
                int[] baseOffsets = this.baseOffset.getOffsets();
                for (i = 0; i < selectionSize; ++i) {
                    this.offsets[j++] = baseOffsets[selection[i]];
                }
            }
            if (j != 0) continue;
            this.baseOffset.advance();
        }
        this.currentVectorSize = j;
    }

    @Override
    public void reset() {
        this.currentVectorSize = 0;
        this.allTrue = false;
        this.baseOffset.reset();
        this.advanceWhileVectorIsEmptyAndPopulateOffsets();
    }
}

