/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.timeline.partition.BuildingShardSpec;
import org.apache.druid.timeline.partition.DimensionRangeShardSpec;
import org.apache.druid.timeline.partition.NumberedPartitionChunk;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.SingleDimensionShardSpec;

public class BuildingDimensionRangeShardSpec
implements BuildingShardSpec<DimensionRangeShardSpec> {
    private final int bucketId;
    private final List<String> dimensions;
    @Nullable
    private final StringTuple start;
    @Nullable
    private final StringTuple end;
    private final int partitionId;

    @JsonCreator
    public BuildingDimensionRangeShardSpec(@JsonProperty(value="bucketId") int bucketId, @JsonProperty(value="dimensions") List<String> dimensions, @JsonProperty(value="start") @Nullable StringTuple start, @JsonProperty(value="end") @Nullable StringTuple end, @JsonProperty(value="partitionNum") int partitionNum) {
        this.bucketId = bucketId;
        this.dimensions = dimensions;
        this.start = start;
        this.end = end;
        this.partitionId = partitionNum;
    }

    @JsonProperty(value="dimensions")
    public List<String> getDimensions() {
        return this.dimensions;
    }

    @Nullable
    @JsonProperty(value="start")
    public StringTuple getStartTuple() {
        return this.start;
    }

    @Nullable
    @JsonProperty(value="end")
    public StringTuple getEndTuple() {
        return this.end;
    }

    @Override
    @JsonProperty(value="partitionNum")
    public int getPartitionNum() {
        return this.partitionId;
    }

    @Override
    @JsonProperty(value="bucketId")
    public int getBucketId() {
        return this.bucketId;
    }

    @Override
    public DimensionRangeShardSpec convert(int numCorePartitions) {
        return this.dimensions != null && this.dimensions.size() == 1 ? new SingleDimensionShardSpec(this.dimensions.get(0), StringTuple.firstOrNull(this.start), StringTuple.firstOrNull(this.end), this.partitionId, (Integer)numCorePartitions) : new DimensionRangeShardSpec(this.dimensions, this.start, this.end, this.partitionId, numCorePartitions);
    }

    @Override
    public <T> PartitionChunk<T> createChunk(T obj) {
        return new NumberedPartitionChunk<T>(this.partitionId, 0, obj);
    }

    @Override
    public String getType() {
        return "building_range";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildingDimensionRangeShardSpec that = (BuildingDimensionRangeShardSpec)o;
        return this.bucketId == that.bucketId && this.partitionId == that.partitionId && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end);
    }

    public int hashCode() {
        return Objects.hash(this.bucketId, this.dimensions, this.start, this.end, this.partitionId);
    }

    public String toString() {
        return "BuildingDimensionRangeShardSpec{bucketId=" + this.bucketId + ", dimension='" + this.dimensions + '\'' + ", start='" + this.start + '\'' + ", end='" + this.end + '\'' + ", partitionNum=" + this.partitionId + '}';
    }
}

