/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.timeline.partition.BaseDimensionRangeShardSpec;
import org.apache.druid.timeline.partition.BucketNumberedShardSpec;
import org.apache.druid.timeline.partition.BuildingSingleDimensionShardSpec;

public class SingleDimensionRangeBucketShardSpec
extends BaseDimensionRangeShardSpec
implements BucketNumberedShardSpec<BuildingSingleDimensionShardSpec> {
    private final int bucketId;
    private final String dimension;
    @Nullable
    private final String start;
    @Nullable
    private final String end;

    @JsonCreator
    public SingleDimensionRangeBucketShardSpec(@JsonProperty(value="bucketId") int bucketId, @JsonProperty(value="dimension") String dimension, @JsonProperty(value="start") @Nullable String start, @JsonProperty(value="end") @Nullable String end) {
        super(dimension == null ? Collections.emptyList() : Collections.singletonList(dimension), start == null ? null : StringTuple.create(start), end == null ? null : StringTuple.create(end));
        this.bucketId = bucketId;
        this.dimension = dimension;
        this.start = start;
        this.end = end;
    }

    @Override
    @JsonProperty
    public int getBucketId() {
        return this.bucketId;
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @Nullable
    @JsonProperty
    public String getStart() {
        return this.start;
    }

    @Nullable
    @JsonProperty
    public String getEnd() {
        return this.end;
    }

    @Override
    public BuildingSingleDimensionShardSpec convert(int partitionId) {
        return new BuildingSingleDimensionShardSpec(this.bucketId, this.dimension, this.start, this.end, partitionId);
    }

    @Override
    public String getType() {
        return "bucket_single_dim";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleDimensionRangeBucketShardSpec bucket = (SingleDimensionRangeBucketShardSpec)o;
        return this.bucketId == bucket.bucketId && Objects.equals(this.dimension, bucket.dimension) && Objects.equals(this.start, bucket.start) && Objects.equals(this.end, bucket.end);
    }

    public int hashCode() {
        return Objects.hash(this.bucketId, this.dimension, this.start, this.end);
    }

    public String toString() {
        return "SingleDimensionRangeBucketShardSpec{, bucketId=" + this.bucketId + ", dimension='" + this.dimension + '\'' + ", start='" + this.start + '\'' + ", end='" + this.end + '\'' + '}';
    }
}

