/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.ReferenceCountingResourceHolder;
import org.apache.druid.java.util.common.ISE;

public class DefaultBlockingPool<T>
implements BlockingPool<T> {
    private static final TimeUnit TIME_UNIT = TimeUnit.MILLISECONDS;
    @VisibleForTesting
    final ArrayDeque<T> objects;
    private final ReentrantLock lock;
    private final Condition notEnough;
    private final int maxSize;
    private final AtomicLong pendingRequests;

    public DefaultBlockingPool(Supplier<T> generator, int limit) {
        this.objects = new ArrayDeque(limit);
        this.maxSize = limit;
        for (int i = 0; i < limit; ++i) {
            this.objects.add(generator.get());
        }
        this.lock = new ReentrantLock();
        this.notEnough = this.lock.newCondition();
        this.pendingRequests = new AtomicLong();
    }

    @Override
    public int maxSize() {
        return this.maxSize;
    }

    @VisibleForTesting
    public int getPoolSize() {
        return this.objects.size();
    }

    @Nullable
    private ReferenceCountingResourceHolder<T> wrapObject(T theObject) {
        return theObject == null ? null : new ReferenceCountingResourceHolder<T>(theObject, () -> this.offer(theObject));
    }

    @Override
    public List<ReferenceCountingResourceHolder<T>> takeBatch(int elementNum, long timeoutMs) {
        Preconditions.checkArgument((timeoutMs >= 0L ? 1 : 0) != 0, (String)"timeoutMs must be a non-negative value, but was [%s]", (long)timeoutMs);
        this.checkInitialized();
        try {
            this.pendingRequests.incrementAndGet();
            List<T> objects = timeoutMs > 0L ? this.pollObjects(elementNum, timeoutMs) : this.pollObjects(elementNum);
            List<ReferenceCountingResourceHolder<T>> list = objects.stream().map(this::wrapObject).collect(Collectors.toList());
            return list;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.pendingRequests.decrementAndGet();
        }
    }

    @Override
    public List<ReferenceCountingResourceHolder<T>> takeBatch(int elementNum) {
        this.checkInitialized();
        try {
            this.pendingRequests.incrementAndGet();
            List<ReferenceCountingResourceHolder<T>> list = this.takeObjects(elementNum).stream().map(this::wrapObject).collect(Collectors.toList());
            return list;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.pendingRequests.incrementAndGet();
        }
    }

    @Override
    public long getPendingRequests() {
        return this.pendingRequests.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<T> pollObjects(int elementNum) throws InterruptedException {
        ArrayList<T> list = new ArrayList<T>(elementNum);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            if (this.objects.size() < elementNum) {
                List list2 = Collections.emptyList();
                return list2;
            }
            for (int i = 0; i < elementNum; ++i) {
                list.add(this.objects.pop());
            }
            ArrayList<T> arrayList = list;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<T> pollObjects(int elementNum, long timeoutMs) throws InterruptedException {
        long nanos = TIME_UNIT.toNanos(timeoutMs);
        ArrayList<T> list = new ArrayList<T>(elementNum);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.objects.size() < elementNum) {
                if (nanos <= 0L) {
                    List list2 = Collections.emptyList();
                    return list2;
                }
                nanos = this.notEnough.awaitNanos(nanos);
            }
            for (int i = 0; i < elementNum; ++i) {
                list.add(this.objects.pop());
            }
            ArrayList<T> arrayList = list;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<T> takeObjects(int elementNum) throws InterruptedException {
        ArrayList<T> list = new ArrayList<T>(elementNum);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.objects.size() < elementNum) {
                this.notEnough.await();
            }
            for (int i = 0; i < elementNum; ++i) {
                list.add(this.objects.pop());
            }
            ArrayList<T> arrayList = list;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    private void checkInitialized() {
        Preconditions.checkState((this.maxSize > 0 ? 1 : 0) != 0, (Object)"Pool was initialized with limit = 0, there are no objects to take.");
    }

    private void offer(T theObject) {
        block4: {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                if (this.objects.size() < this.maxSize) {
                    this.objects.push(theObject);
                    this.notEnough.signal();
                    break block4;
                }
                throw new ISE("Cannot exceed pre-configured maximum size", new Object[0]);
            }
            finally {
                lock.unlock();
            }
        }
    }
}

