/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.read.columnar;

import org.apache.druid.frame.read.columnar.ComplexFrameColumnReader;
import org.apache.druid.frame.read.columnar.DoubleArrayFrameColumnReader;
import org.apache.druid.frame.read.columnar.DoubleFrameColumnReader;
import org.apache.druid.frame.read.columnar.FloatArrayFrameColumnReader;
import org.apache.druid.frame.read.columnar.FloatFrameColumnReader;
import org.apache.druid.frame.read.columnar.FrameColumnReader;
import org.apache.druid.frame.read.columnar.LongArrayFrameColumnReader;
import org.apache.druid.frame.read.columnar.LongFrameColumnReader;
import org.apache.druid.frame.read.columnar.StringFrameColumnReader;
import org.apache.druid.frame.read.columnar.UnsupportedColumnTypeFrameColumnReader;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;

public class FrameColumnReaders {
    private FrameColumnReaders() {
    }

    public static FrameColumnReader create(String columnName, int columnNumber, ColumnType columnType) {
        switch ((ValueType)columnType.getType()) {
            case LONG: {
                return new LongFrameColumnReader(columnNumber);
            }
            case FLOAT: {
                return new FloatFrameColumnReader(columnNumber);
            }
            case DOUBLE: {
                return new DoubleFrameColumnReader(columnNumber);
            }
            case STRING: {
                return new StringFrameColumnReader(columnNumber, false);
            }
            case COMPLEX: {
                return new ComplexFrameColumnReader(columnNumber);
            }
            case ARRAY: {
                switch ((ValueType)columnType.getElementType().getType()) {
                    case STRING: {
                        return new StringFrameColumnReader(columnNumber, true);
                    }
                    case LONG: {
                        return new LongArrayFrameColumnReader(columnNumber);
                    }
                    case FLOAT: {
                        return new FloatArrayFrameColumnReader(columnNumber);
                    }
                    case DOUBLE: {
                        return new DoubleArrayFrameColumnReader(columnNumber);
                    }
                }
                return new UnsupportedColumnTypeFrameColumnReader(columnName, columnType);
            }
        }
        return new UnsupportedColumnTypeFrameColumnReader(columnName, columnType);
    }
}

