/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.segment.columnar;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.read.columnar.FrameColumnReader;
import org.apache.druid.frame.segment.FrameCursor;
import org.apache.druid.frame.segment.FrameCursorUtils;
import org.apache.druid.frame.segment.FrameFilteredOffset;
import org.apache.druid.frame.segment.columnar.FrameQueryableIndex;
import org.apache.druid.frame.segment.columnar.FrameVectorCursor;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.segment.ColumnCache;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.QueryableIndexColumnSelectorFactory;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.SimpleDescendingOffset;
import org.apache.druid.segment.SimpleSettableOffset;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.vector.FilteredVectorOffset;
import org.apache.druid.segment.vector.NoFilterVectorOffset;
import org.apache.druid.segment.vector.QueryableIndexVectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorCursor;
import org.joda.time.Interval;

public class FrameCursorFactory
implements CursorFactory {
    private final Frame frame;
    private final RowSignature signature;
    private final List<FrameColumnReader> columnReaders;

    public FrameCursorFactory(Frame frame, RowSignature signature, List<FrameColumnReader> columnReaders) {
        this.frame = FrameType.COLUMNAR.ensureType(frame);
        this.signature = signature;
        this.columnReaders = columnReaders;
    }

    @Override
    public boolean canVectorize(@Nullable Filter filter, VirtualColumns virtualColumns, boolean descending) {
        return (filter == null || filter.canVectorizeMatcher(this.signature)) && virtualColumns.canVectorize(this.signature) && !descending;
    }

    @Override
    public Sequence<Cursor> makeCursors(@Nullable Filter filter, Interval interval, VirtualColumns virtualColumns, Granularity gran, boolean descending, @Nullable QueryMetrics<?> queryMetrics) {
        FrameQueryableIndex index = new FrameQueryableIndex(this.frame, this.signature, this.columnReaders);
        if (Granularities.ALL.equals(gran)) {
            Closer closer = Closer.create();
            Cursor cursor = FrameCursorFactory.makeGranularityAllCursor(new ColumnCache(index, closer), this.frame.numRows(), filter, interval, virtualColumns, descending);
            return Sequences.simple(Collections.singletonList(cursor)).withBaggage(closer);
        }
        throw new UOE("Granularity [%s] not supported", gran);
    }

    @Override
    @Nullable
    public VectorCursor makeVectorCursor(@Nullable Filter filter, Interval interval, VirtualColumns virtualColumns, boolean descending, int vectorSize, @Nullable QueryMetrics<?> queryMetrics) {
        if (!this.canVectorize(filter, virtualColumns, descending)) {
            throw new ISE("Cannot vectorize. Check 'canVectorize' before calling 'makeVectorCursor'.", new Object[0]);
        }
        Closer closer = Closer.create();
        FrameQueryableIndex index = new FrameQueryableIndex(this.frame, this.signature, this.columnReaders);
        Filter filterToUse = FrameCursorUtils.buildFilter(filter, interval);
        NoFilterVectorOffset baseOffset = new NoFilterVectorOffset(vectorSize, 0, this.frame.numRows());
        ColumnCache columnCache = new ColumnCache(index, closer);
        QueryableIndexVectorColumnSelectorFactory baseColumnSelectorFactory = new QueryableIndexVectorColumnSelectorFactory(index, baseOffset, columnCache, virtualColumns);
        if (filterToUse == null) {
            return new FrameVectorCursor(baseOffset, baseColumnSelectorFactory, closer);
        }
        VectorValueMatcher matcher = filterToUse.makeVectorMatcher(baseColumnSelectorFactory);
        FilteredVectorOffset filteredOffset = FilteredVectorOffset.create(baseOffset, matcher);
        QueryableIndexVectorColumnSelectorFactory filteredColumnSelectorFactory = new QueryableIndexVectorColumnSelectorFactory(index, filteredOffset, columnCache, virtualColumns);
        return new FrameVectorCursor(filteredOffset, filteredColumnSelectorFactory, closer);
    }

    private static Cursor makeGranularityAllCursor(ColumnCache columnSelector, int numRows, @Nullable Filter filter, Interval interval, VirtualColumns virtualColumns, boolean descending) {
        Filter filterToUse = FrameCursorUtils.buildFilter(filter, interval);
        SimpleSettableOffset baseOffset = descending ? new SimpleDescendingOffset(numRows) : new SimpleAscendingOffset(numRows);
        QueryableIndexColumnSelectorFactory columnSelectorFactory = new QueryableIndexColumnSelectorFactory(virtualColumns, descending, baseOffset, columnSelector);
        SimpleSettableOffset offset = filterToUse == null ? baseOffset : new FrameFilteredOffset(baseOffset, columnSelectorFactory, filterToUse);
        return new FrameCursor(offset, columnSelectorFactory);
    }
}

