/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write.columnar;

import javax.annotation.Nullable;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.write.UnsupportedColumnTypeException;
import org.apache.druid.frame.write.columnar.ComplexFrameColumnWriter;
import org.apache.druid.frame.write.columnar.DoubleArrayFrameColumnWriter;
import org.apache.druid.frame.write.columnar.DoubleFrameColumnWriter;
import org.apache.druid.frame.write.columnar.FloatArrayFrameColumnWriter;
import org.apache.druid.frame.write.columnar.FloatFrameColumnWriter;
import org.apache.druid.frame.write.columnar.FrameColumnWriter;
import org.apache.druid.frame.write.columnar.LongArrayFrameColumnWriter;
import org.apache.druid.frame.write.columnar.LongFrameColumnWriter;
import org.apache.druid.frame.write.columnar.NumericArrayFrameColumnWriter;
import org.apache.druid.frame.write.columnar.StringArrayFrameColumnWriterImpl;
import org.apache.druid.frame.write.columnar.StringFrameColumnWriter;
import org.apache.druid.frame.write.columnar.StringFrameColumnWriterImpl;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;

public class FrameColumnWriters {
    public static final byte TYPE_LONG = 1;
    public static final byte TYPE_FLOAT = 2;
    public static final byte TYPE_DOUBLE = 3;
    public static final byte TYPE_STRING = 4;
    public static final byte TYPE_COMPLEX = 5;
    public static final byte TYPE_STRING_ARRAY = 6;
    public static final byte TYPE_LONG_ARRAY = 7;
    public static final byte TYPE_FLOAT_ARRAY = 8;
    public static final byte TYPE_DOUBLE_ARRAY = 9;

    private FrameColumnWriters() {
    }

    static FrameColumnWriter create(ColumnSelectorFactory columnSelectorFactory, MemoryAllocator allocator, String column, ColumnType type) {
        if (type == null) {
            throw new UnsupportedColumnTypeException(column, null);
        }
        switch ((ValueType)type.getType()) {
            case LONG: {
                return FrameColumnWriters.makeLongWriter(columnSelectorFactory, allocator, column);
            }
            case FLOAT: {
                return FrameColumnWriters.makeFloatWriter(columnSelectorFactory, allocator, column);
            }
            case DOUBLE: {
                return FrameColumnWriters.makeDoubleWriter(columnSelectorFactory, allocator, column);
            }
            case STRING: {
                return FrameColumnWriters.makeStringWriter(columnSelectorFactory, allocator, column);
            }
            case ARRAY: {
                switch ((ValueType)type.getElementType().getType()) {
                    case STRING: {
                        return FrameColumnWriters.makeStringArrayWriter(columnSelectorFactory, allocator, column);
                    }
                    case LONG: {
                        return FrameColumnWriters.makeLongArrayWriter(columnSelectorFactory, allocator, column);
                    }
                    case FLOAT: {
                        return FrameColumnWriters.makeFloatArrayWriter(columnSelectorFactory, allocator, column);
                    }
                    case DOUBLE: {
                        return FrameColumnWriters.makeDoubleArrayWriter(columnSelectorFactory, allocator, column);
                    }
                }
                throw new UnsupportedColumnTypeException(column, type);
            }
            case COMPLEX: {
                return FrameColumnWriters.makeComplexWriter(columnSelectorFactory, allocator, column, type.getComplexTypeName());
            }
        }
        throw new UnsupportedColumnTypeException(column, type);
    }

    private static LongFrameColumnWriter makeLongWriter(ColumnSelectorFactory selectorFactory, MemoryAllocator allocator, String columnName) {
        ColumnCapabilities capabilities = selectorFactory.getColumnCapabilities(columnName);
        ColumnValueSelector selector = selectorFactory.makeColumnValueSelector(columnName);
        return new LongFrameColumnWriter(selector, allocator, FrameColumnWriters.hasNullsForNumericWriter(capabilities));
    }

    private static FloatFrameColumnWriter makeFloatWriter(ColumnSelectorFactory selectorFactory, MemoryAllocator allocator, String columnName) {
        ColumnCapabilities capabilities = selectorFactory.getColumnCapabilities(columnName);
        ColumnValueSelector selector = selectorFactory.makeColumnValueSelector(columnName);
        return new FloatFrameColumnWriter(selector, allocator, FrameColumnWriters.hasNullsForNumericWriter(capabilities));
    }

    private static DoubleFrameColumnWriter makeDoubleWriter(ColumnSelectorFactory selectorFactory, MemoryAllocator allocator, String columnName) {
        ColumnCapabilities capabilities = selectorFactory.getColumnCapabilities(columnName);
        ColumnValueSelector selector = selectorFactory.makeColumnValueSelector(columnName);
        return new DoubleFrameColumnWriter(selector, allocator, FrameColumnWriters.hasNullsForNumericWriter(capabilities));
    }

    private static StringFrameColumnWriter makeStringWriter(ColumnSelectorFactory selectorFactory, MemoryAllocator allocator, String columnName) {
        ColumnCapabilities capabilities = selectorFactory.getColumnCapabilities(columnName);
        DimensionSelector selector = selectorFactory.makeDimensionSelector(DefaultDimensionSpec.of(columnName));
        return new StringFrameColumnWriterImpl(selector, allocator, capabilities == null ? ColumnCapabilities.Capable.UNKNOWN : capabilities.hasMultipleValues());
    }

    private static StringFrameColumnWriter makeStringArrayWriter(ColumnSelectorFactory selectorFactory, MemoryAllocator allocator, String columnName) {
        ColumnValueSelector selector = selectorFactory.makeColumnValueSelector(columnName);
        return new StringArrayFrameColumnWriterImpl(selector, allocator);
    }

    private static NumericArrayFrameColumnWriter makeLongArrayWriter(ColumnSelectorFactory selectorFactory, MemoryAllocator allocator, String columnName) {
        ColumnValueSelector selector = selectorFactory.makeColumnValueSelector(columnName);
        return new LongArrayFrameColumnWriter(selector, allocator);
    }

    private static NumericArrayFrameColumnWriter makeFloatArrayWriter(ColumnSelectorFactory selectorFactory, MemoryAllocator allocator, String columnName) {
        ColumnValueSelector selector = selectorFactory.makeColumnValueSelector(columnName);
        return new FloatArrayFrameColumnWriter(selector, allocator);
    }

    private static NumericArrayFrameColumnWriter makeDoubleArrayWriter(ColumnSelectorFactory selectorFactory, MemoryAllocator allocator, String columnName) {
        ColumnValueSelector selector = selectorFactory.makeColumnValueSelector(columnName);
        return new DoubleArrayFrameColumnWriter(selector, allocator);
    }

    private static ComplexFrameColumnWriter makeComplexWriter(ColumnSelectorFactory selectorFactory, MemoryAllocator allocator, String columnName, @Nullable String columnTypeName) {
        if (columnTypeName == null) {
            throw new ISE("No complexTypeName, cannot write column [%s]", columnName);
        }
        ComplexMetricSerde serde = ComplexMetrics.getSerdeForType(columnTypeName);
        if (serde == null) {
            throw new ISE("No serde for complexTypeName[%s], cannot write column [%s]", columnTypeName, columnName);
        }
        ColumnValueSelector selector = selectorFactory.makeColumnValueSelector(columnName);
        return new ComplexFrameColumnWriter(selector, allocator, serde);
    }

    private static boolean hasNullsForNumericWriter(ColumnCapabilities capabilities) {
        if (capabilities == null) {
            return true;
        }
        if (((ValueType)capabilities.getType()).isNumeric()) {
            return capabilities.hasNulls().isMaybeTrue();
        }
        return true;
    }
}

