/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.report;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.druid.indexer.report.TaskReport;
import org.apache.druid.indexer.report.TaskReportFileWriter;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.logger.Logger;

public class SingleFileTaskReportFileWriter
implements TaskReportFileWriter {
    private static final Logger log = new Logger(SingleFileTaskReportFileWriter.class);
    private final File reportsFile;
    private ObjectMapper objectMapper;

    public SingleFileTaskReportFileWriter(File reportsFile) {
        this.reportsFile = reportsFile;
    }

    @Override
    public void write(String taskId, TaskReport.ReportMap reports) {
        try {
            File reportsFileParent = this.reportsFile.getParentFile();
            if (reportsFileParent != null) {
                FileUtils.mkdirp(reportsFileParent);
            }
            try (FileOutputStream outputStream = new FileOutputStream(this.reportsFile);){
                SingleFileTaskReportFileWriter.writeReportToStream(this.objectMapper, outputStream, reports);
            }
        }
        catch (Exception e) {
            log.error(e, "Encountered exception in write().", new Object[0]);
        }
    }

    @Override
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public static void writeReportToStream(ObjectMapper objectMapper, OutputStream outputStream, TaskReport.ReportMap reports) throws Exception {
        objectMapper.writeValue(outputStream, (Object)reports);
    }
}

