/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import java.nio.ByteBuffer;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ConstantExpr;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.segment.column.TypeStrategy;

class ComplexExpr
extends ConstantExpr<Object> {
    protected ComplexExpr(ExpressionType outputType, @Nullable Object value) {
        super(outputType, value);
    }

    @Override
    protected ExprEval realEval() {
        return ExprEval.ofComplex(this.outputType, this.value);
    }

    @Override
    public boolean canVectorize(Expr.InputBindingInspector inspector) {
        return false;
    }

    @Override
    public String stringify() {
        byte[] bytes;
        ByteBuffer wrappedBytes;
        if (this.value == null) {
            return StringUtils.format("complex_decode_base64('%s', %s)", this.outputType.getComplexTypeName(), "null");
        }
        TypeStrategy<Object> strategy = this.outputType.getStrategy();
        int remaining = strategy.write(wrappedBytes = ByteBuffer.wrap(bytes = new byte[strategy.estimateSizeBytes(this.value)]), 0, this.value, bytes.length);
        if (remaining < 0) {
            bytes = new byte[bytes.length - remaining];
            wrappedBytes = ByteBuffer.wrap(bytes);
            strategy.write(wrappedBytes, 0, this.value, bytes.length);
        }
        return StringUtils.format("complex_decode_base64('%s', '%s')", this.outputType.getComplexTypeName(), StringUtils.encodeBase64String(bytes));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComplexExpr that = (ComplexExpr)o;
        return this.outputType.equals(that.outputType) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.outputType, this.value);
    }
}

