/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.errorprone.annotations.Immutable;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;

@Immutable
abstract class ConstantExpr<T>
implements Expr {
    final ExpressionType outputType;
    @Nullable
    final T value;

    protected ConstantExpr(ExpressionType outputType, @Nullable T value) {
        this.outputType = outputType;
        this.value = value;
    }

    @Override
    @Nullable
    public final ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
        return this.value == null ? null : this.outputType;
    }

    @Override
    public final boolean isLiteral() {
        return true;
    }

    @Override
    public final boolean isNullLiteral() {
        return this.value == null;
    }

    @Override
    public final Object getLiteralValue() {
        return this.value;
    }

    @Override
    public final Expr visit(Expr.Shuttle shuttle) {
        return shuttle.visit(this);
    }

    @Override
    public final Expr.BindingAnalysis analyzeInputs() {
        return Expr.BindingAnalysis.EMTPY;
    }

    @Override
    public boolean canVectorize(Expr.InputBindingInspector inspector) {
        return true;
    }

    @Override
    public String stringify() {
        return this.toString();
    }

    @Override
    public final ExprEval eval(Expr.ObjectBinding bindings) {
        return this.realEval();
    }

    protected abstract ExprEval<T> realEval();

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public Expr asSingleThreaded(Expr.InputBindingInspector inspector) {
        return new ExprEvalBasedConstantExpr(this.realEval());
    }

    @NotThreadSafe
    private static final class ExprEvalBasedConstantExpr<T>
    extends ConstantExpr<T> {
        private final ExprEval<T> eval;

        private ExprEvalBasedConstantExpr(ExprEval<T> eval) {
            super(eval.type(), eval.value);
            this.eval = eval;
        }

        @Override
        protected ExprEval<T> realEval() {
            return this.eval;
        }

        @Override
        public String stringify() {
            return this.eval.toExpr().stringify();
        }

        @Override
        public String toString() {
            return this.eval.toExpr().toString();
        }

        public int hashCode() {
            return Objects.hash(this.eval);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExprEvalBasedConstantExpr other = (ExprEvalBasedConstantExpr)obj;
            return Objects.equals(this.eval, other.eval);
        }
    }
}

