/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.aggregation.AbstractSerializablePairLongObjectColumnHeader;
import org.apache.druid.query.aggregation.AbstractSerializablePairLongObjectDeltaEncodedStagedSerde;
import org.apache.druid.query.aggregation.SerializablePairLongLong;
import org.apache.druid.segment.column.ComplexColumn;
import org.apache.druid.segment.serde.cell.ByteBufferProvider;
import org.apache.druid.segment.serde.cell.CellReader;

public class SerializablePairLongLongComplexColumn
implements ComplexColumn {
    private final Closer closer;
    private final int serializedSize;
    private final CellReader cellReader;
    private final AbstractSerializablePairLongObjectDeltaEncodedStagedSerde<?> serde;

    public SerializablePairLongLongComplexColumn(CellReader cellReader, AbstractSerializablePairLongObjectDeltaEncodedStagedSerde<?> serde, Closer closer, int serializedSize) {
        this.cellReader = cellReader;
        this.serde = serde;
        this.closer = closer;
        this.serializedSize = serializedSize;
    }

    @Override
    public Class<?> getClazz() {
        return SerializablePairLongLong.class;
    }

    @Override
    public String getTypeName() {
        return "serializablePairLongLong";
    }

    @Override
    public Object getRowValue(int rowNum) {
        return this.serde.deserialize(this.cellReader.getCell(rowNum));
    }

    @Override
    public int getLength() {
        return this.serializedSize;
    }

    @Override
    public void close() {
        try {
            this.closer.close();
        }
        catch (IOException e) {
            throw new RE(e, "error closing " + this.getClass().getName(), new Object[0]);
        }
    }

    public static class Builder {
        private final int serializedSize;
        private final AbstractSerializablePairLongObjectDeltaEncodedStagedSerde<?> serde;
        private final CellReader.Builder cellReaderBuilder;

        public Builder(ByteBuffer buffer) {
            ByteBuffer masterByteBuffer = buffer.asReadOnlyBuffer().order(ByteOrder.nativeOrder());
            this.serializedSize = masterByteBuffer.remaining();
            AbstractSerializablePairLongObjectColumnHeader<SerializablePairLongLong> columnHeader = AbstractSerializablePairLongObjectColumnHeader.fromBuffer(masterByteBuffer, SerializablePairLongLong.class);
            Preconditions.checkArgument((columnHeader.getVersion() == 3 ? 1 : 0) != 0, (String)"version %s expected, got %s", (int)3, (int)columnHeader.getVersion());
            this.serde = columnHeader.createSerde();
            this.cellReaderBuilder = new CellReader.Builder(masterByteBuffer);
        }

        public Builder setByteBufferProvier(ByteBufferProvider byteBufferProvider) {
            this.cellReaderBuilder.setByteBufferProvider(byteBufferProvider);
            return this;
        }

        public SerializablePairLongLongComplexColumn build() {
            Closer closer = Closer.create();
            CellReader cellReader = this.cellReaderBuilder.build();
            closer.register(cellReader);
            return new SerializablePairLongLongComplexColumn(cellReader, this.serde, closer, this.serializedSize);
        }
    }
}

