/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.util.List;
import java.util.function.Function;
import org.apache.druid.java.util.common.Numbers;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.DelegatingAggregator;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.selector.settable.SettableValueLongColumnValueSelector;

public class StringColumnLongAggregatorWrapper
extends DelegatingAggregator {
    private final BaseObjectColumnValueSelector selector;
    private final long nullValue;
    private final SettableValueLongColumnValueSelector longSelector = new SettableValueLongColumnValueSelector();

    public StringColumnLongAggregatorWrapper(BaseObjectColumnValueSelector selector, Function<BaseLongColumnValueSelector, Aggregator> delegateBuilder, long nullValue) {
        this.selector = selector;
        this.nullValue = nullValue;
        this.delegate = delegateBuilder.apply(this.longSelector);
    }

    @Override
    public void aggregate() {
        Object update = this.selector.getObject();
        if (update == null) {
            this.longSelector.setValue(this.nullValue);
            this.delegate.aggregate();
        } else if (update instanceof List) {
            for (Object o : (List)update) {
                this.longSelector.setValue(Numbers.tryParseLong(o, this.nullValue));
                this.delegate.aggregate();
            }
        } else {
            this.longSelector.setValue(Numbers.tryParseLong(update, this.nullValue));
            this.delegate.aggregate();
        }
    }
}

