/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.column;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.DictionaryBuildingUtils;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorPlus;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorStrategy;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.ArrayBasedIndexedInts;
import org.apache.druid.segment.data.IndexedInts;

public abstract class KeyMappingMultiValueGroupByColumnSelectorStrategy
implements GroupByColumnSelectorStrategy {
    public static GroupByColumnSelectorStrategy create(ColumnCapabilities capabilities, DimensionSelector dimensionSelector) {
        if (dimensionSelector.getValueCardinality() >= 0 && dimensionSelector.nameLookupPossibleInAdvance()) {
            return new PrebuiltDictionary(capabilities, dimensionSelector::lookupName);
        }
        return new DictionaryBuilding();
    }

    @Override
    public int getGroupingKeySizeBytes() {
        return 4;
    }

    @Override
    public void initGroupingKeyColumnValue(int keyBufferPosition, int dimensionIndex, Object rowObj, ByteBuffer keyBuffer, int[] stack) {
        IndexedInts row = (IndexedInts)rowObj;
        int rowSize = row.size();
        keyBuffer.putInt(keyBufferPosition, rowSize == 0 ? -1 : row.get(0));
        stack[dimensionIndex] = rowSize == 0 ? 0 : 1;
    }

    @Override
    public boolean checkRowIndexAndAddValueToGroupingKey(int keyBufferPosition, Object rowObj, int rowValIdx, ByteBuffer keyBuffer) {
        IndexedInts row = (IndexedInts)rowObj;
        int rowSize = row.size();
        if (rowValIdx < rowSize) {
            keyBuffer.putInt(keyBufferPosition, row.get(rowValIdx));
            return true;
        }
        return false;
    }

    public static class DictionaryBuilding
    extends KeyMappingMultiValueGroupByColumnSelectorStrategy {
        private final List<String> dictionary = DictionaryBuildingUtils.createDictionary();
        private final Object2IntMap<String> reverseDictionary = DictionaryBuildingUtils.createReverseDictionary(ColumnType.STRING.getNullableStrategy());

        @Override
        public void processValueFromGroupingKey(GroupByColumnSelectorPlus selectorPlus, ByteBuffer key, ResultRow resultRow, int keyBufferPosition) {
            int id = key.getInt(keyBufferPosition);
            if (id != -1) {
                String value = this.dictionary.get(id);
                resultRow.set(selectorPlus.getResultRowPosition(), value);
            } else {
                resultRow.set(selectorPlus.getResultRowPosition(), NullHandling.defaultStringValue());
            }
        }

        @Override
        public int initColumnValues(ColumnValueSelector selector, int columnIndex, Object[] valuess) {
            DimensionSelector dimSelector = (DimensionSelector)selector;
            IndexedInts row = dimSelector.getRow();
            int stateFootprintIncrease = 0;
            ArrayBasedIndexedInts newRow = (ArrayBasedIndexedInts)valuess[columnIndex];
            if (newRow == null) {
                newRow = new ArrayBasedIndexedInts();
                valuess[columnIndex] = newRow;
            }
            int rowSize = row.size();
            newRow.ensureSize(rowSize);
            for (int i = 0; i < rowSize; ++i) {
                String value = dimSelector.lookupName(row.get(i));
                int dictId = this.reverseDictionary.getInt((Object)value);
                if (dictId < 0) {
                    int nextId = this.dictionary.size();
                    this.dictionary.add(value);
                    this.reverseDictionary.put((Object)value, nextId);
                    newRow.setValue(i, nextId);
                    stateFootprintIncrease += DictionaryBuildingUtils.estimateEntryFootprint((value == null ? 0 : value.length()) * 2);
                    continue;
                }
                newRow.setValue(i, dictId);
            }
            newRow.setSize(rowSize);
            return stateFootprintIncrease;
        }

        @Override
        public int writeToKeyBuffer(int keyBufferPosition, ColumnValueSelector selector, ByteBuffer keyBuffer) {
            DimensionSelector dimSelector = (DimensionSelector)selector;
            IndexedInts row = dimSelector.getRow();
            Preconditions.checkState((row.size() < 2 ? 1 : 0) != 0, (Object)"Not supported for multi-value dimensions");
            if (row.size() == 0) {
                keyBuffer.putInt(keyBufferPosition, -1);
                return 0;
            }
            String value = dimSelector.lookupName(row.get(0));
            int dictId = this.reverseDictionary.getInt((Object)value);
            if (dictId == -1) {
                int nextId = this.dictionary.size();
                this.dictionary.add(value);
                this.reverseDictionary.put((Object)value, nextId);
                keyBuffer.putInt(keyBufferPosition, nextId);
                return DictionaryBuildingUtils.estimateEntryFootprint((value == null ? 0 : value.length()) * 2);
            }
            keyBuffer.putInt(keyBufferPosition, dictId);
            return 0;
        }

        @Override
        public Grouper.BufferComparator bufferComparator(int keyBufferPosition, @Nullable StringComparator stringComparator) {
            StringComparator realComparator = stringComparator == null ? StringComparators.LEXICOGRAPHIC : stringComparator;
            return (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> {
                String lhsStr = this.dictionary.get(lhsBuffer.getInt(lhsPosition + keyBufferPosition));
                String rhsStr = this.dictionary.get(rhsBuffer.getInt(rhsPosition + keyBufferPosition));
                return realComparator.compare(lhsStr, rhsStr);
            };
        }

        @Override
        public void reset() {
            this.dictionary.clear();
            this.reverseDictionary.clear();
        }
    }

    public static class PrebuiltDictionary
    extends KeyMappingMultiValueGroupByColumnSelectorStrategy {
        private final ColumnCapabilities capabilities;
        private final IntFunction<String> dictionaryLookup;

        public PrebuiltDictionary(ColumnCapabilities capabilities, IntFunction<String> dictionaryLookup) {
            this.capabilities = capabilities;
            this.dictionaryLookup = dictionaryLookup;
        }

        @Override
        public void processValueFromGroupingKey(GroupByColumnSelectorPlus selectorPlus, ByteBuffer key, ResultRow resultRow, int keyBufferPosition) {
            int id = key.getInt(keyBufferPosition);
            if (id != -1) {
                resultRow.set(selectorPlus.getResultRowPosition(), ((DimensionSelector)selectorPlus.getSelector()).lookupName(id));
            } else {
                resultRow.set(selectorPlus.getResultRowPosition(), NullHandling.defaultStringValue());
            }
        }

        @Override
        public int initColumnValues(ColumnValueSelector selector, int columnIndex, Object[] valuess) {
            DimensionSelector dimSelector = (DimensionSelector)selector;
            IndexedInts row = dimSelector.getRow();
            valuess[columnIndex] = row;
            return 0;
        }

        @Override
        public int writeToKeyBuffer(int keyBufferPosition, ColumnValueSelector selector, ByteBuffer keyBuffer) {
            DimensionSelector dimSelector = (DimensionSelector)selector;
            IndexedInts row = dimSelector.getRow();
            Preconditions.checkState((row.size() < 2 ? 1 : 0) != 0, (Object)"Not supported for multi-value dimensions");
            int dictId = row.size() == 1 ? row.get(0) : -1;
            keyBuffer.putInt(keyBufferPosition, dictId);
            return 0;
        }

        @Override
        public Grouper.BufferComparator bufferComparator(int keyBufferPosition, @Nullable StringComparator stringComparator) {
            StringComparator comparator;
            boolean canCompareInts = this.capabilities != null && this.capabilities.isDictionaryEncoded().and(this.capabilities.areDictionaryValuesSorted().and(this.capabilities.areDictionaryValuesUnique())).isTrue();
            StringComparator stringComparator2 = comparator = stringComparator == null ? StringComparators.LEXICOGRAPHIC : stringComparator;
            if (canCompareInts && StringComparators.LEXICOGRAPHIC.equals(comparator)) {
                return (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> Integer.compare(lhsBuffer.getInt(lhsPosition + keyBufferPosition), rhsBuffer.getInt(rhsPosition + keyBufferPosition));
            }
            Preconditions.checkState((this.dictionaryLookup != null ? 1 : 0) != 0, (Object)"null dictionary lookup");
            return (lhsBuffer, rhsBuffer, lhsPosition, rhsPosition) -> {
                String lhsStr = this.dictionaryLookup.apply(lhsBuffer.getInt(lhsPosition + keyBufferPosition));
                String rhsStr = this.dictionaryLookup.apply(rhsBuffer.getInt(rhsPosition + keyBufferPosition));
                return comparator.compare(lhsStr, rhsStr);
            };
        }

        @Override
        public void reset() {
        }
    }
}

