/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.rowsandcols.AppendableMapOfColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.DoubleArrayColumn;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;
import org.apache.druid.query.rowsandcols.column.ObjectArrayColumn;
import org.apache.druid.query.rowsandcols.semantic.AppendableRowsAndColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;

public class MapOfColumnsRowsAndColumns
implements RowsAndColumns {
    private final Map<String, Column> mapOfColumns;
    private final int numRows;

    public static Builder builder() {
        return new Builder();
    }

    public static MapOfColumnsRowsAndColumns of(String name, Column col) {
        return MapOfColumnsRowsAndColumns.fromMap((Map<String, ? extends Column>)ImmutableMap.of((Object)name, (Object)col));
    }

    public static MapOfColumnsRowsAndColumns of(String name, Column col, String name2, Column col2) {
        return MapOfColumnsRowsAndColumns.fromMap((Map<String, ? extends Column>)ImmutableMap.of((Object)name, (Object)col, (Object)name2, (Object)col2));
    }

    public static MapOfColumnsRowsAndColumns fromMap(Map<String, ? extends Column> map) {
        int newCells;
        if (map == null || map.isEmpty()) {
            throw new ISE("map[%s] cannot be null or empty.", map);
        }
        Iterator<Map.Entry<String, ? extends Column>> iter = map.entrySet().iterator();
        Map.Entry<String, ? extends Column> entry = iter.next();
        int numCells = entry.getValue().toAccessor().numRows();
        if (iter.hasNext() && numCells != (newCells = (entry = iter.next()).getValue().toAccessor().numRows())) {
            throw new ISE("Mismatched numCells, expectedNumCells[%s], actual[%s] from col[%s].", numCells, newCells, entry.getKey());
        }
        return new MapOfColumnsRowsAndColumns(map, map.values().iterator().next().toAccessor().numRows());
    }

    public static MapOfColumnsRowsAndColumns fromResultRow(ArrayList<ResultRow> objs, RowSignature signature) {
        Builder bob = MapOfColumnsRowsAndColumns.builder();
        if (!objs.isEmpty()) {
            int i;
            Object[][] columnOriented = new Object[objs.get(0).length()][objs.size()];
            for (i = 0; i < objs.size(); ++i) {
                for (int j = 0; j < objs.get(i).length(); ++j) {
                    columnOriented[j][i] = objs.get(i).get(j);
                }
            }
            for (i = 0; i < signature.size(); ++i) {
                ColumnType type = signature.getColumnType(i).orElse(null);
                bob.add(signature.getColumnName(i), columnOriented[i], type);
            }
        }
        return bob.build();
    }

    public static MapOfColumnsRowsAndColumns fromRowObjects(Object[][] objs, RowSignature signature) {
        Builder bob = MapOfColumnsRowsAndColumns.builder();
        if (objs.length > 0) {
            int i;
            Object[][] columnOriented = new Object[objs[0].length][objs.length];
            for (i = 0; i < objs.length; ++i) {
                for (int j = 0; j < objs[i].length; ++j) {
                    columnOriented[j][i] = objs[i][j];
                }
            }
            for (i = 0; i < signature.size(); ++i) {
                ColumnType type = signature.getColumnType(i).orElse(null);
                bob.add(signature.getColumnName(i), columnOriented[i], type);
            }
        }
        return bob.build();
    }

    public MapOfColumnsRowsAndColumns(Map<String, Column> mapOfColumns, int numRows) {
        this.mapOfColumns = mapOfColumns;
        this.numRows = numRows;
    }

    public Set<String> getColumnNames() {
        return this.mapOfColumns.keySet();
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public Column findColumn(String name) {
        return this.mapOfColumns.get(name);
    }

    @Override
    public <T> T as(Class<T> clazz) {
        if (AppendableRowsAndColumns.class.equals(clazz)) {
            return (T)new AppendableMapOfColumns(this);
        }
        return null;
    }

    public static class Builder {
        public LinkedHashMap<String, Column> cols = new LinkedHashMap();

        public Builder add(String name, int[] vals) {
            return this.add(name, new IntArrayColumn(vals));
        }

        public Builder add(String name, double[] vals) {
            return this.add(name, new DoubleArrayColumn(vals));
        }

        public Builder add(String name, ColumnType type, Object ... vals) {
            return this.add(name, vals, type);
        }

        public Builder add(String name, Object[] vals, ColumnType type) {
            return this.add(name, new ObjectArrayColumn(vals, type));
        }

        public Builder add(String name, Column col) {
            this.cols.put(name, col);
            return this;
        }

        public MapOfColumnsRowsAndColumns build() {
            return MapOfColumnsRowsAndColumns.fromMap(this.cols);
        }
    }
}

