/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.ArenaMemoryAllocatorFactory;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.frame.write.FrameWriters;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.rowsandcols.EmptyRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.concrete.ColumnBasedFrameRowsAndColumns;
import org.apache.druid.segment.CloseableShapeshifter;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.RowSignature;

public class StorageAdapterRowsAndColumns
implements CloseableShapeshifter,
RowsAndColumns {
    private final StorageAdapter storageAdapter;
    private RowsAndColumns materialized;

    public StorageAdapterRowsAndColumns(StorageAdapter storageAdapter) {
        this.storageAdapter = storageAdapter;
    }

    @Override
    public <T> T as(Class<T> clazz) {
        if (StorageAdapter.class == clazz) {
            return (T)this.storageAdapter;
        }
        return null;
    }

    @Override
    public Collection<String> getColumnNames() {
        return this.storageAdapter.getRowSignature().getColumnNames();
    }

    @Override
    public int numRows() {
        return this.storageAdapter.getNumRows();
    }

    @Override
    public Column findColumn(String name) {
        return this.getRealRAC().findColumn(name);
    }

    @Override
    public void close() {
    }

    protected RowsAndColumns getRealRAC() {
        if (this.materialized == null) {
            this.materialized = StorageAdapterRowsAndColumns.materialize(this.storageAdapter);
        }
        return this.materialized;
    }

    @Nonnull
    private static RowsAndColumns materialize(StorageAdapter as) {
        RowSignature rowSignature;
        Sequence<Cursor> cursors = as.makeCursors(null, Intervals.ETERNITY, VirtualColumns.EMPTY, Granularities.ALL, false, null);
        FrameWriter writer = cursors.accumulate(null, (arg_0, arg_1) -> StorageAdapterRowsAndColumns.lambda$materialize$0(rowSignature = as.getRowSignature(), arg_0, arg_1));
        if (writer == null) {
            return new EmptyRowsAndColumns();
        }
        byte[] bytes = writer.toByteArray();
        return new ColumnBasedFrameRowsAndColumns(Frame.wrap(bytes), rowSignature);
    }

    private static /* synthetic */ FrameWriter lambda$materialize$0(RowSignature rowSignature, FrameWriter accumulated, Cursor in) {
        if (accumulated != null) {
            throw new ISE("accumulated[%s] non-null, why did we get multiple cursors?", accumulated);
        }
        ColumnSelectorFactory columnSelectorFactory = in.getColumnSelectorFactory();
        FrameWriterFactory frameWriterFactory = FrameWriters.makeFrameWriterFactory(FrameType.COLUMNAR, new ArenaMemoryAllocatorFactory(0xC800000), rowSignature, Collections.emptyList());
        FrameWriter frameWriter = frameWriterFactory.newFrameWriter(columnSelectorFactory);
        while (!in.isDoneOrInterrupted()) {
            frameWriter.addSelection();
            in.advance();
        }
        return frameWriter;
    }
}

