/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.data.Indexed;
import org.joda.time.Interval;

public class SimpleQueryableIndex
implements QueryableIndex {
    private final Interval dataInterval;
    private final List<String> columnNames;
    private final Indexed<String> availableDimensions;
    private final BitmapFactory bitmapFactory;
    private final Map<String, Supplier<ColumnHolder>> columns;
    private final SmooshedFileMapper fileMapper;
    @Nullable
    private final Metadata metadata;
    private final Supplier<Map<String, DimensionHandler>> dimensionHandlers;

    public SimpleQueryableIndex(Interval dataInterval, Indexed<String> dimNames, BitmapFactory bitmapFactory, Map<String, Supplier<ColumnHolder>> columns, SmooshedFileMapper fileMapper, @Nullable Metadata metadata, boolean lazy) {
        Preconditions.checkNotNull(columns.get("__time"));
        this.dataInterval = (Interval)Preconditions.checkNotNull((Object)dataInterval, (Object)"dataInterval");
        ImmutableList.Builder columnNamesBuilder = ImmutableList.builder();
        for (String column : columns.keySet()) {
            if ("__time".equals(column)) continue;
            columnNamesBuilder.add((Object)column);
        }
        this.columnNames = columnNamesBuilder.build();
        this.availableDimensions = dimNames;
        this.bitmapFactory = bitmapFactory;
        this.columns = columns;
        this.fileMapper = fileMapper;
        this.metadata = metadata;
        this.dimensionHandlers = lazy ? Suppliers.memoize(() -> this.initDimensionHandlers(this.availableDimensions)) : () -> this.initDimensionHandlers(this.availableDimensions);
    }

    @Override
    public Interval getDataInterval() {
        return this.dataInterval;
    }

    @Override
    public int getNumRows() {
        return ((ColumnHolder)this.columns.get("__time").get()).getLength();
    }

    @Override
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public Indexed<String> getAvailableDimensions() {
        return this.availableDimensions;
    }

    @Override
    public BitmapFactory getBitmapFactoryForDimensions() {
        return this.bitmapFactory;
    }

    @Override
    @Nullable
    public ColumnHolder getColumnHolder(String columnName) {
        Supplier<ColumnHolder> columnHolderSupplier = this.columns.get(columnName);
        return columnHolderSupplier == null ? null : (ColumnHolder)columnHolderSupplier.get();
    }

    @VisibleForTesting
    public Map<String, Supplier<ColumnHolder>> getColumns() {
        return this.columns;
    }

    @VisibleForTesting
    public SmooshedFileMapper getFileMapper() {
        return this.fileMapper;
    }

    @Override
    public void close() {
        if (this.fileMapper != null) {
            this.fileMapper.close();
        }
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public Map<String, DimensionHandler> getDimensionHandlers() {
        return (Map)this.dimensionHandlers.get();
    }

    private Map<String, DimensionHandler> initDimensionHandlers(Indexed<String> availableDimensions) {
        LinkedHashMap dimensionHandlerMap = Maps.newLinkedHashMap();
        for (String dim : availableDimensions) {
            ColumnHolder columnHolder = this.getColumnHolder(dim);
            DimensionHandler handler = columnHolder.getColumnFormat().getColumnHandler(dim);
            dimensionHandlerMap.put(dim, handler);
        }
        return dimensionHandlerMap;
    }
}

