/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Supplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.data.BlockLayoutColumnarDoublesSerializer;
import org.apache.druid.segment.data.BlockLayoutColumnarDoublesSupplier;
import org.apache.druid.segment.data.BlockLayoutColumnarFloatsSerializer;
import org.apache.druid.segment.data.BlockLayoutColumnarFloatsSupplier;
import org.apache.druid.segment.data.BlockLayoutColumnarLongsSerializer;
import org.apache.druid.segment.data.BlockLayoutColumnarLongsSupplier;
import org.apache.druid.segment.data.ColumnarDoubles;
import org.apache.druid.segment.data.ColumnarDoublesSerializer;
import org.apache.druid.segment.data.ColumnarFloats;
import org.apache.druid.segment.data.ColumnarFloatsSerializer;
import org.apache.druid.segment.data.ColumnarLongs;
import org.apache.druid.segment.data.ColumnarLongsSerializer;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.DeltaLongEncodingReader;
import org.apache.druid.segment.data.EntireLayoutColumnarDoublesSerializer;
import org.apache.druid.segment.data.EntireLayoutColumnarDoublesSupplier;
import org.apache.druid.segment.data.EntireLayoutColumnarFloatsSerializer;
import org.apache.druid.segment.data.EntireLayoutColumnarFloatsSupplier;
import org.apache.druid.segment.data.EntireLayoutColumnarLongsSerializer;
import org.apache.druid.segment.data.EntireLayoutColumnarLongsSupplier;
import org.apache.druid.segment.data.IntermediateColumnarLongsSerializer;
import org.apache.druid.segment.data.LongsLongEncodingReader;
import org.apache.druid.segment.data.LongsLongEncodingWriter;
import org.apache.druid.segment.data.TableLongEncodingReader;
import org.apache.druid.segment.serde.MetaSerdeHelper;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.WriteOutBytes;

public class CompressionFactory {
    public static final LongEncodingStrategy DEFAULT_LONG_ENCODING_STRATEGY = LongEncodingStrategy.LONGS;
    public static final LongEncodingFormat LEGACY_LONG_ENCODING_FORMAT = LongEncodingFormat.LONGS;
    public static final byte DELTA_ENCODING_VERSION = 1;
    public static final byte TABLE_ENCODING_VERSION = 1;
    public static final int MAX_TABLE_SIZE = 256;
    private static byte FLAG_BOUND = (byte)-2;
    private static int FLAG_VALUE = 126;

    private CompressionFactory() {
    }

    public static boolean hasEncodingFlag(byte strategyId) {
        return strategyId < FLAG_BOUND;
    }

    public static byte setEncodingFlag(byte strategyId) {
        return CompressionFactory.hasEncodingFlag(strategyId) ? strategyId : (byte)(strategyId - FLAG_VALUE);
    }

    public static byte clearEncodingFlag(byte strategyId) {
        return CompressionFactory.hasEncodingFlag(strategyId) ? (byte)(strategyId + FLAG_VALUE) : strategyId;
    }

    static <T> MetaSerdeHelper.FieldWriter<T> longEncodingWriter(final Function<T, LongEncodingWriter> getWriter, final Function<T, CompressionStrategy> getCompressionStrategy) {
        return new MetaSerdeHelper.FieldWriter<T>(){

            @Override
            public void writeTo(ByteBuffer buffer, T x) {
                ((LongEncodingWriter)getWriter.apply(x)).putMeta(buffer, (CompressionStrategy)((Object)getCompressionStrategy.apply(x)));
            }

            @Override
            public int size(T x) {
                return ((LongEncodingWriter)getWriter.apply(x)).metaSize();
            }
        };
    }

    public static Supplier<ColumnarLongs> getLongSupplier(int totalSize, int sizePer, ByteBuffer fromBuffer, ByteOrder order, LongEncodingFormat encodingFormat, CompressionStrategy strategy) {
        if (strategy == CompressionStrategy.NONE) {
            return new EntireLayoutColumnarLongsSupplier(totalSize, encodingFormat.getReader(fromBuffer, order));
        }
        return new BlockLayoutColumnarLongsSupplier(totalSize, sizePer, fromBuffer, order, encodingFormat.getReader(fromBuffer, order), strategy);
    }

    public static ColumnarLongsSerializer getLongSerializer(String columnName, SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, ByteOrder order, LongEncodingStrategy encodingStrategy, CompressionStrategy compressionStrategy, Closer closer) {
        if (encodingStrategy == LongEncodingStrategy.AUTO) {
            return new IntermediateColumnarLongsSerializer(columnName, segmentWriteOutMedium, filenameBase, order, compressionStrategy, closer);
        }
        if (encodingStrategy == LongEncodingStrategy.LONGS) {
            if (compressionStrategy == CompressionStrategy.NONE) {
                return new EntireLayoutColumnarLongsSerializer(columnName, segmentWriteOutMedium, new LongsLongEncodingWriter(order));
            }
            return new BlockLayoutColumnarLongsSerializer(columnName, segmentWriteOutMedium, filenameBase, order, new LongsLongEncodingWriter(order), compressionStrategy, closer);
        }
        throw new IAE("unknown encoding strategy : %s", encodingStrategy.toString());
    }

    public static Supplier<ColumnarFloats> getFloatSupplier(int totalSize, int sizePer, ByteBuffer fromBuffer, ByteOrder order, CompressionStrategy strategy) {
        if (strategy == CompressionStrategy.NONE) {
            return new EntireLayoutColumnarFloatsSupplier(totalSize, fromBuffer, order);
        }
        return new BlockLayoutColumnarFloatsSupplier(totalSize, sizePer, fromBuffer, order, strategy);
    }

    public static ColumnarFloatsSerializer getFloatSerializer(String columnName, SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, ByteOrder order, CompressionStrategy compressionStrategy, Closer closer) {
        if (compressionStrategy == CompressionStrategy.NONE) {
            return new EntireLayoutColumnarFloatsSerializer(columnName, segmentWriteOutMedium, order);
        }
        return new BlockLayoutColumnarFloatsSerializer(columnName, segmentWriteOutMedium, filenameBase, order, compressionStrategy, closer);
    }

    public static Supplier<ColumnarDoubles> getDoubleSupplier(int totalSize, int sizePer, ByteBuffer fromBuffer, ByteOrder byteOrder, CompressionStrategy strategy) {
        switch (strategy) {
            case NONE: {
                return new EntireLayoutColumnarDoublesSupplier(totalSize, fromBuffer, byteOrder);
            }
        }
        return new BlockLayoutColumnarDoublesSupplier(totalSize, sizePer, fromBuffer, byteOrder, strategy);
    }

    public static ColumnarDoublesSerializer getDoubleSerializer(String columnName, SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, ByteOrder byteOrder, CompressionStrategy compression, Closer closer) {
        if (compression == CompressionStrategy.NONE) {
            return new EntireLayoutColumnarDoublesSerializer(columnName, segmentWriteOutMedium, byteOrder);
        }
        return new BlockLayoutColumnarDoublesSerializer(columnName, segmentWriteOutMedium, filenameBase, byteOrder, compression, closer);
    }

    public static interface LongEncodingReader {
        public void setBuffer(ByteBuffer var1);

        public long read(int var1);

        public void read(long[] var1, int var2, int var3, int var4);

        public int read(long[] var1, int var2, int[] var3, int var4, int var5, int var6);

        public LongEncodingReader duplicate();
    }

    public static interface LongEncodingWriter {
        public void setBuffer(ByteBuffer var1);

        public void setOutputStream(WriteOutBytes var1);

        public void write(long var1) throws IOException;

        public void flush() throws IOException;

        public void putMeta(ByteBuffer var1, CompressionStrategy var2);

        public int metaSize();

        public int getBlockSize(int var1);

        public int getNumBytes(int var1);
    }

    public static enum LongEncodingFormat {
        DELTA(0){

            @Override
            public LongEncodingReader getReader(ByteBuffer buffer, ByteOrder order) {
                return new DeltaLongEncodingReader(buffer);
            }
        }
        ,
        TABLE(1){

            @Override
            public LongEncodingReader getReader(ByteBuffer buffer, ByteOrder order) {
                return new TableLongEncodingReader(buffer);
            }
        }
        ,
        LONGS(-1){

            @Override
            public LongEncodingReader getReader(ByteBuffer buffer, ByteOrder order) {
                return new LongsLongEncodingReader(buffer, order);
            }
        };

        final byte id;
        static final Map<Byte, LongEncodingFormat> ID_MAP;

        private LongEncodingFormat(byte id) {
            this.id = id;
        }

        public byte getId() {
            return this.id;
        }

        public abstract LongEncodingReader getReader(ByteBuffer var1, ByteOrder var2);

        public static LongEncodingFormat forId(byte id) {
            return ID_MAP.get(id);
        }

        static {
            ID_MAP = new HashMap<Byte, LongEncodingFormat>();
            for (LongEncodingFormat format : LongEncodingFormat.values()) {
                ID_MAP.put(format.getId(), format);
            }
        }
    }

    public static enum LongEncodingStrategy {
        AUTO,
        LONGS;


        @JsonValue
        public String toString() {
            return StringUtils.toLowerCase(this.name());
        }

        @JsonCreator
        public static LongEncodingStrategy fromString(String name) {
            return LongEncodingStrategy.valueOf(StringUtils.toUpperCase(name));
        }
    }
}

