/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Doubles;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.DruidPredicateMatch;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherColumnProcessorFactory;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnIndexCapabilities;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.semantic.DruidPredicateIndexes;
import org.apache.druid.segment.index.semantic.LexicographicalRangeIndexes;
import org.apache.druid.segment.index.semantic.NullValueIndex;
import org.apache.druid.segment.index.semantic.NumericRangeIndexes;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class BoundFilter
implements Filter {
    private final BoundDimFilter boundDimFilter;
    private final ExtractionFn extractionFn;
    private final FilterTuning filterTuning;

    public BoundFilter(BoundDimFilter boundDimFilter) {
        this.boundDimFilter = boundDimFilter;
        this.extractionFn = boundDimFilter.getExtractionFn();
        this.filterTuning = boundDimFilter.getFilterTuning();
    }

    @Override
    @Nullable
    public BitmapColumnIndex getBitmapColumnIndex(ColumnIndexSelector selector) {
        DruidPredicateIndexes predicateIndexes;
        Object rangeIndexes;
        if (!Filters.checkFilterTuningUseIndex(this.boundDimFilter.getDimension(), selector, this.filterTuning)) {
            return null;
        }
        ColumnIndexSupplier indexSupplier = selector.getIndexSupplier(this.boundDimFilter.getDimension());
        if (indexSupplier == null) {
            DruidPredicateMatch match = this.getPredicateFactory().makeStringPredicate().apply(null);
            return Filters.makeMissingColumnNullIndex(match, selector);
        }
        if (this.supportStringShortCircuit() && (rangeIndexes = indexSupplier.as(LexicographicalRangeIndexes.class)) != null) {
            BitmapColumnIndex rangeBitmaps = rangeIndexes.forRange(this.boundDimFilter.getLower(), this.boundDimFilter.isLowerStrict(), this.boundDimFilter.getUpper(), this.boundDimFilter.isUpperStrict());
            if (rangeBitmaps == null) {
                return null;
            }
            if (this.doesMatchNull()) {
                return this.wrapRangeIndexWithNullValueIndex(indexSupplier, rangeBitmaps);
            }
            return rangeBitmaps;
        }
        if (this.supportNumericShortCircuit() && (rangeIndexes = indexSupplier.as(NumericRangeIndexes.class)) != null) {
            boolean upperValid;
            Double lower = this.boundDimFilter.hasLowerBound() ? Doubles.tryParse((String)this.boundDimFilter.getLower()) : null;
            Double upper = this.boundDimFilter.hasUpperBound() ? Doubles.tryParse((String)this.boundDimFilter.getUpper()) : null;
            boolean lowerValid = !this.boundDimFilter.hasLowerBound() || lower != null;
            boolean bl = upperValid = !this.boundDimFilter.hasUpperBound() || upper != null;
            if (lowerValid && upperValid) {
                BitmapColumnIndex rangeBitmaps = rangeIndexes.forRange(lower, this.boundDimFilter.isLowerStrict(), upper, this.boundDimFilter.isUpperStrict());
                if (rangeBitmaps == null) {
                    return null;
                }
                if (this.doesMatchNull()) {
                    return this.wrapRangeIndexWithNullValueIndex(indexSupplier, rangeBitmaps);
                }
                return rangeBitmaps;
            }
        }
        if ((predicateIndexes = indexSupplier.as(DruidPredicateIndexes.class)) != null) {
            return predicateIndexes.forPredicate(this.getPredicateFactory());
        }
        return null;
    }

    @Nullable
    private BitmapColumnIndex wrapRangeIndexWithNullValueIndex(ColumnIndexSupplier indexSupplier, final BitmapColumnIndex rangeIndex) {
        NullValueIndex nulls = indexSupplier.as(NullValueIndex.class);
        if (nulls == null) {
            return null;
        }
        final BitmapColumnIndex nullBitmap = nulls.get();
        return new BitmapColumnIndex(){

            @Override
            public ColumnIndexCapabilities getIndexCapabilities() {
                return rangeIndex.getIndexCapabilities().merge(nullBitmap.getIndexCapabilities());
            }

            @Override
            public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknown) {
                return bitmapResultFactory.union((Iterable<T>)ImmutableList.of(rangeIndex.computeBitmapResult(bitmapResultFactory, false), nullBitmap.computeBitmapResult(bitmapResultFactory, false)));
            }
        };
    }

    private boolean supportStringShortCircuit() {
        return this.boundDimFilter.getOrdering().equals(StringComparators.LEXICOGRAPHIC) && this.extractionFn == null;
    }

    private boolean supportNumericShortCircuit() {
        return this.boundDimFilter.getOrdering().equals(StringComparators.NUMERIC) && this.extractionFn == null;
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return Filters.makeValueMatcher(factory, this.boundDimFilter.getDimension(), this.getPredicateFactory());
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        return ColumnProcessors.makeVectorProcessor(this.boundDimFilter.getDimension(), VectorValueMatcherColumnProcessorFactory.instance(), factory).makeMatcher(this.getPredicateFactory());
    }

    @Override
    public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return true;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return this.boundDimFilter.getRequiredColumns();
    }

    @Override
    public boolean supportsRequiredColumnRewrite() {
        return true;
    }

    @Override
    public Filter rewriteRequiredColumns(Map<String, String> columnRewrites) {
        String rewriteDimensionTo = columnRewrites.get(this.boundDimFilter.getDimension());
        if (rewriteDimensionTo == null) {
            throw new IAE("Received a non-applicable rewrite: %s, filter's dimension: %s", columnRewrites, this.boundDimFilter.getDimension());
        }
        BoundDimFilter newDimFilter = new BoundDimFilter(rewriteDimensionTo, this.boundDimFilter.getLower(), this.boundDimFilter.getUpper(), this.boundDimFilter.isLowerStrict(), this.boundDimFilter.isUpperStrict(), null, this.boundDimFilter.getExtractionFn(), this.boundDimFilter.getOrdering());
        return new BoundFilter(newDimFilter);
    }

    private DruidPredicateFactory getPredicateFactory() {
        return new BoundDimFilterDruidPredicateFactory(this.extractionFn, this.boundDimFilter);
    }

    private boolean doesMatchNull() {
        return BoundFilter.doesMatch(null, this.boundDimFilter);
    }

    private static boolean doesMatch(String input, BoundDimFilter boundDimFilter) {
        if (input == null) {
            return (!boundDimFilter.hasLowerBound() || NullHandling.isNullOrEquivalent(boundDimFilter.getLower()) && !boundDimFilter.isLowerStrict()) && (!boundDimFilter.hasUpperBound() || !NullHandling.isNullOrEquivalent(boundDimFilter.getUpper()) || !boundDimFilter.isUpperStrict());
        }
        int lowerComparing = 1;
        int upperComparing = 1;
        if (boundDimFilter.hasLowerBound()) {
            lowerComparing = boundDimFilter.getOrdering().compare(input, boundDimFilter.getLower());
        }
        if (boundDimFilter.hasUpperBound()) {
            upperComparing = boundDimFilter.getOrdering().compare(boundDimFilter.getUpper(), input);
        }
        if (boundDimFilter.isLowerStrict() && boundDimFilter.isUpperStrict()) {
            return lowerComparing > 0 && upperComparing > 0;
        }
        if (boundDimFilter.isLowerStrict()) {
            return lowerComparing > 0 && upperComparing >= 0;
        }
        if (boundDimFilter.isUpperStrict()) {
            return lowerComparing >= 0 && upperComparing > 0;
        }
        return lowerComparing >= 0 && upperComparing >= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundFilter that = (BoundFilter)o;
        return Objects.equals(this.boundDimFilter, that.boundDimFilter) && Objects.equals(this.extractionFn, that.extractionFn) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.boundDimFilter, this.extractionFn, this.filterTuning);
    }

    public String toString() {
        return this.boundDimFilter.toString();
    }

    @VisibleForTesting
    static class BoundDimFilterDruidPredicateFactory
    implements DruidPredicateFactory {
        private final ExtractionFn extractionFn;
        private final BoundDimFilter boundDimFilter;
        private final Supplier<DruidLongPredicate> longPredicateSupplier;
        private final Supplier<DruidFloatPredicate> floatPredicateSupplier;
        private final Supplier<DruidDoublePredicate> doublePredicateSupplier;

        BoundDimFilterDruidPredicateFactory(ExtractionFn extractionFn, BoundDimFilter boundDimFilter) {
            this.extractionFn = extractionFn;
            this.boundDimFilter = boundDimFilter;
            this.longPredicateSupplier = boundDimFilter.getLongPredicateSupplier();
            this.floatPredicateSupplier = boundDimFilter.getFloatPredicateSupplier();
            this.doublePredicateSupplier = boundDimFilter.getDoublePredicateSupplier();
        }

        @Override
        public DruidObjectPredicate<String> makeStringPredicate() {
            if (this.extractionFn != null) {
                return input -> DruidPredicateMatch.of(BoundFilter.doesMatch(this.extractionFn.apply((String)input), this.boundDimFilter));
            }
            return input -> DruidPredicateMatch.of(BoundFilter.doesMatch(input, this.boundDimFilter));
        }

        @Override
        public DruidLongPredicate makeLongPredicate() {
            if (this.extractionFn != null) {
                return input -> DruidPredicateMatch.of(BoundFilter.doesMatch(this.extractionFn.apply(input), this.boundDimFilter));
            }
            if (this.boundDimFilter.getOrdering().equals(StringComparators.NUMERIC)) {
                return (DruidLongPredicate)this.longPredicateSupplier.get();
            }
            return input -> DruidPredicateMatch.of(BoundFilter.doesMatch(String.valueOf(input), this.boundDimFilter));
        }

        @Override
        public DruidFloatPredicate makeFloatPredicate() {
            if (this.extractionFn != null) {
                return input -> DruidPredicateMatch.of(BoundFilter.doesMatch(this.extractionFn.apply(Float.valueOf(input)), this.boundDimFilter));
            }
            if (this.boundDimFilter.getOrdering().equals(StringComparators.NUMERIC)) {
                return (DruidFloatPredicate)this.floatPredicateSupplier.get();
            }
            return input -> DruidPredicateMatch.of(BoundFilter.doesMatch(String.valueOf(input), this.boundDimFilter));
        }

        @Override
        public DruidDoublePredicate makeDoublePredicate() {
            if (this.extractionFn != null) {
                return input -> DruidPredicateMatch.of(BoundFilter.doesMatch(this.extractionFn.apply(input), this.boundDimFilter));
            }
            if (this.boundDimFilter.getOrdering().equals(StringComparators.NUMERIC)) {
                return (DruidDoublePredicate)this.doublePredicateSupplier.get();
            }
            return input -> DruidPredicateMatch.of(BoundFilter.doesMatch(String.valueOf(input), this.boundDimFilter));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BoundDimFilterDruidPredicateFactory that = (BoundDimFilterDruidPredicateFactory)o;
            return Objects.equals(this.extractionFn, that.extractionFn) && Objects.equals(this.boundDimFilter, that.boundDimFilter);
        }

        public int hashCode() {
            return Objects.hash(this.extractionFn, this.boundDimFilter);
        }
    }
}

