/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorAndSize;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.DimensionIndexer;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.incremental.AppendableIndexBuilder;
import org.apache.druid.segment.incremental.AppendableIndexSpec;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexRow;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.IndexSizeExceededException;
import org.apache.druid.utils.JvmUtils;

public class OnheapIncrementalIndex
extends IncrementalIndex {
    private static final Logger log = new Logger(OnheapIncrementalIndex.class);
    private static final long ROLLUP_RATIO_FOR_AGGREGATOR_FOOTPRINT_ESTIMATION = 100L;
    private static final int ROUGH_OVERHEAD_PER_MAP_ENTRY = 44;
    private final ConcurrentHashMap<Integer, Aggregator[]> aggregators = new ConcurrentHashMap();
    private final IncrementalIndex.FactsHolder facts;
    private final AtomicInteger indexIncrement = new AtomicInteger(0);
    private final long maxBytesPerRowForAggregators;
    protected final int maxRowCount;
    protected final long maxBytesInMemory;
    private final boolean useMaxMemoryEstimates;
    @Nullable
    private Map<String, ColumnSelectorFactory> selectors;
    @Nullable
    private Map<String, ColumnSelectorFactory> combiningAggSelectors;
    @Nullable
    private String outOfRowsReason = null;

    OnheapIncrementalIndex(IncrementalIndexSchema incrementalIndexSchema, int maxRowCount, long maxBytesInMemory, boolean preserveExistingMetrics, boolean useMaxMemoryEstimates) {
        super(incrementalIndexSchema, preserveExistingMetrics, useMaxMemoryEstimates);
        this.maxRowCount = maxRowCount;
        this.maxBytesInMemory = maxBytesInMemory == 0L ? Long.MAX_VALUE : maxBytesInMemory;
        this.facts = incrementalIndexSchema.isRollup() ? new RollupFactsHolder(this.dimsComparator(), this.getDimensions()) : new PlainFactsHolder(this.dimsComparator());
        this.maxBytesPerRowForAggregators = useMaxMemoryEstimates ? OnheapIncrementalIndex.getMaxBytesPerRowForAggregators(incrementalIndexSchema) : 0L;
        this.useMaxMemoryEstimates = useMaxMemoryEstimates;
    }

    private static long getMaxBytesPerRowForAggregators(IncrementalIndexSchema incrementalIndexSchema) {
        long rowsPerAggregator = incrementalIndexSchema.isRollup() ? 100L : 1L;
        long maxAggregatorIntermediateSize = 4L * (long)incrementalIndexSchema.getMetrics().length;
        for (AggregatorFactory aggregator : incrementalIndexSchema.getMetrics()) {
            maxAggregatorIntermediateSize += (long)aggregator.guessAggregatorHeapFootprint(rowsPerAggregator) + 16L;
        }
        return maxAggregatorIntermediateSize;
    }

    @Override
    public IncrementalIndex.FactsHolder getFacts() {
        return this.facts;
    }

    @Override
    protected void initAggs(AggregatorFactory[] metrics, IncrementalIndex.InputRowHolder inputRowHolder) {
        CachingColumnSelectorFactory nonComplexColumnSelectorFactory = null;
        this.selectors = new HashMap<String, ColumnSelectorFactory>();
        this.combiningAggSelectors = new HashMap<String, ColumnSelectorFactory>();
        for (AggregatorFactory agg : metrics) {
            CachingColumnSelectorFactory factory;
            if (agg.getIntermediateType().is(ValueType.COMPLEX)) {
                factory = new CachingColumnSelectorFactory(this.makeColumnSelectorFactory(agg, inputRowHolder));
            } else {
                if (nonComplexColumnSelectorFactory == null) {
                    nonComplexColumnSelectorFactory = new CachingColumnSelectorFactory(this.makeColumnSelectorFactory(null, inputRowHolder));
                }
                factory = nonComplexColumnSelectorFactory;
            }
            this.selectors.put(agg.getName(), factory);
        }
        if (this.preserveExistingMetrics) {
            for (AggregatorFactory agg : metrics) {
                CachingColumnSelectorFactory factory;
                AggregatorFactory combiningAgg = agg.getCombiningFactory();
                if (combiningAgg.getIntermediateType().is(ValueType.COMPLEX)) {
                    factory = new CachingColumnSelectorFactory(this.makeColumnSelectorFactory(combiningAgg, inputRowHolder));
                } else {
                    if (nonComplexColumnSelectorFactory == null) {
                        nonComplexColumnSelectorFactory = new CachingColumnSelectorFactory(this.makeColumnSelectorFactory(null, inputRowHolder));
                    }
                    factory = nonComplexColumnSelectorFactory;
                }
                this.combiningAggSelectors.put(combiningAgg.getName(), factory);
            }
        }
    }

    @Override
    protected IncrementalIndex.AddToFactsResult addToFacts(IncrementalIndexRow key, IncrementalIndex.InputRowHolder inputRowHolder, boolean skipMaxRowsInMemoryCheck) throws IndexSizeExceededException {
        ArrayList<String> parseExceptionMessages = new ArrayList<String>();
        int priorIndex = this.facts.getPriorIndex(key);
        AggregatorFactory[] metrics = this.getMetrics();
        AtomicInteger numEntries = this.getNumEntries();
        AtomicLong totalSizeInBytes = this.getBytesInMemory();
        if (-1 != priorIndex) {
            Aggregator[] aggs = this.concurrentGet(priorIndex);
            long aggSizeDelta = this.doAggregate(metrics, aggs, inputRowHolder, parseExceptionMessages);
            totalSizeInBytes.addAndGet(this.useMaxMemoryEstimates ? 0L : aggSizeDelta);
        } else {
            Aggregator[] aggs = this.preserveExistingMetrics ? new Aggregator[metrics.length * 2] : new Aggregator[metrics.length];
            long aggSizeForRow = this.factorizeAggs(metrics, aggs);
            aggSizeForRow += this.doAggregate(metrics, aggs, inputRowHolder, parseExceptionMessages);
            int rowIndex = this.indexIncrement.getAndIncrement();
            this.concurrentSet(rowIndex, aggs);
            if (!(numEntries.get() < this.maxRowCount && totalSizeInBytes.get() < this.maxBytesInMemory || this.facts.getPriorIndex(key) != -1 || skipMaxRowsInMemoryCheck)) {
                throw new IndexSizeExceededException("Maximum number of rows [%d] or max size in bytes [%d] reached", this.maxRowCount, this.maxBytesInMemory);
            }
            int prev = this.facts.putIfAbsent(key, rowIndex);
            if (-1 != prev) {
                throw DruidException.defensive("Encountered existing fact entry for new key, possible concurrent add?", new Object[0]);
            }
            numEntries.incrementAndGet();
            long estimatedSizeOfAggregators = this.useMaxMemoryEstimates ? this.maxBytesPerRowForAggregators : aggSizeForRow;
            long rowSize = key.estimateBytesInMemory() + estimatedSizeOfAggregators + 44L;
            totalSizeInBytes.addAndGet(rowSize);
        }
        return new IncrementalIndex.AddToFactsResult(numEntries.get(), totalSizeInBytes.get(), parseExceptionMessages);
    }

    @Override
    public int getLastRowIndex() {
        return this.indexIncrement.get() - 1;
    }

    private long factorizeAggs(AggregatorFactory[] metrics, Aggregator[] aggs) {
        long totalInitialSizeBytes = 0L;
        long aggReferenceSize = 8L;
        for (int i = 0; i < metrics.length; ++i) {
            AggregatorFactory combiningAgg;
            AggregatorFactory agg = metrics[i];
            if (this.useMaxMemoryEstimates) {
                aggs[i] = agg.factorize(this.selectors.get(agg.getName()));
            } else {
                AggregatorAndSize aggregatorAndSize = agg.factorizeWithSize(this.selectors.get(agg.getName()));
                aggs[i] = aggregatorAndSize.getAggregator();
                totalInitialSizeBytes += aggregatorAndSize.getInitialSizeBytes();
                totalInitialSizeBytes += 8L;
            }
            if (!this.preserveExistingMetrics) continue;
            if (this.useMaxMemoryEstimates) {
                combiningAgg = agg.getCombiningFactory();
                aggs[i + metrics.length] = combiningAgg.factorize(this.combiningAggSelectors.get(combiningAgg.getName()));
                continue;
            }
            combiningAgg = agg.getCombiningFactory();
            AggregatorAndSize aggregatorAndSize = combiningAgg.factorizeWithSize(this.combiningAggSelectors.get(combiningAgg.getName()));
            aggs[i + metrics.length] = aggregatorAndSize.getAggregator();
            totalInitialSizeBytes += aggregatorAndSize.getInitialSizeBytes();
            totalInitialSizeBytes += 8L;
        }
        return totalInitialSizeBytes;
    }

    private long doAggregate(AggregatorFactory[] metrics, Aggregator[] aggs, IncrementalIndex.InputRowHolder inputRowHolder, List<String> parseExceptionsHolder) {
        long totalIncrementalBytes = 0L;
        for (int i = 0; i < metrics.length; ++i) {
            Aggregator agg = this.preserveExistingMetrics && inputRowHolder.getRow() instanceof MapBasedRow && ((MapBasedRow)((Object)inputRowHolder.getRow())).getEvent().containsKey(metrics[i].getName()) ? aggs[i + metrics.length] : aggs[i];
            try {
                if (this.useMaxMemoryEstimates) {
                    agg.aggregate();
                    continue;
                }
                totalIncrementalBytes += agg.aggregateWithSize();
                continue;
            }
            catch (ParseException e) {
                if (this.preserveExistingMetrics) {
                    log.warn(e, "Failing ingestion as preserveExistingMetrics is enabled but selector of aggregator[%s] received incompatible type.", metrics[i].getName());
                    throw e;
                }
                log.debug(e, "Encountered parse error, skipping aggregator[%s].", metrics[i].getName());
                parseExceptionsHolder.add(e.getMessage());
            }
        }
        return totalIncrementalBytes;
    }

    private void closeAggregators() {
        Closer closer = Closer.create();
        for (Aggregator[] aggs : this.aggregators.values()) {
            for (Aggregator agg : aggs) {
                closer.register(agg);
            }
        }
        try {
            closer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Aggregator[] concurrentGet(int offset) {
        return this.aggregators.get(offset);
    }

    protected void concurrentSet(int offset, Aggregator[] value) {
        this.aggregators.put(offset, value);
    }

    @Override
    public boolean canAppendRow() {
        boolean canAdd;
        boolean countCheck = this.size() < this.maxRowCount;
        boolean sizeCheck = this.maxBytesInMemory <= 0L || this.getBytesInMemory().get() < this.maxBytesInMemory;
        boolean bl = canAdd = countCheck && sizeCheck;
        if (!countCheck && !sizeCheck) {
            this.outOfRowsReason = StringUtils.format("Maximum number of rows [%d] and maximum size in bytes [%d] reached", this.maxRowCount, this.maxBytesInMemory);
        } else if (!countCheck) {
            this.outOfRowsReason = StringUtils.format("Maximum number of rows [%d] reached", this.maxRowCount);
        } else if (!sizeCheck) {
            this.outOfRowsReason = StringUtils.format("Maximum size in bytes [%d] reached", this.maxBytesInMemory);
        }
        return canAdd;
    }

    @Override
    public String getOutOfRowsReason() {
        return this.outOfRowsReason;
    }

    protected Aggregator[] getAggsForRow(int rowOffset) {
        return this.concurrentGet(rowOffset);
    }

    @Override
    public float getMetricFloatValue(int rowOffset, int aggOffset) {
        return ((Number)this.getMetricHelper(this.getMetricAggs(), this.concurrentGet(rowOffset), aggOffset, Aggregator::getFloat)).floatValue();
    }

    @Override
    public long getMetricLongValue(int rowOffset, int aggOffset) {
        return ((Number)this.getMetricHelper(this.getMetricAggs(), this.concurrentGet(rowOffset), aggOffset, Aggregator::getLong)).longValue();
    }

    @Override
    public Object getMetricObjectValue(int rowOffset, int aggOffset) {
        return this.getMetricHelper(this.getMetricAggs(), this.concurrentGet(rowOffset), aggOffset, Aggregator::get);
    }

    @Override
    protected double getMetricDoubleValue(int rowOffset, int aggOffset) {
        return ((Number)this.getMetricHelper(this.getMetricAggs(), this.concurrentGet(rowOffset), aggOffset, Aggregator::getDouble)).doubleValue();
    }

    @Override
    public boolean isNull(int rowOffset, int aggOffset) {
        if (this.preserveExistingMetrics) {
            return this.concurrentGet(rowOffset)[aggOffset].isNull() && this.concurrentGet(rowOffset)[aggOffset + this.getMetricAggs().length].isNull();
        }
        return this.concurrentGet(rowOffset)[aggOffset].isNull();
    }

    @Override
    public Iterable<Row> iterableWithPostAggregations(@Nullable List<PostAggregator> postAggs, boolean descending) {
        AggregatorFactory[] metrics = this.getMetricAggs();
        return () -> {
            List<IncrementalIndex.DimensionDesc> dimensions = this.getDimensions();
            return Iterators.transform(this.getFacts().iterator(descending), incrementalIndexRow -> {
                int rowOffset = incrementalIndexRow.getRowIndex();
                Object[] theDims = incrementalIndexRow.getDims();
                LinkedHashMap theVals = Maps.newLinkedHashMap();
                for (int i = 0; i < theDims.length; ++i) {
                    Object dim = theDims[i];
                    IncrementalIndex.DimensionDesc dimensionDesc = (IncrementalIndex.DimensionDesc)dimensions.get(i);
                    if (dimensionDesc == null) continue;
                    String dimensionName = dimensionDesc.getName();
                    DimensionHandler handler = dimensionDesc.getHandler();
                    if (dim == null || handler.getLengthOfEncodedKeyComponent(dim) == 0) {
                        theVals.put(dimensionName, null);
                        continue;
                    }
                    DimensionIndexer indexer = dimensionDesc.getIndexer();
                    Object rowVals = indexer.convertUnsortedEncodedKeyComponentToActualList(dim);
                    theVals.put(dimensionName, rowVals);
                }
                Aggregator[] aggs = this.getAggsForRow(rowOffset);
                int aggLength = this.preserveExistingMetrics ? aggs.length / 2 : aggs.length;
                for (int i = 0; i < aggLength; ++i) {
                    theVals.put(metrics[i].getName(), this.getMetricHelper(metrics, aggs, i, Aggregator::get));
                }
                if (postAggs != null) {
                    for (PostAggregator postAgg : postAggs) {
                        theVals.put(postAgg.getName(), postAgg.compute(theVals));
                    }
                }
                return new MapBasedRow(incrementalIndexRow.getTimestamp(), (Map<String, Object>)theVals);
            });
        };
    }

    @Nullable
    private <T> Object getMetricHelper(AggregatorFactory[] metrics, Aggregator[] aggs, int aggOffset, Function<Aggregator, T> getMetricTypeFunction) {
        if (this.preserveExistingMetrics) {
            if (aggs[aggOffset].isNull()) {
                return getMetricTypeFunction.apply(aggs[aggOffset + metrics.length]);
            }
            if (aggs[aggOffset + metrics.length].isNull()) {
                return getMetricTypeFunction.apply(aggs[aggOffset]);
            }
            AggregatorFactory aggregatorFactory = metrics[aggOffset];
            T aggregatedFromSource = getMetricTypeFunction.apply(aggs[aggOffset]);
            T aggregatedFromCombined = getMetricTypeFunction.apply(aggs[aggOffset + metrics.length]);
            return aggregatorFactory.combine(aggregatedFromSource, aggregatedFromCombined);
        }
        return getMetricTypeFunction.apply(aggs[aggOffset]);
    }

    @Override
    public void close() {
        super.close();
        this.closeAggregators();
        this.aggregators.clear();
        this.facts.clear();
        if (this.selectors != null) {
            this.selectors.clear();
        }
        if (this.combiningAggSelectors != null) {
            this.combiningAggSelectors.clear();
        }
    }

    static final class PlainFactsHolder
    implements IncrementalIndex.FactsHolder {
        private final ConcurrentNavigableMap<Long, Deque<IncrementalIndexRow>> facts = new ConcurrentSkipListMap<Long, Deque<IncrementalIndexRow>>();
        private final Comparator<IncrementalIndexRow> incrementalIndexRowComparator;

        public PlainFactsHolder(Comparator<IncrementalIndexRow> incrementalIndexRowComparator) {
            this.incrementalIndexRowComparator = incrementalIndexRowComparator;
        }

        @Override
        public int getPriorIndex(IncrementalIndexRow key) {
            return -1;
        }

        @Override
        public long getMinTimeMillis() {
            return (Long)this.facts.firstKey();
        }

        @Override
        public long getMaxTimeMillis() {
            return (Long)this.facts.lastKey();
        }

        @Override
        public Iterator<IncrementalIndexRow> iterator(boolean descending) {
            if (descending) {
                return this.timeOrderedConcat(this.facts.descendingMap().values(), true).iterator();
            }
            return this.timeOrderedConcat(this.facts.values(), false).iterator();
        }

        @Override
        public Iterable<IncrementalIndexRow> timeRangeIterable(boolean descending, long timeStart, long timeEnd) {
            SortedMap subMap = this.facts.subMap((Object)timeStart, (Object)timeEnd);
            SortedMap rangeMap = descending ? subMap.descendingMap() : subMap;
            return this.timeOrderedConcat(rangeMap.values(), descending);
        }

        private Iterable<IncrementalIndexRow> timeOrderedConcat(Iterable<Deque<IncrementalIndexRow>> iterable, boolean descending) {
            return () -> Iterators.concat((Iterator)Iterators.transform(iterable.iterator(), input -> descending ? input.descendingIterator() : input.iterator()));
        }

        private Stream<IncrementalIndexRow> timeAndDimsOrderedConcat(Collection<Deque<IncrementalIndexRow>> rowGroups) {
            return rowGroups.stream().flatMap(Collection::stream).sorted(this.incrementalIndexRowComparator);
        }

        @Override
        public Iterable<IncrementalIndexRow> keySet() {
            return this.timeOrderedConcat(this.facts.values(), false);
        }

        @Override
        public Iterable<IncrementalIndexRow> persistIterable() {
            return () -> this.timeAndDimsOrderedConcat(this.facts.values()).iterator();
        }

        @Override
        public int putIfAbsent(IncrementalIndexRow key, int rowIndex) {
            Long time = key.getTimestamp();
            Deque rows = (Deque)this.facts.get(time);
            if (rows == null) {
                this.facts.putIfAbsent(time, new ConcurrentLinkedDeque());
                rows = (Deque)this.facts.get(time);
            }
            key.setRowIndex(rowIndex);
            rows.add(key);
            return -1;
        }

        @Override
        public void clear() {
            this.facts.clear();
        }
    }

    static final class RollupFactsHolder
    implements IncrementalIndex.FactsHolder {
        private final ConcurrentNavigableMap<IncrementalIndexRow, IncrementalIndexRow> facts;
        private final List<IncrementalIndex.DimensionDesc> dimensionDescsList;

        RollupFactsHolder(Comparator<IncrementalIndexRow> incrementalIndexRowComparator, List<IncrementalIndex.DimensionDesc> dimensionDescsList) {
            this.facts = new ConcurrentSkipListMap<IncrementalIndexRow, IncrementalIndexRow>(incrementalIndexRowComparator);
            this.dimensionDescsList = dimensionDescsList;
        }

        @Override
        public int getPriorIndex(IncrementalIndexRow key) {
            IncrementalIndexRow row = (IncrementalIndexRow)this.facts.get(key);
            return row == null ? -1 : row.getRowIndex();
        }

        @Override
        public long getMinTimeMillis() {
            return ((IncrementalIndexRow)this.facts.firstKey()).getTimestamp();
        }

        @Override
        public long getMaxTimeMillis() {
            return ((IncrementalIndexRow)this.facts.lastKey()).getTimestamp();
        }

        @Override
        public Iterator<IncrementalIndexRow> iterator(boolean descending) {
            if (descending) {
                return this.facts.descendingMap().keySet().iterator();
            }
            return this.keySet().iterator();
        }

        @Override
        public Iterable<IncrementalIndexRow> timeRangeIterable(boolean descending, long timeStart, long timeEnd) {
            IncrementalIndexRow start = new IncrementalIndexRow(timeStart, new Object[0], this.dimensionDescsList);
            IncrementalIndexRow end = new IncrementalIndexRow(timeEnd, new Object[0], this.dimensionDescsList);
            SortedMap subMap = this.facts.subMap((Object)start, (Object)end);
            SortedMap rangeMap = descending ? subMap.descendingMap() : subMap;
            return rangeMap.keySet();
        }

        @Override
        public Iterable<IncrementalIndexRow> keySet() {
            return this.facts.keySet();
        }

        @Override
        public Iterable<IncrementalIndexRow> persistIterable() {
            return this.keySet();
        }

        @Override
        public int putIfAbsent(IncrementalIndexRow key, int rowIndex) {
            key.setRowIndex(rowIndex);
            IncrementalIndexRow prev = this.facts.putIfAbsent(key, key);
            return prev == null ? -1 : prev.getRowIndex();
        }

        @Override
        public void clear() {
            this.facts.clear();
        }
    }

    public static class Spec
    implements AppendableIndexSpec {
        private static final boolean DEFAULT_PRESERVE_EXISTING_METRICS = false;
        public static final String TYPE = "onheap";
        final boolean preserveExistingMetrics;

        public Spec() {
            this.preserveExistingMetrics = false;
        }

        @JsonCreator
        public Spec(@JsonProperty(value="preserveExistingMetrics") @Nullable Boolean preserveExistingMetrics) {
            this.preserveExistingMetrics = preserveExistingMetrics != null ? preserveExistingMetrics : false;
        }

        @JsonProperty
        public boolean isPreserveExistingMetrics() {
            return this.preserveExistingMetrics;
        }

        @Override
        public AppendableIndexBuilder builder() {
            return new Builder().setPreserveExistingMetrics(this.preserveExistingMetrics);
        }

        @Override
        public long getDefaultMaxBytesInMemory() {
            return JvmUtils.getRuntimeInfo().getMaxHeapSizeBytes() / 6L;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Spec spec = (Spec)o;
            return this.preserveExistingMetrics == spec.preserveExistingMetrics;
        }

        public int hashCode() {
            return Objects.hash(this.preserveExistingMetrics);
        }
    }

    public static class Builder
    extends AppendableIndexBuilder {
        @Override
        protected OnheapIncrementalIndex buildInner() {
            return new OnheapIncrementalIndex(Objects.requireNonNull(this.incrementalIndexSchema, "incrementIndexSchema is null"), this.maxRowCount, this.maxBytesInMemory, this.preserveExistingMetrics, this.useMaxMemoryEstimates);
        }
    }

    static class CachingColumnSelectorFactory
    implements ColumnSelectorFactory {
        private final HashMap<String, ColumnValueSelector<?>> columnSelectorMap;
        private final ColumnSelectorFactory delegate;

        public CachingColumnSelectorFactory(ColumnSelectorFactory delegate) {
            this.delegate = delegate;
            this.columnSelectorMap = new HashMap();
        }

        @Override
        public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
            return this.delegate.makeDimensionSelector(dimensionSpec);
        }

        @Override
        public ColumnValueSelector<?> makeColumnValueSelector(String columnName) {
            ColumnValueSelector existing = this.columnSelectorMap.get(columnName);
            if (existing != null) {
                return existing;
            }
            ColumnValueSelector columnValueSelector = this.delegate.makeColumnValueSelector(columnName);
            existing = this.columnSelectorMap.putIfAbsent(columnName, columnValueSelector);
            return existing != null ? existing : columnValueSelector;
        }

        @Override
        @Nullable
        public ColumnCapabilities getColumnCapabilities(String columnName) {
            return this.delegate.getColumnCapabilities(columnName);
        }
    }
}

