/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.LongColumnSelector;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.ColumnarLongs;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.nested.NestedCommonFormatColumn;
import org.apache.druid.segment.vector.BaseLongVectorValueSelector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.VectorSelectorUtils;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.roaringbitmap.PeekableIntIterator;

public class ScalarLongColumn
implements NestedCommonFormatColumn {
    private final FixedIndexed<Long> longDictionary;
    private final ColumnarLongs valueColumn;
    private final ImmutableBitmap nullValueIndex;

    public ScalarLongColumn(FixedIndexed<Long> longDictionary, ColumnarLongs valueColumn, ImmutableBitmap nullValueIndex) {
        this.longDictionary = longDictionary;
        this.valueColumn = valueColumn;
        this.nullValueIndex = nullValueIndex;
    }

    @Override
    public Indexed<Long> getLongDictionary() {
        return this.longDictionary;
    }

    @Override
    public ColumnType getLogicalType() {
        return ColumnType.LONG;
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(final ReadableOffset offset) {
        return new LongColumnSelector(){
            private PeekableIntIterator nullIterator;
            private int nullMark;
            private int offsetMark;
            {
                this.nullIterator = ScalarLongColumn.this.nullValueIndex.peekableIterator();
                this.nullMark = -1;
                this.offsetMark = -1;
            }

            @Override
            public long getLong() {
                return ScalarLongColumn.this.valueColumn.get(offset.getOffset());
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("longColumn", ScalarLongColumn.this.valueColumn);
                inspector.visit("nullBitmap", ScalarLongColumn.this.nullValueIndex);
            }

            @Override
            public boolean isNull() {
                if (NullHandling.replaceWithDefault()) {
                    return false;
                }
                int i = offset.getOffset();
                if (i < this.offsetMark) {
                    this.nullMark = -1;
                    this.nullIterator = ScalarLongColumn.this.nullValueIndex.peekableIterator();
                }
                this.offsetMark = i;
                if (this.nullMark < i) {
                    this.nullIterator.advanceIfNeeded(this.offsetMark);
                    if (this.nullIterator.hasNext()) {
                        this.nullMark = this.nullIterator.next();
                    }
                }
                return this.nullMark == this.offsetMark;
            }
        };
    }

    @Override
    public VectorValueSelector makeVectorValueSelector(ReadableVectorOffset offset) {
        return new BaseLongVectorValueSelector(offset){
            private final long[] valueVector;
            @Nullable
            private boolean[] nullVector;
            private int id;
            @Nullable
            private PeekableIntIterator nullIterator;
            private int offsetMark;
            {
                this.valueVector = new long[this.offset.getMaxVectorSize()];
                this.nullVector = null;
                this.id = -1;
                this.nullIterator = ScalarLongColumn.this.nullValueIndex.peekableIterator();
                this.offsetMark = -1;
            }

            @Override
            public long[] getLongVector() {
                this.computeVectorsIfNeeded();
                return this.valueVector;
            }

            @Override
            @Nullable
            public boolean[] getNullVector() {
                if (NullHandling.replaceWithDefault()) {
                    return null;
                }
                this.computeVectorsIfNeeded();
                return this.nullVector;
            }

            private void computeVectorsIfNeeded() {
                if (this.id == this.offset.getId()) {
                    return;
                }
                if (this.offset.isContiguous()) {
                    if (this.offset.getStartOffset() < this.offsetMark) {
                        this.nullIterator = ScalarLongColumn.this.nullValueIndex.peekableIterator();
                    }
                    this.offsetMark = this.offset.getStartOffset() + this.offset.getCurrentVectorSize();
                    ScalarLongColumn.this.valueColumn.get(this.valueVector, this.offset.getStartOffset(), this.offset.getCurrentVectorSize());
                } else {
                    int[] offsets = this.offset.getOffsets();
                    if (offsets[offsets.length - 1] < this.offsetMark) {
                        this.nullIterator = ScalarLongColumn.this.nullValueIndex.peekableIterator();
                    }
                    this.offsetMark = offsets[offsets.length - 1];
                    ScalarLongColumn.this.valueColumn.get(this.valueVector, offsets, this.offset.getCurrentVectorSize());
                }
                this.nullVector = VectorSelectorUtils.populateNullVector(this.nullVector, this.offset, this.nullIterator);
                this.id = this.offset.getId();
            }
        };
    }

    @Override
    public void close() {
        this.valueColumn.close();
    }
}

