/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.frame.field.FieldReader;
import org.apache.druid.frame.field.ReadableFieldPointer;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.ObjectColumnSelector;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;

public class ComplexFieldReader
implements FieldReader {
    private final ComplexMetricSerde serde;

    ComplexFieldReader(ComplexMetricSerde serde) {
        this.serde = (ComplexMetricSerde)Preconditions.checkNotNull((Object)serde, (Object)"serde");
    }

    public static ComplexFieldReader createFromType(ColumnType columnType) {
        if (columnType == null || columnType.getType() != ValueType.COMPLEX || columnType.getComplexTypeName() == null) {
            throw new ISE("Expected complex type with defined complexTypeName, but got [%s]", columnType);
        }
        ComplexMetricSerde serde = ComplexMetrics.getSerdeForType(columnType.getComplexTypeName());
        if (serde == null) {
            throw new ISE("No serde for complexTypeName[%s]", columnType.getComplexTypeName());
        }
        return new ComplexFieldReader(serde);
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(Memory memory, ReadableFieldPointer fieldPointer) {
        return new Selector(memory, fieldPointer, this.serde);
    }

    @Override
    public DimensionSelector makeDimensionSelector(Memory memory, ReadableFieldPointer fieldPointer, @Nullable ExtractionFn extractionFn) {
        return DimensionSelector.constant(null, extractionFn);
    }

    @Override
    public boolean isNull(Memory memory, long position) {
        return memory.getByte(position) == 0;
    }

    @Nullable
    public static Object readFieldFromByteArray(ComplexMetricSerde serde, byte[] bytes, int position) {
        byte nullByte = bytes[position];
        if (nullByte == 0) {
            return null;
        }
        if (nullByte == 1) {
            int length = (bytes[position + 4] & 0xFF) << 24;
            length |= (bytes[position + 3] & 0xFF) << 16;
            length |= (bytes[position + 2] & 0xFF) << 8;
            return serde.fromBytes(bytes, position + 5, length |= bytes[position + 1] & 0xFF);
        }
        throw new ISE("Unexpected null byte [%s]", nullByte);
    }

    @Nullable
    public static Object readFieldFromMemory(ComplexMetricSerde serde, Memory memory, long position) {
        byte nullByte = memory.getByte(position);
        if (nullByte == 0) {
            return null;
        }
        if (nullByte == 1) {
            int length = memory.getInt(position + 1L);
            byte[] bytes = new byte[length];
            memory.getByteArray(position + 5L, bytes, 0, length);
            return serde.fromBytes(bytes, 0, length);
        }
        throw new ISE("Unexpected null byte [%s]", nullByte);
    }

    private static class Selector<T>
    extends ObjectColumnSelector<T> {
        private final Memory memory;
        private final ReadableFieldPointer fieldPointer;
        private final ComplexMetricSerde serde;

        private Selector(Memory memory, ReadableFieldPointer fieldPointer, ComplexMetricSerde serde) {
            this.memory = memory;
            this.fieldPointer = fieldPointer;
            this.serde = serde;
        }

        @Override
        @Nullable
        public T getObject() {
            return (T)ComplexFieldReader.readFieldFromMemory(this.serde, this.memory, this.fieldPointer.position());
        }

        @Override
        public Class<T> classOfObject() {
            return this.serde.getExtractor().extractedClass();
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        }
    }
}

