/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.frame.field.FieldReader;
import org.apache.druid.frame.field.ReadableFieldPointer;
import org.apache.druid.frame.read.FrameReaderUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DimensionSelectorUtils;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.RangeIndexedInts;

public class StringFieldReader
implements FieldReader {
    private final boolean asArray;

    public StringFieldReader() {
        this(false);
    }

    protected StringFieldReader(boolean asArray) {
        this.asArray = asArray;
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(Memory memory, ReadableFieldPointer fieldPointer) {
        return new Selector(memory, fieldPointer, null, this.asArray);
    }

    @Override
    public DimensionSelector makeDimensionSelector(Memory memory, ReadableFieldPointer fieldPointer, @Nullable ExtractionFn extractionFn) {
        if (this.asArray) {
            throw new ISE("Cannot call makeDimensionSelector on field of type [%s]", ColumnType.STRING_ARRAY);
        }
        return new Selector(memory, fieldPointer, extractionFn, false);
    }

    @Override
    public boolean isNull(Memory memory, long position) {
        byte firstByte = memory.getByte(position);
        if (firstByte == 0) {
            return true;
        }
        if (!this.asArray) {
            return (NullHandling.replaceWithDefault() || firstByte == 2) && memory.getByte(position + 1L) == 0 && memory.getByte(position + 2L) == 1;
        }
        return false;
    }

    private static class Selector
    implements DimensionSelector {
        private final Memory memory;
        private final ReadableFieldPointer fieldPointer;
        @Nullable
        private final ExtractionFn extractionFn;
        private final boolean asArray;
        private long currentFieldPosition = -1L;
        private final RangeIndexedInts indexedInts = new RangeIndexedInts();
        private final List<ByteBuffer> currentUtf8Strings = new ArrayList<ByteBuffer>();
        private boolean currentUtf8StringsIsNull;

        private Selector(Memory memory, ReadableFieldPointer fieldPointer, @Nullable ExtractionFn extractionFn, boolean asArray) {
            this.memory = memory;
            this.fieldPointer = fieldPointer;
            this.extractionFn = extractionFn;
            this.asArray = asArray;
        }

        @Override
        @Nullable
        public Object getObject() {
            List<ByteBuffer> currentStrings = this.computeCurrentUtf8Strings();
            if (currentStrings == null) {
                return null;
            }
            int size = currentStrings.size();
            if (size == 0) {
                return this.asArray ? ObjectArrays.EMPTY_ARRAY : null;
            }
            if (size == 1) {
                Object object;
                if (this.asArray) {
                    Object[] objectArray = new Object[1];
                    object = objectArray;
                    objectArray[0] = this.lookupName(0);
                } else {
                    object = this.lookupName(0);
                }
                return object;
            }
            Object[] strings = new Object[size];
            for (int i = 0; i < size; ++i) {
                strings[i] = this.lookupName(i);
            }
            return this.asArray ? strings : Arrays.asList(strings);
        }

        @Override
        public IndexedInts getRow() {
            List<ByteBuffer> strings = this.computeCurrentUtf8Strings();
            int size = strings == null ? 0 : strings.size();
            this.indexedInts.setSize(size);
            return this.indexedInts;
        }

        @Override
        @Nullable
        public String lookupName(int id) {
            List<ByteBuffer> strings = this.computeCurrentUtf8Strings();
            if (strings == null) {
                return null;
            }
            ByteBuffer byteBuffer = strings.get(id);
            String s = byteBuffer != null ? StringUtils.fromUtf8(byteBuffer.duplicate()) : null;
            return this.extractionFn == null ? s : this.extractionFn.apply(s);
        }

        @Override
        public boolean supportsLookupNameUtf8() {
            return this.extractionFn == null;
        }

        @Override
        @Nullable
        public ByteBuffer lookupNameUtf8(int id) {
            if (this.extractionFn != null) {
                throw new ISE("Cannot use lookupNameUtf8 on this selector", new Object[0]);
            }
            List<ByteBuffer> strings = this.computeCurrentUtf8Strings();
            return strings == null ? null : strings.get(id);
        }

        @Override
        public int getValueCardinality() {
            return -1;
        }

        @Override
        public boolean nameLookupPossibleInAdvance() {
            return false;
        }

        @Override
        @Nullable
        public IdLookup idLookup() {
            return null;
        }

        @Override
        public ValueMatcher makeValueMatcher(@Nullable String value) {
            return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, value);
        }

        @Override
        public ValueMatcher makeValueMatcher(DruidPredicateFactory predicateFactory) {
            return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, predicateFactory);
        }

        @Override
        public Class<?> classOfObject() {
            return Object.class;
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        }

        @Nullable
        private List<ByteBuffer> computeCurrentUtf8Strings() {
            long fieldPosition = this.fieldPointer.position();
            if (fieldPosition != this.currentFieldPosition) {
                this.updateCurrentUtf8Strings(fieldPosition);
            }
            this.currentFieldPosition = fieldPosition;
            if (this.currentUtf8StringsIsNull) {
                return null;
            }
            return this.currentUtf8Strings;
        }

        private void updateCurrentUtf8Strings(long fieldPosition) {
            this.currentUtf8StringsIsNull = false;
            this.currentUtf8Strings.clear();
            long position = fieldPosition;
            long limit = this.memory.getCapacity();
            boolean rowTerminatorSeen = false;
            block6: while (position < limit && !rowTerminatorSeen) {
                byte kind = this.memory.getByte(position);
                ++position;
                block0 : switch (kind) {
                    case 0: {
                        if (position != fieldPosition + 1L) continue block6;
                        this.currentUtf8StringsIsNull = true;
                        break;
                    }
                    case 1: {
                        rowTerminatorSeen = true;
                        break;
                    }
                    case 2: {
                        this.currentUtf8Strings.add(null);
                        break;
                    }
                    case 3: {
                        long i = position;
                        while (true) {
                            if (i >= limit) {
                                throw new ISE("Value overrun", new Object[0]);
                            }
                            byte b = this.memory.getByte(i);
                            if (b == 0) {
                                int len = Ints.checkedCast((long)(i - position));
                                if (len == 0 && NullHandling.replaceWithDefault()) {
                                    this.currentUtf8Strings.add(null);
                                } else {
                                    ByteBuffer buf = FrameReaderUtils.readByteBuffer(this.memory, position, len);
                                    this.currentUtf8Strings.add(buf);
                                }
                                position += (long)len;
                                break block0;
                            }
                            ++i;
                        }
                    }
                    default: {
                        throw new ISE("Invalid value start byte [%s]", kind);
                    }
                }
            }
            if (!rowTerminatorSeen) {
                throw new ISE("Unexpected end of field", new Object[0]);
            }
        }
    }
}

