/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.key;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.key.KeyOrder;
import org.apache.druid.frame.key.RunLengthEntry;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;

public class RowKeyComparisonRunLengths {
    private final RunLengthEntry[] runLengthEntries;

    private RowKeyComparisonRunLengths(RunLengthEntry[] runLengthEntries) {
        this.runLengthEntries = runLengthEntries;
    }

    public static RowKeyComparisonRunLengths create(List<KeyColumn> keyColumns, RowSignature rowSignature) {
        ArrayList<RunLengthEntryBuilder> runLengthEntryBuilders = new ArrayList<RunLengthEntryBuilder>();
        for (KeyColumn keyColumn : keyColumns) {
            if (keyColumn.order() == KeyOrder.NONE) {
                throw DruidException.defensive("Cannot sort on column [%s] when the sorting order isn't provided", keyColumn.columnName());
            }
            ColumnType columnType = rowSignature.getColumnType(keyColumn.columnName()).orElseThrow(() -> DruidException.defensive("Need column types", new Object[0]));
            if (runLengthEntryBuilders.size() == 0) {
                boolean isByteComparable = RowKeyComparisonRunLengths.isByteComparable(columnType);
                runLengthEntryBuilders.add(new RunLengthEntryBuilder(isByteComparable, keyColumn.order()));
                continue;
            }
            boolean isCurrentColumnByteComparable = RowKeyComparisonRunLengths.isByteComparable(columnType);
            RunLengthEntryBuilder lastRunLengthEntryBuilder = (RunLengthEntryBuilder)runLengthEntryBuilders.get(runLengthEntryBuilders.size() - 1);
            if (lastRunLengthEntryBuilder.byteComparable && isCurrentColumnByteComparable && lastRunLengthEntryBuilder.order.equals((Object)keyColumn.order())) {
                lastRunLengthEntryBuilder.runLength++;
                continue;
            }
            runLengthEntryBuilders.add(new RunLengthEntryBuilder(isCurrentColumnByteComparable, keyColumn.order()));
        }
        RunLengthEntry[] runLengthEntries = new RunLengthEntry[runLengthEntryBuilders.size()];
        for (int i = 0; i < runLengthEntryBuilders.size(); ++i) {
            runLengthEntries[i] = ((RunLengthEntryBuilder)runLengthEntryBuilders.get(i)).build();
        }
        return new RowKeyComparisonRunLengths(runLengthEntries);
    }

    private static boolean isByteComparable(ColumnType columnType) {
        if (columnType.is(ValueType.COMPLEX)) {
            if (columnType.getComplexTypeName() == null) {
                throw DruidException.defensive("Cannot sort unknown complex types", new Object[0]);
            }
            return false;
        }
        if (columnType.isArray() && !columnType.isPrimitiveArray()) {
            throw DruidException.defensive("Nested arrays aren't supported in row based frames", new Object[0]);
        }
        return true;
    }

    public RunLengthEntry[] getRunLengthEntries() {
        return this.runLengthEntries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowKeyComparisonRunLengths that = (RowKeyComparisonRunLengths)o;
        return Arrays.equals(this.runLengthEntries, that.runLengthEntries);
    }

    public int hashCode() {
        return Arrays.hashCode(this.runLengthEntries);
    }

    public String toString() {
        return "RowKeyComparisonRunLengths{runLengthEntries=" + Arrays.toString(this.runLengthEntries) + '}';
    }

    private static class RunLengthEntryBuilder {
        private final boolean byteComparable;
        private final KeyOrder order;
        private int runLength;

        public RunLengthEntryBuilder(boolean byteComparable, KeyOrder order) {
            this.byteComparable = byteComparable;
            this.order = order;
            this.runLength = 1;
        }

        public RunLengthEntry build() {
            return new RunLengthEntry(this.byteComparable, this.order, this.runLength);
        }
    }
}

