/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write.columnar;

import java.util.List;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.allocation.AppendableMemory;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.allocation.MemoryRange;
import org.apache.druid.frame.write.FrameWriterUtils;
import org.apache.druid.frame.write.columnar.FrameColumnWriter;
import org.apache.druid.segment.ColumnValueSelector;

public abstract class NumericArrayFrameColumnWriter
implements FrameColumnWriter {
    private static final int INITIAL_ALLOCATION_SIZE = 120;
    public static final byte NULL_ELEMENT_MARKER = 0;
    public static final byte NON_NULL_ELEMENT_MARKER = 1;
    public static final long DATA_OFFSET = 1L;
    final ColumnValueSelector selector;
    final byte typeCode;
    private final AppendableMemory cumulativeRowLengths;
    private final AppendableMemory rowNullityData;
    private final AppendableMemory rowData;
    private int lastCumulativeRowLength = 0;
    private int lastRowLength = -1;

    public NumericArrayFrameColumnWriter(ColumnValueSelector selector, MemoryAllocator allocator, byte typeCode) {
        this.selector = selector;
        this.typeCode = typeCode;
        this.cumulativeRowLengths = AppendableMemory.create(allocator, 120);
        this.rowNullityData = AppendableMemory.create(allocator, 120);
        this.rowData = AppendableMemory.create(allocator, 120);
    }

    abstract int elementSizeBytes();

    abstract void putNull(WritableMemory var1, long var2);

    abstract void putArrayElement(WritableMemory var1, long var2, Number var4);

    @Override
    public boolean addSelection() {
        int rowLength;
        List<? extends Number> numericArray = FrameWriterUtils.getNumericArrayFromObject(this.selector.getObject());
        int n = rowLength = numericArray == null ? 0 : numericArray.size();
        if ((long)this.lastCumulativeRowLength + (long)rowLength > Integer.MAX_VALUE) {
            return false;
        }
        if (!this.cumulativeRowLengths.reserveAdditional(4)) {
            return false;
        }
        if (!this.rowNullityData.reserveAdditional(rowLength * 1)) {
            return false;
        }
        if (!this.rowData.reserveAdditional(rowLength * this.elementSizeBytes())) {
            return false;
        }
        MemoryRange<WritableMemory> rowLengthsCursor = this.cumulativeRowLengths.cursor();
        if (numericArray == null) {
            rowLengthsCursor.memory().putInt(rowLengthsCursor.start(), -(this.lastCumulativeRowLength + rowLength) - 1);
        } else {
            rowLengthsCursor.memory().putInt(rowLengthsCursor.start(), this.lastCumulativeRowLength + rowLength);
        }
        this.cumulativeRowLengths.advanceCursor(4);
        this.lastRowLength = rowLength;
        this.lastCumulativeRowLength += rowLength;
        MemoryRange<WritableMemory> rowNullityDataCursor = rowLength > 0 ? this.rowNullityData.cursor() : null;
        MemoryRange<WritableMemory> rowDataCursor = rowLength > 0 ? this.rowData.cursor() : null;
        for (int i = 0; i < rowLength; ++i) {
            Number element = numericArray.get(i);
            long memoryOffset = rowDataCursor.start() + (long)this.elementSizeBytes() * (long)i;
            if (element == null) {
                rowNullityDataCursor.memory().putByte(rowNullityDataCursor.start() + 1L * (long)i, (byte)0);
                this.putNull(rowDataCursor.memory(), memoryOffset);
                continue;
            }
            rowNullityDataCursor.memory().putByte(rowNullityDataCursor.start() + 1L * (long)i, (byte)1);
            this.putArrayElement(rowDataCursor.memory(), memoryOffset, element);
        }
        if (rowLength > 0) {
            this.rowNullityData.advanceCursor(1 * rowLength);
            this.rowData.advanceCursor(this.elementSizeBytes() * rowLength);
        }
        return true;
    }

    @Override
    public void undo() {
        if (this.lastRowLength == -1) {
            throw DruidException.defensive("Nothing written to undo()", new Object[0]);
        }
        this.cumulativeRowLengths.rewindCursor(4);
        this.rowNullityData.rewindCursor(this.lastRowLength * 1);
        this.rowData.rewindCursor(this.lastRowLength * this.elementSizeBytes());
        this.lastCumulativeRowLength -= this.lastRowLength;
        this.lastRowLength = -1;
    }

    @Override
    public long size() {
        return 1L + this.cumulativeRowLengths.size() + this.rowNullityData.size() + this.rowData.size();
    }

    @Override
    public long writeTo(WritableMemory memory, long startPosition) {
        long currentPosition = startPosition;
        memory.putByte(currentPosition, this.typeCode);
        ++currentPosition;
        currentPosition += this.cumulativeRowLengths.writeTo(memory, currentPosition);
        currentPosition += this.rowNullityData.writeTo(memory, currentPosition);
        currentPosition += this.rowData.writeTo(memory, currentPosition);
        return currentPosition - startPosition;
    }

    @Override
    public void close() {
        this.cumulativeRowLengths.close();
        this.rowNullityData.close();
        this.rowData.close();
    }
}

