/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.math.expr.CartesianList;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.ExpressionTypeFactory;
import org.apache.druid.math.expr.Function;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.LambdaExpr;
import org.apache.druid.math.expr.NamedFunction;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;

public interface ApplyFunction
extends NamedFunction {
    default public boolean canVectorize(Expr.InputBindingInspector inspector, Expr lambda, List<Expr> args) {
        return false;
    }

    default public <T> ExprVectorProcessor<T> asVectorProcessor(Expr.VectorInputBindingInspector inspector, Expr lambda, List<Expr> args) {
        throw new UOE("%s is not vectorized", this.name());
    }

    public ExprEval apply(LambdaExpr var1, List<Expr> var2, Expr.ObjectBinding var3);

    public Set<Expr> getArrayInputs(List<Expr> var1);

    default public boolean hasArrayOutput(LambdaExpr lambdaExpr) {
        return false;
    }

    public void validateArguments(LambdaExpr var1, List<Expr> var2);

    @Nullable
    public ExpressionType getOutputType(Expr.InputBindingInspector var1, LambdaExpr var2, List<Expr> var3);

    public static class LambdaInputBindingInspector
    implements Expr.InputBindingInspector {
        private final Object2IntMap<String> lambdaIdentifiers;
        private final Expr.InputBindingInspector inspector;
        private final List<Expr> args;

        public LambdaInputBindingInspector(Expr.InputBindingInspector inspector, LambdaExpr expr, List<Expr> args) {
            this.inspector = inspector;
            this.args = args;
            List<String> identifiers = expr.getIdentifiers();
            this.lambdaIdentifiers = new Object2IntOpenHashMap(args.size());
            for (int i = 0; i < args.size(); ++i) {
                this.lambdaIdentifiers.put((Object)identifiers.get(i), i);
            }
        }

        @Override
        @Nullable
        public ExpressionType getType(String name) {
            if (this.lambdaIdentifiers.containsKey((Object)name)) {
                return ExpressionType.elementType(this.args.get(this.lambdaIdentifiers.getInt((Object)name)).getOutputType(this.inspector));
            }
            return this.inspector.getType(name);
        }
    }

    public static class CartesianFoldLambdaBinding
    implements IndexableFoldLambdaBinding {
        private final Expr.ObjectBinding bindings;
        private final ExpressionType arrayElementType;
        private final ExpressionType accumulatorType;
        private final Object2IntMap<String> lambdaIdentifiers;
        private final List<List<Object>> lambdaInputs;
        private final String accumulatorIdentifier;
        private Object accumulatorValue;
        private int index = 0;

        CartesianFoldLambdaBinding(@Nullable ExpressionType arrayElementType, List<List<Object>> inputs, ExpressionType accumulatorType, Object accumulatorValue, LambdaExpr expr, Expr.ObjectBinding bindings) {
            this.arrayElementType = arrayElementType;
            this.accumulatorType = accumulatorType;
            this.lambdaInputs = inputs;
            List<String> ids = expr.getIdentifiers();
            this.lambdaIdentifiers = new Object2IntArrayMap(ids.size());
            for (int i = 0; i < ids.size() - 1; ++i) {
                this.lambdaIdentifiers.put((Object)ids.get(i), i);
            }
            this.accumulatorIdentifier = ids.get(ids.size() - 1);
            this.bindings = bindings != null ? bindings : InputBindings.nilBindings();
            this.accumulatorValue = accumulatorValue;
        }

        @Override
        @Nullable
        public Object get(String name) {
            if (this.lambdaIdentifiers.containsKey((Object)name)) {
                return this.lambdaInputs.get(this.index).get(this.lambdaIdentifiers.getInt((Object)name));
            }
            if (this.accumulatorIdentifier.equals(name)) {
                return this.accumulatorValue;
            }
            return this.bindings.get(name);
        }

        @Override
        public ExpressionType getAccumulatorType() {
            return this.accumulatorType;
        }

        @Override
        public int getLength() {
            return this.lambdaInputs.size();
        }

        @Override
        public CartesianFoldLambdaBinding accumulateWithIndex(int index, Object acc) {
            this.index = index;
            this.accumulatorValue = acc;
            return this;
        }

        @Override
        @Nullable
        public ExpressionType getType(String name) {
            if (this.lambdaIdentifiers.containsKey((Object)name)) {
                return this.arrayElementType;
            }
            if (this.accumulatorIdentifier.equals(name)) {
                return this.accumulatorType;
            }
            return this.bindings.getType(name);
        }
    }

    public static class FoldLambdaBinding
    implements IndexableFoldLambdaBinding {
        private final Expr.ObjectBinding bindings;
        private final ExpressionType arrayElementType;
        private final ExpressionType accumulatorType;
        private final String elementIdentifier;
        private final Object[] arrayValues;
        private final String accumulatorIdentifier;
        private Object accumulatorValue;
        private int index;

        FoldLambdaBinding(ExpressionType arrayElementType, Object[] arrayValues, ExpressionType accumulatorType, Object initialAccumulator, LambdaExpr expr, Expr.ObjectBinding bindings) {
            List<String> ids = expr.getIdentifiers();
            this.elementIdentifier = ids.get(0);
            this.arrayElementType = arrayElementType;
            this.accumulatorType = accumulatorType;
            this.accumulatorIdentifier = ids.get(1);
            this.arrayValues = arrayValues;
            this.accumulatorValue = initialAccumulator;
            this.bindings = bindings != null ? bindings : InputBindings.nilBindings();
        }

        @Override
        @Nullable
        public Object get(String name) {
            if (name.equals(this.elementIdentifier)) {
                return this.arrayValues[this.index];
            }
            if (name.equals(this.accumulatorIdentifier)) {
                return this.accumulatorValue;
            }
            return this.bindings.get(name);
        }

        @Override
        public ExpressionType getAccumulatorType() {
            return this.accumulatorType;
        }

        @Override
        public int getLength() {
            return this.arrayValues.length;
        }

        @Override
        public FoldLambdaBinding accumulateWithIndex(int index, Object acc) {
            this.index = index;
            this.accumulatorValue = acc;
            return this;
        }

        @Override
        @Nullable
        public ExpressionType getType(String name) {
            if (name.equals(this.elementIdentifier)) {
                return this.arrayElementType;
            }
            if (name.equals(this.accumulatorIdentifier)) {
                return this.accumulatorType;
            }
            return this.bindings.getType(name);
        }
    }

    public static interface IndexableFoldLambdaBinding
    extends Expr.ObjectBinding {
        public ExpressionType getAccumulatorType();

        public int getLength();

        public IndexableFoldLambdaBinding accumulateWithIndex(int var1, Object var2);
    }

    public static class CartesianMapLambdaBinding
    implements IndexableMapLambdaObjectBinding {
        private final Expr.ObjectBinding bindings;
        private final ExpressionType arrayElementType;
        private final Object2IntMap<String> lambdaIdentifiers;
        private final List<List<Object>> lambdaInputs;
        private final boolean scoped;
        private int index = 0;

        CartesianMapLambdaBinding(ExpressionType arrayElementType, List<List<Object>> inputs, LambdaExpr expr, Expr.ObjectBinding bindings) {
            this.lambdaInputs = inputs;
            this.arrayElementType = arrayElementType;
            List<String> ids = expr.getIdentifiers();
            this.scoped = ids.size() > 0;
            this.lambdaIdentifiers = new Object2IntArrayMap(ids.size());
            for (int i = 0; i < ids.size(); ++i) {
                this.lambdaIdentifiers.put((Object)ids.get(i), i);
            }
            this.bindings = bindings != null ? bindings : InputBindings.nilBindings();
        }

        @Override
        @Nullable
        public Object get(String name) {
            if (this.scoped && this.lambdaIdentifiers.containsKey((Object)name)) {
                return this.lambdaInputs.get(this.index).get(this.lambdaIdentifiers.getInt((Object)name));
            }
            return this.bindings.get(name);
        }

        @Override
        public int getLength() {
            return this.lambdaInputs.size();
        }

        @Override
        public CartesianMapLambdaBinding withIndex(int index) {
            this.index = index;
            return this;
        }

        @Override
        @Nullable
        public ExpressionType getType(String name) {
            if (this.scoped && this.lambdaIdentifiers.containsKey((Object)name)) {
                return this.arrayElementType;
            }
            return this.bindings.getType(name);
        }
    }

    public static class MapLambdaBinding
    implements IndexableMapLambdaObjectBinding {
        private final Expr.ObjectBinding bindings;
        private final ExpressionType arrayElementType;
        @Nullable
        private final String lambdaIdentifier;
        private final Object[] arrayValues;
        private int index = 0;
        private final boolean scoped;

        MapLambdaBinding(ExpressionType elementType, Object[] arrayValues, LambdaExpr expr, Expr.ObjectBinding bindings) {
            this.lambdaIdentifier = expr.getIdentifier();
            this.arrayElementType = elementType;
            this.arrayValues = arrayValues;
            this.bindings = bindings != null ? bindings : InputBindings.nilBindings();
            this.scoped = this.lambdaIdentifier != null;
        }

        @Override
        @Nullable
        public Object get(String name) {
            if (this.scoped && name.equals(this.lambdaIdentifier)) {
                return this.arrayValues[this.index];
            }
            return this.bindings.get(name);
        }

        @Override
        public int getLength() {
            return this.arrayValues.length;
        }

        @Override
        public MapLambdaBinding withIndex(int index) {
            this.index = index;
            return this;
        }

        @Override
        @Nullable
        public ExpressionType getType(String name) {
            if (this.scoped && name.equals(this.lambdaIdentifier)) {
                return this.arrayElementType;
            }
            return this.bindings.getType(name);
        }
    }

    public static interface IndexableMapLambdaObjectBinding
    extends Expr.ObjectBinding {
        public int getLength();

        public IndexableMapLambdaObjectBinding withIndex(int var1);
    }

    public static class SettableLambdaBinding
    implements Expr.ObjectBinding {
        private final Expr.ObjectBinding bindings;
        private final Map<String, Object> lambdaBindings;
        private final ExpressionType elementType;

        SettableLambdaBinding(ExpressionType elementType, LambdaExpr expr, Expr.ObjectBinding bindings) {
            this.elementType = elementType;
            this.lambdaBindings = new HashMap<String, Object>();
            for (String lambdaIdentifier : expr.getIdentifiers()) {
                this.lambdaBindings.put(lambdaIdentifier, null);
            }
            this.bindings = bindings != null ? bindings : InputBindings.nilBindings();
        }

        @Override
        @Nullable
        public Object get(String name) {
            if (this.lambdaBindings.containsKey(name)) {
                return this.lambdaBindings.get(name);
            }
            return this.bindings.get(name);
        }

        SettableLambdaBinding withBinding(String key, Object value) {
            this.lambdaBindings.put(key, value);
            return this;
        }

        @Override
        @Nullable
        public ExpressionType getType(String name) {
            if (this.lambdaBindings.containsKey(name)) {
                return this.elementType;
            }
            return this.bindings.getType(name);
        }
    }

    public static class AllMatchFunction
    extends MatchFunction {
        static final String NAME = "all";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public ExprEval match(Object[] values, LambdaExpr expr, SettableLambdaBinding bindings) {
            for (Object o : values) {
                if (expr.eval(bindings.withBinding(expr.getIdentifier(), o)).asBoolean()) continue;
                return ExprEval.ofLongBoolean(false);
            }
            return ExprEval.ofLongBoolean(true);
        }
    }

    public static class AnyMatchFunction
    extends MatchFunction {
        static final String NAME = "any";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public ExprEval match(Object[] values, LambdaExpr expr, SettableLambdaBinding bindings) {
            for (Object o : values) {
                if (!expr.eval(bindings.withBinding(expr.getIdentifier(), o)).asBoolean()) continue;
                return ExprEval.ofLongBoolean(true);
            }
            return ExprEval.ofLongBoolean(false);
        }
    }

    public static abstract class MatchFunction
    implements ApplyFunction {
        @Override
        public ExprEval apply(LambdaExpr lambdaExpr, List<Expr> argsExpr, Expr.ObjectBinding bindings) {
            Expr arrayExpr = argsExpr.get(0);
            ExprEval arrayEval = arrayExpr.eval(bindings);
            Object[] array = arrayEval.asArray();
            if (array == null) {
                return ExprEval.ofLongBoolean(false);
            }
            SettableLambdaBinding lambdaBinding = new SettableLambdaBinding(arrayEval.elementType(), lambdaExpr, bindings);
            return this.match(array, lambdaExpr, lambdaBinding);
        }

        @Override
        public Set<Expr> getArrayInputs(List<Expr> args) {
            return ImmutableSet.of((Object)args.get(0));
        }

        @Override
        public void validateArguments(LambdaExpr lambdaExpr, List<Expr> args) {
            this.validationHelperCheckArgumentCount(lambdaExpr, args, 1);
        }

        @Override
        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector, LambdaExpr expr, List<Expr> args) {
            return ExpressionType.LONG;
        }

        public abstract ExprEval match(Object[] var1, LambdaExpr var2, SettableLambdaBinding var3);
    }

    public static class FilterFunction
    implements ApplyFunction {
        static final String NAME = "filter";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public boolean hasArrayOutput(LambdaExpr lambdaExpr) {
            return true;
        }

        @Override
        public ExprEval apply(LambdaExpr lambdaExpr, List<Expr> argsExpr, Expr.ObjectBinding bindings) {
            Expr arrayExpr = argsExpr.get(0);
            ExprEval arrayEval = arrayExpr.eval(bindings);
            Object[] array = arrayEval.asArray();
            if (array == null) {
                return ExprEval.ofArray(arrayEval.asArrayType(), null);
            }
            SettableLambdaBinding lambdaBinding = new SettableLambdaBinding(arrayEval.elementType(), lambdaExpr, bindings);
            Object[] filtered = this.filter(arrayEval.asArray(), lambdaExpr, lambdaBinding).toArray();
            if (filtered.length == 0) {
                return ExprEval.ofArray(arrayEval.asArrayType(), null);
            }
            return ExprEval.ofArray(arrayEval.asArrayType(), filtered);
        }

        @Override
        public Set<Expr> getArrayInputs(List<Expr> args) {
            return ImmutableSet.of((Object)args.get(0));
        }

        @Override
        public void validateArguments(LambdaExpr lambdaExpr, List<Expr> args) {
            this.validationHelperCheckArgumentCount(lambdaExpr, args, 1);
        }

        @Override
        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector, LambdaExpr expr, List<Expr> args) {
            return args.get(0).getOutputType(inspector);
        }

        private <T> Stream<T> filter(T[] array, LambdaExpr expr, SettableLambdaBinding binding) {
            return Arrays.stream(array).filter(s -> expr.eval(binding.withBinding(expr.getIdentifier(), s)).asBoolean());
        }
    }

    public static class CartesianFoldFunction
    extends BaseFoldFunction {
        static final String NAME = "cartesian_fold";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public ExprEval apply(LambdaExpr lambdaExpr, List<Expr> argsExpr, Expr.ObjectBinding bindings) {
            ArrayList<List<Object>> arrayInputs = new ArrayList<List<Object>>();
            boolean hadNull = false;
            boolean hadEmpty = false;
            ExpressionType arrayElementType = null;
            for (int i = 0; i < argsExpr.size() - 1; ++i) {
                Expr expr = argsExpr.get(i);
                ExprEval arrayEval = expr.eval(bindings);
                Object[] array = arrayEval.asArray();
                if (array == null) {
                    hadNull = true;
                    continue;
                }
                arrayElementType = arrayEval.elementType();
                if (array.length == 0) {
                    hadEmpty = true;
                    continue;
                }
                arrayInputs.add(Arrays.asList(array));
            }
            if (hadNull) {
                return ExprEval.of(null);
            }
            if (hadEmpty) {
                return ExprEval.ofStringArray(new Object[0]);
            }
            Expr accExpr = argsExpr.get(argsExpr.size() - 1);
            List<List<Object>> product = CartesianList.create(arrayInputs);
            ExprEval accEval = accExpr.eval(bindings);
            Object accumulator = accEval.value();
            CartesianFoldLambdaBinding lambdaBindings = new CartesianFoldLambdaBinding(arrayElementType, product, accEval.type(), accumulator, lambdaExpr, bindings);
            return this.applyFold(lambdaExpr, accumulator, lambdaBindings);
        }

        @Override
        public Set<Expr> getArrayInputs(List<Expr> args) {
            return ImmutableSet.copyOf(args.subList(0, args.size() - 1));
        }

        @Override
        public void validateArguments(LambdaExpr lambdaExpr, List<Expr> args) {
            this.validationHelperCheckMinArgumentCount(lambdaExpr, args, 1);
        }
    }

    public static class FoldFunction
    extends BaseFoldFunction {
        static final String NAME = "fold";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public ExprEval apply(LambdaExpr lambdaExpr, List<Expr> argsExpr, Expr.ObjectBinding bindings) {
            Expr arrayExpr = argsExpr.get(0);
            Expr accExpr = argsExpr.get(1);
            ExprEval arrayEval = arrayExpr.eval(bindings);
            ExprEval accEval = accExpr.eval(bindings);
            Object[] array = arrayEval.asArray();
            if (array == null) {
                return ExprEval.of(null);
            }
            Object accumulator = accEval.value();
            FoldLambdaBinding lambdaBinding = new FoldLambdaBinding(arrayEval.elementType(), array, accEval.type(), accumulator, lambdaExpr, bindings);
            return this.applyFold(lambdaExpr, accumulator, lambdaBinding);
        }

        @Override
        public Set<Expr> getArrayInputs(List<Expr> args) {
            return ImmutableSet.of((Object)args.get(0));
        }

        @Override
        public void validateArguments(LambdaExpr lambdaExpr, List<Expr> args) {
            this.validationHelperCheckArgumentCount(lambdaExpr, args, 2);
        }
    }

    public static abstract class BaseFoldFunction
    implements ApplyFunction {
        ExprEval applyFold(LambdaExpr lambdaExpr, Object accumulator, IndexableFoldLambdaBinding bindings) {
            for (int i = 0; i < bindings.getLength(); ++i) {
                ExprEval evaluated = lambdaExpr.eval(bindings.accumulateWithIndex(i, accumulator));
                accumulator = evaluated.value();
            }
            if (accumulator instanceof Boolean) {
                return ExprEval.ofLongBoolean((Boolean)accumulator);
            }
            return ExprEval.ofType(bindings.getAccumulatorType(), accumulator);
        }

        @Override
        public boolean hasArrayOutput(LambdaExpr lambdaExpr) {
            Expr.BindingAnalysis lambdaBindingAnalysis = lambdaExpr.analyzeInputs();
            return lambdaBindingAnalysis.isOutputArray();
        }

        @Override
        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector, LambdaExpr expr, List<Expr> args) {
            return args.get(args.size() - 1).getOutputType(inspector);
        }
    }

    public static class CartesianMapFunction
    extends BaseMapFunction {
        static final String NAME = "cartesian_map";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public ExprEval apply(LambdaExpr lambdaExpr, List<Expr> argsExpr, Expr.ObjectBinding bindings) {
            ArrayList<List<Object>> arrayInputs = new ArrayList<List<Object>>();
            boolean hadNull = false;
            boolean hadEmpty = false;
            ExpressionType elementType = null;
            for (Expr expr : argsExpr) {
                ExprEval arrayEval = expr.eval(bindings);
                Object[] array = arrayEval.asArray();
                if (array == null) {
                    hadNull = true;
                    continue;
                }
                elementType = arrayEval.elementType();
                if (array.length == 0) {
                    hadEmpty = true;
                    continue;
                }
                arrayInputs.add(Arrays.asList(array));
            }
            if (hadNull) {
                return ExprEval.of(null);
            }
            if (hadEmpty) {
                return ExprEval.ofStringArray(new String[0]);
            }
            List<List<Object>> product = CartesianList.create(arrayInputs);
            CartesianMapLambdaBinding lambdaBinding = new CartesianMapLambdaBinding(elementType, product, lambdaExpr, bindings);
            ExpressionType lambdaType = lambdaExpr.getOutputType(lambdaBinding);
            return this.applyMap(ExpressionType.asArrayType(lambdaType), lambdaExpr, lambdaBinding);
        }

        @Override
        public Set<Expr> getArrayInputs(List<Expr> args) {
            return ImmutableSet.copyOf(args);
        }

        @Override
        public void validateArguments(LambdaExpr lambdaExpr, List<Expr> args) {
            this.validationHelperCheckMinArgumentCount(lambdaExpr, args, 1);
        }
    }

    public static class MapFunction
    extends BaseMapFunction {
        static final String NAME = "map";

        @Override
        public String name() {
            return NAME;
        }

        @Override
        public ExprEval apply(LambdaExpr lambdaExpr, List<Expr> argsExpr, Expr.ObjectBinding bindings) {
            Expr arrayExpr = argsExpr.get(0);
            ExprEval arrayEval = arrayExpr.eval(bindings);
            Object[] array = arrayEval.asArray();
            if (array == null) {
                return ExprEval.of(null);
            }
            if (array.length == 0) {
                return arrayEval;
            }
            MapLambdaBinding lambdaBinding = new MapLambdaBinding(arrayEval.elementType(), array, lambdaExpr, bindings);
            ExpressionType lambdaType = lambdaExpr.getOutputType(lambdaBinding);
            return this.applyMap(lambdaType == null ? null : ExpressionTypeFactory.getInstance().ofArray(lambdaType), lambdaExpr, lambdaBinding);
        }

        @Override
        public Set<Expr> getArrayInputs(List<Expr> args) {
            if (args.size() == 1) {
                return ImmutableSet.of((Object)args.get(0));
            }
            return Collections.emptySet();
        }

        @Override
        public void validateArguments(LambdaExpr lambdaExpr, List<Expr> args) {
            this.validationHelperCheckArgumentCount(lambdaExpr, args, 1);
        }
    }

    public static abstract class BaseMapFunction
    implements ApplyFunction {
        @Override
        public boolean hasArrayOutput(LambdaExpr lambdaExpr) {
            return true;
        }

        @Override
        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector, LambdaExpr expr, List<Expr> args) {
            return ExpressionType.asArrayType(expr.getOutputType(new LambdaInputBindingInspector(inspector, expr, args)));
        }

        ExprEval applyMap(@Nullable ExpressionType arrayType, LambdaExpr expr, IndexableMapLambdaObjectBinding bindings) {
            int length = bindings.getLength();
            Object[] out = new Object[length];
            for (int i = 0; i < length; ++i) {
                ExprEval evaluated = expr.eval(bindings.withIndex(i));
                arrayType = Function.ArrayConstructorFunction.setArrayOutput(arrayType, out, i, evaluated);
            }
            return ExprEval.ofArray(arrayType, out);
        }
    }
}

