/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.aggregation.AbstractSerializablePairLongObjectColumnHeader;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.SerializablePairLongStringColumnHeader;
import org.apache.druid.query.aggregation.SerializablePairLongStringDeltaEncodedStagedSerde;
import org.apache.druid.segment.column.ComplexColumn;
import org.apache.druid.segment.serde.cell.ByteBufferProvider;
import org.apache.druid.segment.serde.cell.CellReader;

public class SerializablePairLongStringComplexColumn
implements ComplexColumn {
    private final Closer closer;
    private final int serializedSize;
    private final CellReader cellReader;
    private final SerializablePairLongStringDeltaEncodedStagedSerde serde;

    public SerializablePairLongStringComplexColumn(CellReader cellReader, SerializablePairLongStringDeltaEncodedStagedSerde serde, Closer closer, int serializedSize) {
        this.cellReader = cellReader;
        this.serde = serde;
        this.closer = closer;
        this.serializedSize = serializedSize;
    }

    @Override
    public Class<?> getClazz() {
        return SerializablePairLongString.class;
    }

    @Override
    public String getTypeName() {
        return "serializablePairLongString";
    }

    @Override
    public Object getRowValue(int rowNum) {
        return this.serde.deserialize(this.cellReader.getCell(rowNum));
    }

    @Override
    public int getLength() {
        return this.serializedSize;
    }

    @Override
    public void close() {
        try {
            this.closer.close();
        }
        catch (IOException e) {
            throw new RE(e, "error closing " + this.getClass().getName(), new Object[0]);
        }
    }

    public static class Builder {
        private final int serializedSize;
        private final SerializablePairLongStringDeltaEncodedStagedSerde serde;
        private final CellReader.Builder cellReaderBuilder;

        public Builder(ByteBuffer buffer) {
            ByteBuffer masterByteBuffer = buffer.asReadOnlyBuffer().order(ByteOrder.nativeOrder());
            this.serializedSize = masterByteBuffer.remaining();
            SerializablePairLongStringColumnHeader columnHeader = (SerializablePairLongStringColumnHeader)AbstractSerializablePairLongObjectColumnHeader.fromBuffer(masterByteBuffer, SerializablePairLongString.class);
            Preconditions.checkArgument((columnHeader.getVersion() == 3 ? 1 : 0) != 0, (String)"version %s expected, got %s", (int)3, (int)columnHeader.getVersion());
            this.serde = columnHeader.createSerde();
            this.cellReaderBuilder = new CellReader.Builder(masterByteBuffer);
        }

        public Builder setByteBufferProvider(ByteBufferProvider byteBufferProvider) {
            this.cellReaderBuilder.setByteBufferProvider(byteBufferProvider);
            return this;
        }

        public SerializablePairLongStringComplexColumn build() {
            Closer closer = Closer.create();
            CellReader cellReader = this.cellReaderBuilder.build();
            closer.register(cellReader);
            return new SerializablePairLongStringComplexColumn(cellReader, this.serde, closer, this.serializedSize);
        }
    }
}

