/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.filter.AbstractOptimizableDimFilter;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.DruidPredicateMatch;
import org.apache.druid.query.filter.FallbackPredicate;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherColumnProcessorFactory;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnProcessorFactory;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.NullableTypeStrategy;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.filter.PredicateValueMatcherFactory;
import org.apache.druid.segment.filter.ValueMatchers;
import org.apache.druid.segment.index.AllUnknownBitmapColumnIndex;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.index.semantic.DruidPredicateIndexes;
import org.apache.druid.segment.index.semantic.StringValueSetIndexes;
import org.apache.druid.segment.index.semantic.ValueIndexes;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class EqualityFilter
extends AbstractOptimizableDimFilter
implements Filter {
    private final String column;
    private final ColumnType matchValueType;
    private final Object matchValue;
    private final ExprEval<?> matchValueEval;
    @Nullable
    private final FilterTuning filterTuning;
    private final DruidPredicateFactory predicateFactory;

    @JsonCreator
    public EqualityFilter(@JsonProperty(value="column") String column, @JsonProperty(value="matchValueType") ColumnType matchValueType, @JsonProperty(value="matchValue") Object matchValue, @JsonProperty(value="filterTuning") @Nullable FilterTuning filterTuning) {
        if (column == null) {
            throw InvalidInput.exception("Invalid equality filter, column cannot be null", new Object[0]);
        }
        this.column = column;
        if (matchValueType == null) {
            throw InvalidInput.exception("Invalid equality filter on column [%s], matchValueType cannot be null", column);
        }
        this.matchValueType = matchValueType;
        this.matchValue = matchValue;
        this.matchValueEval = ExprEval.ofType(ExpressionType.fromColumnTypeStrict(matchValueType), matchValue);
        if (this.matchValueEval.value() == null) {
            throw InvalidInput.exception("Invalid equality filter on column [%s], matchValue cannot be null", column);
        }
        this.filterTuning = filterTuning;
        this.predicateFactory = new EqualityPredicateFactory(this.matchValueEval);
    }

    @Override
    public byte[] getCacheKey() {
        TypeStrategy<?> typeStrategy = this.matchValueEval.type().getStrategy();
        int size = typeStrategy.estimateSizeBytes(this.matchValueEval.value());
        ByteBuffer valueBuffer = ByteBuffer.allocate(size);
        typeStrategy.write(valueBuffer, this.matchValueEval.value(), size);
        return new CacheKeyBuilder(19).appendByte((byte)-1).appendString(this.column).appendByte((byte)-1).appendString(this.matchValueType.asTypeString()).appendByte((byte)-1).appendByteArray(valueBuffer.array()).build();
    }

    @Override
    public Filter toFilter() {
        return this;
    }

    @JsonProperty
    public String getColumn() {
        return this.column;
    }

    @JsonProperty
    public ColumnType getMatchValueType() {
        return this.matchValueType;
    }

    @JsonProperty
    public Object getMatchValue() {
        return this.matchValue;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public FilterTuning getFilterTuning() {
        return this.filterTuning;
    }

    public String toString() {
        DimFilter.DimFilterToStringBuilder bob = new DimFilter.DimFilterToStringBuilder().appendDimension(this.column, null).append(" = ").append(this.matchValueEval.isArray() ? Arrays.deepToString(this.matchValueEval.asArray()) : this.matchValueEval.value());
        if (!ColumnType.STRING.equals(this.matchValueType)) {
            bob.append(" (" + this.matchValueType.asTypeString() + ")");
        }
        return bob.appendFilterTuning(this.filterTuning).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EqualityFilter that = (EqualityFilter)o;
        if (!this.column.equals(that.column)) {
            return false;
        }
        if (!Objects.equals(this.matchValueType, that.matchValueType)) {
            return false;
        }
        if (!Objects.equals(this.filterTuning, that.filterTuning)) {
            return false;
        }
        if (this.matchValueType.isArray()) {
            return Arrays.deepEquals(this.matchValueEval.asArray(), that.matchValueEval.asArray());
        }
        return Objects.equals(this.matchValueEval.value(), that.matchValueEval.value());
    }

    public int hashCode() {
        return Objects.hash(this.column, this.matchValueType, this.matchValueEval.value(), this.filterTuning);
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        if (!Objects.equals(this.getColumn(), dimension)) {
            return null;
        }
        TreeRangeSet retSet = TreeRangeSet.create();
        if (this.matchValueEval.isArray()) {
            retSet.add(Range.singleton((Comparable)((Object)Arrays.deepToString(this.matchValueEval.asArray()))));
        } else {
            retSet.add(Range.singleton((Comparable)((Object)this.matchValueEval.asString())));
        }
        return retSet;
    }

    @Override
    @Nullable
    public BitmapColumnIndex getBitmapColumnIndex(ColumnIndexSelector selector) {
        if (!Filters.checkFilterTuningUseIndex(this.column, selector, this.filterTuning)) {
            return null;
        }
        return EqualityFilter.getEqualityIndex(this.column, this.matchValueEval, this.matchValueType, selector, this.predicateFactory);
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return ColumnProcessors.makeProcessor(this.column, new TypedConstantValueMatcherFactory(this.matchValueEval, this.predicateFactory), factory);
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        ColumnCapabilities capabilities = factory.getColumnCapabilities(this.column);
        if (this.matchValueType.isPrimitive() && (capabilities == null || capabilities.isPrimitive())) {
            return ColumnProcessors.makeVectorProcessor(this.column, VectorValueMatcherColumnProcessorFactory.instance(), factory).makeMatcher(this.matchValueEval.value(), this.matchValueType);
        }
        return ColumnProcessors.makeVectorProcessor(this.column, VectorValueMatcherColumnProcessorFactory.instance(), factory).makeMatcher(new EqualityPredicateFactory(this.matchValueEval));
    }

    @Override
    public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return true;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ImmutableSet.of((Object)this.column);
    }

    @Override
    public boolean supportsRequiredColumnRewrite() {
        return true;
    }

    @Override
    public Filter rewriteRequiredColumns(Map<String, String> columnRewrites) {
        String rewriteDimensionTo = columnRewrites.get(this.column);
        if (rewriteDimensionTo == null) {
            throw new IAE("Received a non-applicable rewrite: %s, filter's dimension: %s", columnRewrites, columnRewrites);
        }
        return new EqualityFilter(rewriteDimensionTo, this.matchValueType, this.matchValue, this.filterTuning);
    }

    public static BitmapColumnIndex getEqualityIndex(String column, ExprEval<?> matchValueEval, ColumnType matchValueType, ColumnIndexSelector selector, DruidPredicateFactory predicateFactory) {
        StringValueSetIndexes stringValueSetIndexes;
        ColumnIndexSupplier indexSupplier = selector.getIndexSupplier(column);
        if (indexSupplier == null) {
            return new AllUnknownBitmapColumnIndex(selector);
        }
        ValueIndexes valueIndexes = indexSupplier.as(ValueIndexes.class);
        if (valueIndexes != null) {
            return valueIndexes.forValue(matchValueEval.value(), matchValueType);
        }
        if (matchValueType.isPrimitive() && (stringValueSetIndexes = indexSupplier.as(StringValueSetIndexes.class)) != null) {
            return stringValueSetIndexes.forValue(matchValueEval.asString());
        }
        DruidPredicateIndexes predicateIndexes = indexSupplier.as(DruidPredicateIndexes.class);
        if (predicateIndexes != null) {
            return predicateIndexes.forPredicate(predicateFactory);
        }
        return null;
    }

    public static class TypedConstantValueMatcherFactory
    implements ColumnProcessorFactory<ValueMatcher> {
        protected final ExprEval<?> matchValue;
        protected final PredicateValueMatcherFactory predicateMatcherFactory;

        public TypedConstantValueMatcherFactory(ExprEval<?> matchValue, DruidPredicateFactory predicateFactory) {
            this.matchValue = matchValue;
            this.predicateMatcherFactory = new PredicateValueMatcherFactory(predicateFactory);
        }

        @Override
        public ColumnType defaultType() {
            return ColumnType.UNKNOWN_COMPLEX;
        }

        @Override
        public ValueMatcher makeDimensionProcessor(DimensionSelector selector, boolean multiValue) {
            ExprEval<?> castForComparison = ExprEval.castForEqualityComparison(this.matchValue, ExpressionType.STRING);
            if (castForComparison == null) {
                return ValueMatchers.makeAlwaysFalseWithNullUnknownDimensionMatcher(selector, multiValue);
            }
            return ValueMatchers.makeStringValueMatcher(selector, castForComparison.asString(), multiValue);
        }

        @Override
        public ValueMatcher makeFloatProcessor(BaseFloatColumnValueSelector selector) {
            ExprEval<?> castForComparison = ExprEval.castForEqualityComparison(this.matchValue, ExpressionType.DOUBLE);
            if (castForComparison == null) {
                return ValueMatchers.makeAlwaysFalseWithNullUnknownNumericMatcher(selector);
            }
            return ValueMatchers.makeFloatValueMatcher(selector, (float)castForComparison.asDouble());
        }

        @Override
        public ValueMatcher makeDoubleProcessor(BaseDoubleColumnValueSelector selector) {
            ExprEval<?> castForComparison = ExprEval.castForEqualityComparison(this.matchValue, ExpressionType.DOUBLE);
            if (castForComparison == null) {
                return ValueMatchers.makeAlwaysFalseWithNullUnknownNumericMatcher(selector);
            }
            return ValueMatchers.makeDoubleValueMatcher(selector, castForComparison.asDouble());
        }

        @Override
        public ValueMatcher makeLongProcessor(BaseLongColumnValueSelector selector) {
            ExprEval<?> castForComparison = ExprEval.castForEqualityComparison(this.matchValue, ExpressionType.LONG);
            if (castForComparison == null) {
                return ValueMatchers.makeAlwaysFalseWithNullUnknownNumericMatcher(selector);
            }
            return ValueMatchers.makeLongValueMatcher(selector, castForComparison.asLong());
        }

        @Override
        public ValueMatcher makeArrayProcessor(BaseObjectColumnValueSelector<?> selector, @Nullable ColumnCapabilities columnCapabilities) {
            return this.predicateMatcherFactory.makeArrayProcessor((BaseObjectColumnValueSelector)selector, columnCapabilities);
        }

        @Override
        public ValueMatcher makeComplexProcessor(BaseObjectColumnValueSelector<?> selector) {
            return this.predicateMatcherFactory.makeComplexProcessor((BaseObjectColumnValueSelector)selector);
        }
    }

    public static class EqualityPredicateFactory
    implements DruidPredicateFactory {
        private final ExprEval<?> matchValue;
        private final Supplier<DruidObjectPredicate<String>> stringPredicateSupplier;
        private final Supplier<DruidLongPredicate> longPredicateSupplier;
        private final Supplier<DruidFloatPredicate> floatPredicateSupplier;
        private final Supplier<DruidDoublePredicate> doublePredicateSupplier;
        private final ConcurrentHashMap<TypeSignature<ValueType>, DruidObjectPredicate<Object[]>> arrayPredicates;
        private final Supplier<DruidObjectPredicate<Object[]>> typeDetectingArrayPredicateSupplier;
        private final Supplier<DruidObjectPredicate<Object>> objectPredicateSupplier;

        public EqualityPredicateFactory(ExprEval<?> matchValue) {
            this.matchValue = matchValue;
            this.stringPredicateSupplier = this.makeStringPredicateSupplier();
            this.longPredicateSupplier = this.makeLongPredicateSupplier();
            this.floatPredicateSupplier = this.makeFloatPredicateSupplier();
            this.doublePredicateSupplier = this.makeDoublePredicateSupplier();
            this.objectPredicateSupplier = this.makeObjectPredicateSupplier();
            this.arrayPredicates = new ConcurrentHashMap();
            this.typeDetectingArrayPredicateSupplier = this.makeTypeDetectingArrayPredicate();
        }

        @Override
        public DruidObjectPredicate<String> makeStringPredicate() {
            return (DruidObjectPredicate)this.stringPredicateSupplier.get();
        }

        @Override
        public DruidLongPredicate makeLongPredicate() {
            return (DruidLongPredicate)this.longPredicateSupplier.get();
        }

        @Override
        public DruidFloatPredicate makeFloatPredicate() {
            return (DruidFloatPredicate)this.floatPredicateSupplier.get();
        }

        @Override
        public DruidDoublePredicate makeDoublePredicate() {
            return (DruidDoublePredicate)this.doublePredicateSupplier.get();
        }

        @Override
        public DruidObjectPredicate<Object[]> makeArrayPredicate(@Nullable TypeSignature<ValueType> arrayType) {
            if (!this.matchValue.isArray()) {
                return DruidObjectPredicate.alwaysFalseWithNullUnknown();
            }
            if (arrayType == null) {
                return (DruidObjectPredicate)this.typeDetectingArrayPredicateSupplier.get();
            }
            return new FallbackPredicate<Object[]>(this.arrayPredicates.computeIfAbsent(arrayType, existing -> this.makeArrayPredicateInternal(arrayType)), ExpressionType.fromColumnTypeStrict(arrayType));
        }

        @Override
        public DruidObjectPredicate<Object> makeObjectPredicate() {
            return (DruidObjectPredicate)this.objectPredicateSupplier.get();
        }

        private Supplier<DruidObjectPredicate<String>> makeStringPredicateSupplier() {
            return Suppliers.memoize(() -> {
                ExprEval<?> castForComparison = ExprEval.castForEqualityComparison(this.matchValue, ExpressionType.STRING);
                if (castForComparison == null) {
                    return DruidObjectPredicate.alwaysFalseWithNullUnknown();
                }
                return DruidObjectPredicate.equalTo(castForComparison.asString());
            });
        }

        private Supplier<DruidLongPredicate> makeLongPredicateSupplier() {
            return Suppliers.memoize(() -> {
                ExprEval<?> castForComparison = ExprEval.castForEqualityComparison(this.matchValue, ExpressionType.LONG);
                if (castForComparison == null) {
                    return DruidLongPredicate.ALWAYS_FALSE_WITH_NULL_UNKNOWN;
                }
                long unboxedLong = castForComparison.asLong();
                return input -> DruidPredicateMatch.of(input == unboxedLong);
            });
        }

        private Supplier<DruidFloatPredicate> makeFloatPredicateSupplier() {
            return Suppliers.memoize(() -> {
                ExprEval<?> castForComparison = ExprEval.castForEqualityComparison(this.matchValue, ExpressionType.DOUBLE);
                if (castForComparison == null) {
                    return DruidFloatPredicate.ALWAYS_FALSE_WITH_NULL_UNKNOWN;
                }
                int floatBits = Float.floatToIntBits((float)castForComparison.asDouble());
                return input -> DruidPredicateMatch.of(Float.floatToIntBits(input) == floatBits);
            });
        }

        private Supplier<DruidDoublePredicate> makeDoublePredicateSupplier() {
            return Suppliers.memoize(() -> {
                ExprEval<?> castForComparison = ExprEval.castForEqualityComparison(this.matchValue, ExpressionType.DOUBLE);
                if (castForComparison == null) {
                    return DruidDoublePredicate.ALWAYS_FALSE_WITH_NULL_UNKNOWN;
                }
                long bits = Double.doubleToLongBits(castForComparison.asDouble());
                return input -> DruidPredicateMatch.of(Double.doubleToLongBits(input) == bits);
            });
        }

        private Supplier<DruidObjectPredicate<Object>> makeObjectPredicateSupplier() {
            return Suppliers.memoize(() -> {
                if (this.matchValue.type().equals(ExpressionType.NESTED_DATA)) {
                    return input -> input == null ? DruidPredicateMatch.UNKNOWN : DruidPredicateMatch.of(Objects.equals(StructuredData.unwrap(input), StructuredData.unwrap(this.matchValue.value())));
                }
                return DruidObjectPredicate.equalTo(this.matchValue.valueOrDefault());
            });
        }

        private Supplier<DruidObjectPredicate<Object[]>> makeTypeDetectingArrayPredicate() {
            return Suppliers.memoize(() -> input -> {
                if (input == null) {
                    return DruidPredicateMatch.UNKNOWN;
                }
                ExprEval eval = ExprEval.bestEffortOf(input);
                NullableTypeStrategy<Object[]> arrayComparator = eval.type().getNullableStrategy();
                ExprEval<?> castForComparison = ExprEval.castForEqualityComparison(this.matchValue, eval.type());
                if (castForComparison == null) {
                    return DruidPredicateMatch.UNKNOWN;
                }
                Object[] matchArray = castForComparison.asArray();
                return DruidPredicateMatch.of(arrayComparator.compare((Object[])input, matchArray) == 0);
            });
        }

        private DruidObjectPredicate<Object[]> makeArrayPredicateInternal(TypeSignature<ValueType> arrayType) {
            ExpressionType expressionType = ExpressionType.fromColumnTypeStrict(arrayType);
            NullableTypeStrategy arrayComparator = arrayType.getNullableStrategy();
            ExprEval<?> castForComparison = ExprEval.castForEqualityComparison(this.matchValue, expressionType);
            if (castForComparison == null) {
                return DruidObjectPredicate.alwaysFalseWithNullUnknown();
            }
            Object[] matchArray = castForComparison.asArray();
            return input -> input == null ? DruidPredicateMatch.UNKNOWN : DruidPredicateMatch.of(arrayComparator.compare(input, matchArray) == 0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EqualityPredicateFactory that = (EqualityPredicateFactory)o;
            if (!Objects.equals(this.matchValue.type(), that.matchValue.type())) {
                return false;
            }
            if (this.matchValue.isArray()) {
                return Arrays.deepEquals(this.matchValue.asArray(), that.matchValue.asArray());
            }
            return Objects.equals(this.matchValue.value(), that.matchValue.value());
        }

        public int hashCode() {
            return Objects.hash(this.matchValue);
        }
    }
}

