/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnIndexCapabilities;
import org.apache.druid.segment.column.SimpleColumnIndexCapabilities;
import org.apache.druid.segment.data.Offset;
import org.apache.druid.segment.filter.FalseFilter;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class FilterBundle {
    @Nullable
    private final IndexBundle indexBundle;
    @Nullable
    private final MatcherBundle matcherBundle;

    public static FilterBundle allFalse(long constructionTime, ImmutableBitmap emptyBitmap) {
        return new FilterBundle(new SimpleIndexBundle(new IndexBundleInfo(() -> FalseFilter.instance().toString(), 0, constructionTime, null), emptyBitmap, SimpleColumnIndexCapabilities.getConstant()), null);
    }

    public FilterBundle(@Nullable IndexBundle index, @Nullable MatcherBundle matcherBundle) {
        Preconditions.checkArgument((index != null || matcherBundle != null ? 1 : 0) != 0, (Object)"At least one of index or matcher must be not null");
        this.indexBundle = index;
        this.matcherBundle = matcherBundle;
    }

    @Nullable
    public IndexBundle getIndex() {
        return this.indexBundle;
    }

    @Nullable
    public MatcherBundle getMatcherBundle() {
        return this.matcherBundle;
    }

    public BundleInfo getInfo() {
        return new BundleInfo(this.indexBundle == null ? null : this.indexBundle.getIndexInfo(), this.matcherBundle == null ? null : this.matcherBundle.getMatcherInfo());
    }

    public boolean hasIndex() {
        return this.indexBundle != null;
    }

    public boolean hasMatcher() {
        return this.matcherBundle != null;
    }

    public static class MatcherBundleInfo {
        private static final Pattern PATTERN_LINE_START = Pattern.compile("(?m)^");
        private final Supplier<String> filter;
        @Nullable
        final List<MatcherBundleInfo> matchers;
        @Nullable
        private final IndexBundleInfo partialIndex;

        public MatcherBundleInfo(Supplier<String> filter, @Nullable IndexBundleInfo partialIndex, @Nullable List<MatcherBundleInfo> matchers) {
            this.filter = filter;
            this.matchers = matchers;
            this.partialIndex = partialIndex;
        }

        @JsonProperty
        public String getFilter() {
            return this.filter.get();
        }

        @Nullable
        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public IndexBundleInfo getPartialIndex() {
            return this.partialIndex;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public List<MatcherBundleInfo> getMatchers() {
            return this.matchers;
        }

        public String describe() {
            StringBuilder sb = new StringBuilder().append("matcher: ").append(this.filter.get()).append("\n");
            if (this.partialIndex != null) {
                sb.append("  with partial ").append(PATTERN_LINE_START.matcher(this.partialIndex.describe()).replaceAll("  ").substring(2));
            }
            if (this.matchers != null) {
                for (MatcherBundleInfo info : this.matchers) {
                    sb.append(PATTERN_LINE_START.matcher(info.describe()).replaceAll("  "));
                }
            }
            return sb.toString();
        }

        public String toString() {
            return "{filter=\"" + this.filter.get() + '\"' + (this.partialIndex != null ? ", partialIndex=" + this.partialIndex : "") + (this.matchers != null ? ", matchers=" + this.matchers : "") + '}';
        }
    }

    public static class IndexBundleInfo {
        private static final Pattern PATTERN_LINE_START = Pattern.compile("(?m)^");
        private final Supplier<String> filter;
        private final List<IndexBundleInfo> indexes;
        private final int selectionSize;
        private final long buildTimeNs;

        public IndexBundleInfo(Supplier<String> filterString, int selectionSize, long buildTimeNs, @Nullable List<IndexBundleInfo> indexes) {
            this.filter = filterString;
            this.selectionSize = selectionSize;
            this.buildTimeNs = buildTimeNs;
            this.indexes = indexes;
        }

        @JsonProperty
        public String getFilter() {
            return this.filter.get();
        }

        @JsonProperty
        public int getSelectionSize() {
            return this.selectionSize;
        }

        @JsonProperty
        public long getBuildTimeNs() {
            return this.buildTimeNs;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public List<IndexBundleInfo> getIndexes() {
            return this.indexes;
        }

        public String describe() {
            StringBuilder sb = new StringBuilder().append("index: ").append(this.filter.get()).append(" (selectionSize = ").append(this.selectionSize).append(")\n");
            if (this.indexes != null) {
                for (IndexBundleInfo info : this.indexes) {
                    sb.append(PATTERN_LINE_START.matcher(info.describe()).replaceAll("  "));
                }
            }
            return sb.toString();
        }

        public String toString() {
            return "{filter=\"" + this.filter.get() + '\"' + ", selectionSize=" + this.selectionSize + ", buildTime=" + TimeUnit.NANOSECONDS.toMicros(this.buildTimeNs) + "\u03bcs" + (this.indexes != null ? ", indexes=" + this.indexes : "") + '}';
        }
    }

    public static class BundleInfo {
        private final IndexBundleInfo index;
        private final MatcherBundleInfo matcher;

        @JsonCreator
        public BundleInfo(@JsonProperty(value="index") @Nullable IndexBundleInfo index, @JsonProperty(value="matcher") @Nullable MatcherBundleInfo matcher) {
            this.index = index;
            this.matcher = matcher;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public IndexBundleInfo getIndex() {
            return this.index;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public MatcherBundleInfo getMatcher() {
            return this.matcher;
        }

        public String describe() {
            StringBuilder sb = new StringBuilder();
            if (this.index != null) {
                sb.append(this.index.describe());
            }
            if (this.matcher != null) {
                sb.append(this.matcher.describe());
            }
            return sb.toString();
        }

        public String toString() {
            return "{index=" + this.index + ", matcher=" + this.matcher + '}';
        }
    }

    public static class SimpleMatcherBundle
    implements MatcherBundle {
        private final MatcherBundleInfo matcherInfo;
        private final Function<ColumnSelectorFactory, ValueMatcher> matcherFn;
        private final Function<VectorColumnSelectorFactory, VectorValueMatcher> vectorMatcherFn;

        public SimpleMatcherBundle(MatcherBundleInfo matcherInfo, Function<ColumnSelectorFactory, ValueMatcher> matcherFn, Function<VectorColumnSelectorFactory, VectorValueMatcher> vectorMatcherFn) {
            this.matcherInfo = (MatcherBundleInfo)Preconditions.checkNotNull((Object)matcherInfo);
            this.matcherFn = (Function)Preconditions.checkNotNull(matcherFn);
            this.vectorMatcherFn = (Function)Preconditions.checkNotNull(vectorMatcherFn);
        }

        @Override
        public MatcherBundleInfo getMatcherInfo() {
            return this.matcherInfo;
        }

        @Override
        public ValueMatcher valueMatcher(ColumnSelectorFactory selectorFactory, Offset baseOffset, boolean descending) {
            return this.matcherFn.apply(selectorFactory);
        }

        @Override
        public VectorValueMatcher vectorMatcher(VectorColumnSelectorFactory selectorFactory, ReadableVectorOffset baseOffset) {
            return this.vectorMatcherFn.apply(selectorFactory);
        }
    }

    public static class SimpleIndexBundle
    implements IndexBundle {
        private final IndexBundleInfo info;
        private final ImmutableBitmap index;
        private final ColumnIndexCapabilities indexCapabilities;

        public SimpleIndexBundle(IndexBundleInfo info, ImmutableBitmap index, ColumnIndexCapabilities indexCapabilities) {
            this.info = (IndexBundleInfo)Preconditions.checkNotNull((Object)info);
            this.index = (ImmutableBitmap)Preconditions.checkNotNull((Object)index);
            this.indexCapabilities = (ColumnIndexCapabilities)Preconditions.checkNotNull((Object)indexCapabilities);
        }

        @Override
        public IndexBundleInfo getIndexInfo() {
            return this.info;
        }

        @Override
        public ImmutableBitmap getBitmap() {
            return this.index;
        }

        @Override
        public ColumnIndexCapabilities getIndexCapabilities() {
            return this.indexCapabilities;
        }
    }

    public static interface MatcherBundle {
        public MatcherBundleInfo getMatcherInfo();

        public ValueMatcher valueMatcher(ColumnSelectorFactory var1, Offset var2, boolean var3);

        public VectorValueMatcher vectorMatcher(VectorColumnSelectorFactory var1, ReadableVectorOffset var2);
    }

    public static interface IndexBundle {
        public IndexBundleInfo getIndexInfo();

        public ImmutableBitmap getBitmap();

        public ColumnIndexCapabilities getIndexCapabilities();
    }
}

