/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import com.google.common.base.Supplier;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.query.aggregation.AggregatorAdapters;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.groupby.epinephelinae.AbstractBufferHashGrouper;
import org.apache.druid.query.groupby.epinephelinae.ByteBufferHashTable;
import org.apache.druid.query.groupby.epinephelinae.ByteBufferIntList;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.Groupers;
import org.apache.druid.query.groupby.epinephelinae.ReusableEntry;

public class BufferHashGrouper<KeyType>
extends AbstractBufferHashGrouper<KeyType> {
    private static final int MIN_INITIAL_BUCKETS = 4;
    private static final int DEFAULT_INITIAL_BUCKETS = 1024;
    private static final float DEFAULT_MAX_LOAD_FACTOR = 0.7f;
    private boolean initialized = false;
    private final boolean useDefaultSorting;
    @Nullable
    private ByteBufferIntList offsetList;

    public BufferHashGrouper(Supplier<ByteBuffer> bufferSupplier, Grouper.KeySerde<KeyType> keySerde, AggregatorAdapters aggregators, int bufferGrouperMaxSize, float maxLoadFactor, int initialBuckets, boolean useDefaultSorting) {
        super(bufferSupplier, keySerde, aggregators, 4 + keySerde.keySize(), bufferGrouperMaxSize);
        this.maxLoadFactor = maxLoadFactor > 0.0f ? maxLoadFactor : 0.7f;
        int n = this.initialBuckets = initialBuckets > 0 ? Math.max(4, initialBuckets) : 1024;
        if (this.maxLoadFactor >= 1.0f) {
            throw new IAE("Invalid maxLoadFactor[%f], must be < 1.0", Float.valueOf(maxLoadFactor));
        }
        this.bucketSize = 4 + keySerde.keySize() + aggregators.spaceNeeded();
        this.useDefaultSorting = useDefaultSorting;
    }

    @Override
    public void init() {
        if (!this.initialized) {
            ByteBuffer buffer = (ByteBuffer)this.bufferSupplier.get();
            int hashTableSize = ByteBufferHashTable.calculateTableArenaSizeWithPerBucketAdditionalSize(buffer.capacity(), this.bucketSize, 4);
            this.hashTableBuffer = buffer.duplicate();
            this.hashTableBuffer.position(0);
            this.hashTableBuffer.limit(hashTableSize);
            this.hashTableBuffer = this.hashTableBuffer.slice();
            ByteBuffer offsetListBuffer = buffer.duplicate();
            offsetListBuffer.position(hashTableSize);
            offsetListBuffer.limit(buffer.capacity());
            offsetListBuffer = offsetListBuffer.slice();
            this.offsetList = new ByteBufferIntList(offsetListBuffer, offsetListBuffer.capacity() / 4);
            this.hashTable = new ByteBufferHashTable(this.maxLoadFactor, this.initialBuckets, this.bucketSize, this.hashTableBuffer, this.keySize, this.bufferGrouperMaxSize, new BufferGrouperBucketUpdateHandler());
            this.reset();
            this.initialized = true;
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public ToIntFunction<KeyType> hashFunction() {
        return Groupers::hashObject;
    }

    @Override
    public void newBucketHook(int bucketOffset) {
    }

    @Override
    public boolean canSkipAggregate(int bucketOffset) {
        return false;
    }

    @Override
    public void afterAggregateHook(int bucketOffset) {
    }

    @Override
    public void reset() {
        this.offsetList.reset();
        this.hashTable.reset();
        this.keySerde.reset();
        this.aggregators.reset();
    }

    @Override
    public CloseableIterator<Grouper.Entry<KeyType>> iterator(boolean sorted) {
        if (!this.initialized) {
            return CloseableIterators.withEmptyBaggage(Collections.emptyIterator());
        }
        if (sorted) {
            final AbstractList<Integer> wrappedOffsets = new AbstractList<Integer>(){

                @Override
                public Integer get(int index) {
                    return BufferHashGrouper.this.offsetList.get(index);
                }

                @Override
                public Integer set(int index, Integer element) {
                    Integer oldValue = this.get(index);
                    BufferHashGrouper.this.offsetList.set(index, element);
                    return oldValue;
                }

                @Override
                public int size() {
                    return BufferHashGrouper.this.hashTable.getSize();
                }
            };
            Grouper.BufferComparator comparator = this.useDefaultSorting ? this.keySerde.bufferComparator() : this.keySerde.bufferComparatorWithAggregators(this.aggregators.factories().toArray(new AggregatorFactory[0]), this.aggregators.aggregatorPositions());
            Collections.sort(wrappedOffsets, (lhs, rhs) -> {
                ByteBuffer tableBuffer = this.hashTable.getTableBuffer();
                return comparator.compare(tableBuffer, tableBuffer, lhs + 4, rhs + 4);
            });
            return new CloseableIterator<Grouper.Entry<KeyType>>(){
                final ReusableEntry<KeyType> reusableEntry;
                int curr;
                final int size;
                {
                    this.reusableEntry = ReusableEntry.create(BufferHashGrouper.this.keySerde, BufferHashGrouper.this.aggregators.size());
                    this.curr = 0;
                    this.size = BufferHashGrouper.this.getSize();
                }

                @Override
                public boolean hasNext() {
                    return this.curr < this.size;
                }

                @Override
                public Grouper.Entry<KeyType> next() {
                    if (this.curr >= this.size) {
                        throw new NoSuchElementException();
                    }
                    return BufferHashGrouper.this.populateBucketEntryForOffset(this.reusableEntry, (Integer)wrappedOffsets.get(this.curr++));
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void close() {
                }
            };
        }
        return new CloseableIterator<Grouper.Entry<KeyType>>(){
            final ReusableEntry<KeyType> reusableEntry;
            int curr;
            final int size;
            {
                this.reusableEntry = ReusableEntry.create(BufferHashGrouper.this.keySerde, BufferHashGrouper.this.aggregators.size());
                this.curr = 0;
                this.size = BufferHashGrouper.this.getSize();
            }

            @Override
            public boolean hasNext() {
                return this.curr < this.size;
            }

            @Override
            public Grouper.Entry<KeyType> next() {
                if (this.curr >= this.size) {
                    throw new NoSuchElementException();
                }
                int offset = BufferHashGrouper.this.offsetList.get(this.curr);
                Grouper.Entry entry = BufferHashGrouper.this.populateBucketEntryForOffset(this.reusableEntry, offset);
                ++this.curr;
                return entry;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
            }
        };
    }

    private class BufferGrouperBucketUpdateHandler
    implements ByteBufferHashTable.BucketUpdateHandler {
        private BufferGrouperBucketUpdateHandler() {
        }

        @Override
        public void handleNewBucket(int bucketOffset) {
            BufferHashGrouper.this.offsetList.add(bucketOffset);
        }

        @Override
        public void handlePreTableSwap() {
            BufferHashGrouper.this.offsetList.reset();
        }

        @Override
        public void handleBucketMove(int oldBucketOffset, int newBucketOffset, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
            BufferHashGrouper.this.aggregators.relocate(oldBucketOffset + BufferHashGrouper.this.baseAggregatorOffset, newBucketOffset + BufferHashGrouper.this.baseAggregatorOffset, oldBuffer, newBuffer);
            BufferHashGrouper.this.offsetList.add(newBucketOffset);
        }
    }
}

