/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.ColumnSelectorPlus;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.aggregation.AggregatorAdapters;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryMetrics;
import org.apache.druid.query.groupby.GroupingEngine;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.AbstractBufferHashGrouper;
import org.apache.druid.query.groupby.epinephelinae.BufferArrayGrouper;
import org.apache.druid.query.groupby.epinephelinae.BufferHashGrouper;
import org.apache.druid.query.groupby.epinephelinae.CloseableGrouperIterator;
import org.apache.druid.query.groupby.epinephelinae.GroupByColumnSelectorStrategyFactory;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.GrouperBufferComparatorUtils;
import org.apache.druid.query.groupby.epinephelinae.IntGrouper;
import org.apache.druid.query.groupby.epinephelinae.IntKey;
import org.apache.druid.query.groupby.epinephelinae.LimitedBufferHashGrouper;
import org.apache.druid.query.groupby.epinephelinae.UnexpectedMultiValueDimensionException;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorPlus;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorStrategy;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.IndexedInts;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class GroupByQueryEngine {
    private static final GroupByColumnSelectorStrategyFactory STRATEGY_FACTORY = new GroupByColumnSelectorStrategyFactory();

    private GroupByQueryEngine() {
    }

    public static Sequence<ResultRow> process(GroupByQuery query, StorageAdapter storageAdapter, ByteBuffer processingBuffer, @Nullable DateTime fudgeTimestamp, GroupByQueryConfig querySpecificConfig, DruidProcessingConfig processingConfig, @Nullable Filter filter, Interval interval, @Nullable GroupByQueryMetrics groupByQueryMetrics) {
        Sequence<Cursor> cursors = storageAdapter.makeCursors(filter, interval, query.getVirtualColumns(), query.getGranularity(), false, groupByQueryMetrics);
        return cursors.flatMap(cursor -> new BaseSequence(new BaseSequence.IteratorMaker<ResultRow, GroupByEngineIterator<?>>((Cursor)cursor, query, querySpecificConfig, storageAdapter, processingBuffer, processingConfig, fudgeTimestamp){
            final /* synthetic */ Cursor val$cursor;
            final /* synthetic */ GroupByQuery val$query;
            final /* synthetic */ GroupByQueryConfig val$querySpecificConfig;
            final /* synthetic */ StorageAdapter val$storageAdapter;
            final /* synthetic */ ByteBuffer val$processingBuffer;
            final /* synthetic */ DruidProcessingConfig val$processingConfig;
            final /* synthetic */ DateTime val$fudgeTimestamp;
            {
                this.val$cursor = cursor;
                this.val$query = groupByQuery;
                this.val$querySpecificConfig = groupByQueryConfig;
                this.val$storageAdapter = storageAdapter;
                this.val$processingBuffer = byteBuffer;
                this.val$processingConfig = druidProcessingConfig;
                this.val$fudgeTimestamp = dateTime;
            }

            @Override
            public GroupByEngineIterator<?> make() {
                ColumnSelectorFactory columnSelectorFactory = this.val$cursor.getColumnSelectorFactory();
                ColumnSelectorPlus<GroupByColumnSelectorStrategy>[] selectorPlus = DimensionHandlerUtils.createColumnSelectorPluses(STRATEGY_FACTORY, this.val$query.getDimensions(), columnSelectorFactory);
                GroupByColumnSelectorPlus[] dims = new GroupByColumnSelectorPlus[selectorPlus.length];
                int curPos = 0;
                for (int i = 0; i < dims.length; ++i) {
                    dims[i] = new GroupByColumnSelectorPlus(selectorPlus[i], curPos, this.val$query.getResultRowDimensionStart() + i);
                    curPos += ((GroupByColumnSelectorStrategy)dims[i].getColumnSelectorStrategy()).getGroupingKeySizeBytes();
                }
                int cardinalityForArrayAggregation = GroupingEngine.getCardinalityForArrayAggregation(this.val$querySpecificConfig, this.val$query, this.val$storageAdapter, this.val$processingBuffer);
                if (cardinalityForArrayAggregation >= 0) {
                    return new ArrayAggregateIterator(this.val$query, this.val$querySpecificConfig, this.val$processingConfig, this.val$cursor, this.val$processingBuffer, this.val$fudgeTimestamp, dims, GroupByQueryEngine.hasNoImplicitUnnestDimensions(columnSelectorFactory, this.val$query.getDimensions()), cardinalityForArrayAggregation);
                }
                return new HashAggregateIterator(this.val$query, this.val$querySpecificConfig, this.val$processingConfig, this.val$cursor, this.val$processingBuffer, this.val$fudgeTimestamp, dims, GroupByQueryEngine.hasNoImplicitUnnestDimensions(columnSelectorFactory, this.val$query.getDimensions()));
            }

            @Override
            public void cleanup(GroupByEngineIterator<?> iterFromMake) {
                iterFromMake.close();
            }
        }));
    }

    @VisibleForTesting
    public static boolean canPushDownLimit(ColumnSelectorFactory columnSelectorFactory, String columnName) {
        ColumnCapabilities capabilities = columnSelectorFactory.getColumnCapabilities(columnName);
        if (capabilities != null) {
            if (capabilities.is(ValueType.STRING)) {
                return capabilities.areDictionaryValuesSorted().and(capabilities.areDictionaryValuesUnique()).isTrue();
            }
            return true;
        }
        return false;
    }

    private static boolean hasNoImplicitUnnestDimensions(ColumnInspector inspector, List<DimensionSpec> dimensions) {
        return dimensions.stream().allMatch(dimension -> {
            if (dimension.mustDecorate()) {
                return false;
            }
            ColumnCapabilities columnCapabilities = inspector.getColumnCapabilities(dimension.getDimension());
            return dimension.getOutputType().isArray() || columnCapabilities != null && columnCapabilities.hasMultipleValues().isFalse() && !columnCapabilities.isArray();
        });
    }

    private static class GroupByEngineKeySerde
    implements Grouper.KeySerde<ByteBuffer> {
        private final int keySize;
        private final GroupByColumnSelectorPlus[] dims;
        private final GroupByQuery query;

        private GroupByEngineKeySerde(GroupByColumnSelectorPlus[] dims, GroupByQuery query) {
            this.dims = dims;
            int keySize = 0;
            for (GroupByColumnSelectorPlus selectorPlus : dims) {
                keySize += ((GroupByColumnSelectorStrategy)selectorPlus.getColumnSelectorStrategy()).getGroupingKeySizeBytes();
            }
            this.keySize = keySize;
            this.query = query;
        }

        @Override
        public int keySize() {
            return this.keySize;
        }

        @Override
        public Class<ByteBuffer> keyClazz() {
            return ByteBuffer.class;
        }

        @Override
        public List<String> getDictionary() {
            return ImmutableList.of();
        }

        @Override
        public ByteBuffer createKey() {
            return ByteBuffer.allocate(this.keySize);
        }

        @Override
        public ByteBuffer toByteBuffer(ByteBuffer key) {
            return key;
        }

        @Override
        public void readFromByteBuffer(ByteBuffer dstBuffer, ByteBuffer srcBuffer, int position) {
            dstBuffer.limit(this.keySize);
            dstBuffer.position(0);
            for (int i = 0; i < this.keySize; ++i) {
                dstBuffer.put(i, srcBuffer.get(position + i));
            }
        }

        @Override
        public Grouper.BufferComparator bufferComparator() {
            Preconditions.checkState((boolean)this.query.isApplyLimitPushDown(), (Object)"no limit push down");
            DefaultLimitSpec limitSpec = (DefaultLimitSpec)this.query.getLimitSpec();
            return GrouperBufferComparatorUtils.bufferComparator(this.query.getResultRowHasTimestamp(), this.query.getContextSortByDimsFirst(), this.query.getDimensions().size(), this.getDimensionComparators(limitSpec));
        }

        @Override
        public Grouper.BufferComparator bufferComparatorWithAggregators(AggregatorFactory[] aggregatorFactories, int[] aggregatorOffsets) {
            Preconditions.checkState((boolean)this.query.isApplyLimitPushDown(), (Object)"no limit push down");
            DefaultLimitSpec limitSpec = (DefaultLimitSpec)this.query.getLimitSpec();
            return GrouperBufferComparatorUtils.bufferComparatorWithAggregators(this.query.getAggregatorSpecs().toArray(new AggregatorFactory[0]), aggregatorOffsets, limitSpec, this.query.getDimensions(), this.getDimensionComparators(limitSpec), this.query.getResultRowHasTimestamp(), this.query.getContextSortByDimsFirst(), this.keySize);
        }

        private Grouper.BufferComparator[] getDimensionComparators(DefaultLimitSpec limitSpec) {
            Grouper.BufferComparator[] dimComparators = new Grouper.BufferComparator[this.dims.length];
            for (int i = 0; i < this.dims.length; ++i) {
                String dimName = this.query.getDimensions().get(i).getOutputName();
                StringComparator stringComparator = DefaultLimitSpec.getComparatorForDimName(limitSpec, dimName);
                dimComparators[i] = ((GroupByColumnSelectorStrategy)this.dims[i].getColumnSelectorStrategy()).bufferComparator(this.dims[i].getKeyBufferPosition(), stringComparator);
            }
            return dimComparators;
        }

        @Override
        public void reset() {
        }
    }

    private static class ArrayAggregateIterator
    extends GroupByEngineIterator<IntKey> {
        private final int cardinality;
        @Nullable
        private final GroupByColumnSelectorPlus dim;
        @Nullable
        private IndexedInts multiValues;
        private int nextValIndex;

        private ArrayAggregateIterator(GroupByQuery query, GroupByQueryConfig querySpecificConfig, DruidProcessingConfig processingConfig, Cursor cursor, ByteBuffer buffer, @Nullable DateTime fudgeTimestamp, GroupByColumnSelectorPlus[] dims, boolean allSingleValueDims, int cardinality) {
            super(query, querySpecificConfig, processingConfig, cursor, buffer, fudgeTimestamp, dims, allSingleValueDims);
            this.cardinality = cardinality;
            if (dims.length == 1) {
                this.dim = dims[0];
            } else if (dims.length == 0) {
                this.dim = null;
            } else {
                throw new IAE("Group key should be a single dimension", new Object[0]);
            }
        }

        protected IntGrouper newGrouper() {
            return new BufferArrayGrouper((Supplier<ByteBuffer>)Suppliers.ofInstance((Object)this.buffer), AggregatorAdapters.factorizeBuffered(this.cursor.getColumnSelectorFactory(), this.query.getAggregatorSpecs()), this.cardinality);
        }

        @Override
        protected void aggregateSingleValueDims(Grouper<IntKey> grouper) {
            this.aggregateSingleValueDims((IntGrouper)grouper);
        }

        @Override
        protected void aggregateMultiValueDims(Grouper<IntKey> grouper) {
            this.aggregateMultiValueDims((IntGrouper)grouper);
        }

        private void aggregateSingleValueDims(IntGrouper grouper) {
            while (!this.cursor.isDone()) {
                int key;
                if (this.dim != null) {
                    IndexedInts indexedInts = ((DimensionSelector)this.dim.getSelector()).getRow();
                    key = this.getSingleValue(indexedInts);
                } else {
                    key = 0;
                }
                if (!grouper.aggregate(key).isOk()) {
                    return;
                }
                this.cursor.advance();
            }
        }

        private void aggregateMultiValueDims(IntGrouper grouper) {
            if (this.dim == null) {
                throw new ISE("dim must exist", new Object[0]);
            }
            if (this.multiValues == null) {
                this.multiValues = ((DimensionSelector)this.dim.getSelector()).getRow();
                this.nextValIndex = 0;
            }
            while (!this.cursor.isDone()) {
                int multiValuesSize = this.multiValues.size();
                if (multiValuesSize == 0) {
                    if (!grouper.aggregate(-1).isOk()) {
                        return;
                    }
                } else {
                    if (multiValuesSize > 1) {
                        this.checkIfMultiValueGroupingIsAllowed(this.dim.getName());
                    }
                    while (this.nextValIndex < multiValuesSize) {
                        if (!grouper.aggregate(this.multiValues.get(this.nextValIndex)).isOk()) {
                            return;
                        }
                        ++this.nextValIndex;
                    }
                }
                this.cursor.advance();
                if (this.cursor.isDone()) continue;
                this.multiValues = ((DimensionSelector)this.dim.getSelector()).getRow();
                this.nextValIndex = this.multiValues.size() == 0 ? -1 : 0;
            }
        }

        @Override
        protected void putToRow(IntKey key, ResultRow resultRow) {
            int intKey = key.intValue();
            if (this.dim != null) {
                if (intKey != -1) {
                    resultRow.set(this.dim.getResultRowPosition(), ((DimensionSelector)this.dim.getSelector()).lookupName(intKey));
                } else {
                    resultRow.set(this.dim.getResultRowPosition(), NullHandling.defaultStringValue());
                }
            }
        }
    }

    private static class HashAggregateIterator
    extends GroupByEngineIterator<ByteBuffer> {
        private static final Logger LOGGER = new Logger(HashAggregateIterator.class);
        private final int[] stack;
        private final Object[] valuess;
        protected final ByteBuffer keyBuffer;
        private int stackPointer = Integer.MIN_VALUE;
        private boolean currentRowWasPartiallyAggregated = false;
        private long selectorInternalFootprint = 0L;

        private HashAggregateIterator(GroupByQuery query, GroupByQueryConfig querySpecificConfig, DruidProcessingConfig processingConfig, Cursor cursor, ByteBuffer buffer, @Nullable DateTime fudgeTimestamp, GroupByColumnSelectorPlus[] dims, boolean allSingleValueDims) {
            super(query, querySpecificConfig, processingConfig, cursor, buffer, fudgeTimestamp, dims, allSingleValueDims);
            int dimCount = query.getDimensions().size();
            this.stack = new int[dimCount];
            this.valuess = new Object[dimCount];
            this.keyBuffer = ByteBuffer.allocate(this.keySerde.keySize());
        }

        @Override
        protected Grouper<ByteBuffer> newGrouper() {
            AbstractBufferHashGrouper grouper = null;
            ColumnSelectorFactory selectorFactory = this.cursor.getColumnSelectorFactory();
            DefaultLimitSpec limitSpec = this.query.isApplyLimitPushDown() && this.querySpecificConfig.isApplyLimitPushDownToSegment() ? (DefaultLimitSpec)this.query.getLimitSpec() : null;
            boolean canDoLimitPushdown = limitSpec != null ? Stream.concat(this.query.getDimensions().stream().map(DimensionSpec::getDimension), limitSpec.getColumns().stream().map(OrderByColumnSpec::getDimension)).allMatch(col -> GroupByQueryEngine.canPushDownLimit(selectorFactory, col)) : false;
            if (canDoLimitPushdown) {
                Preconditions.checkState((!limitSpec.isOffset() ? 1 : 0) != 0, (Object)"Cannot push down offsets");
                LimitedBufferHashGrouper limitGrouper = new LimitedBufferHashGrouper((Supplier<ByteBuffer>)Suppliers.ofInstance((Object)this.buffer), this.keySerde, AggregatorAdapters.factorizeBuffered(selectorFactory, this.query.getAggregatorSpecs()), this.querySpecificConfig.getBufferGrouperMaxSize(), this.querySpecificConfig.getBufferGrouperMaxLoadFactor(), this.querySpecificConfig.getBufferGrouperInitialBuckets(), limitSpec.getLimit(), DefaultLimitSpec.sortingOrderHasNonGroupingFields(limitSpec, this.query.getDimensions()));
                if (limitGrouper.validateBufferCapacity(this.buffer.capacity())) {
                    grouper = limitGrouper;
                } else {
                    LOGGER.warn("Limit is not applied in segment scan phase due to limited buffer capacity for query [%s].", this.query.getId());
                }
            }
            if (grouper == null) {
                grouper = new BufferHashGrouper((Supplier<ByteBuffer>)Suppliers.ofInstance((Object)this.buffer), this.keySerde, AggregatorAdapters.factorizeBuffered(selectorFactory, this.query.getAggregatorSpecs()), this.querySpecificConfig.getBufferGrouperMaxSize(), this.querySpecificConfig.getBufferGrouperMaxLoadFactor(), this.querySpecificConfig.getBufferGrouperInitialBuckets(), true);
            }
            return grouper;
        }

        @Override
        protected void aggregateSingleValueDims(Grouper<ByteBuffer> grouper) {
            if (!this.currentRowWasPartiallyAggregated) {
                for (GroupByColumnSelectorPlus dim : this.dims) {
                    ((GroupByColumnSelectorStrategy)dim.getColumnSelectorStrategy()).reset();
                }
                this.selectorInternalFootprint = 0L;
            }
            while (!this.cursor.isDone()) {
                for (GroupByColumnSelectorPlus dim : this.dims) {
                    GroupByColumnSelectorStrategy strategy = (GroupByColumnSelectorStrategy)dim.getColumnSelectorStrategy();
                    this.selectorInternalFootprint += (long)strategy.writeToKeyBuffer(dim.getKeyBufferPosition(), dim.getSelector(), this.keyBuffer);
                }
                this.keyBuffer.rewind();
                if (!grouper.aggregate(this.keyBuffer).isOk()) {
                    return;
                }
                this.cursor.advance();
                if (this.selectorInternalFootprint <= this.maxSelectorFootprint) continue;
                return;
            }
        }

        @Override
        protected void aggregateMultiValueDims(Grouper<ByteBuffer> grouper) {
            if (!this.currentRowWasPartiallyAggregated) {
                for (GroupByColumnSelectorPlus dim : this.dims) {
                    ((GroupByColumnSelectorStrategy)dim.getColumnSelectorStrategy()).reset();
                }
                this.selectorInternalFootprint = 0L;
            }
            while (!this.cursor.isDone()) {
                if (!this.currentRowWasPartiallyAggregated) {
                    this.stackPointer = this.stack.length - 1;
                    for (int i = 0; i < this.dims.length; ++i) {
                        GroupByColumnSelectorStrategy strategy = (GroupByColumnSelectorStrategy)this.dims[i].getColumnSelectorStrategy();
                        this.selectorInternalFootprint += (long)strategy.initColumnValues(this.dims[i].getSelector(), i, this.valuess);
                        strategy.initGroupingKeyColumnValue(this.dims[i].getKeyBufferPosition(), i, this.valuess[i], this.keyBuffer, this.stack);
                    }
                }
                boolean doAggregate = true;
                while (this.stackPointer >= -1) {
                    if (doAggregate) {
                        this.keyBuffer.rewind();
                        if (!grouper.aggregate(this.keyBuffer).isOk()) {
                            this.currentRowWasPartiallyAggregated = true;
                            return;
                        }
                        doAggregate = false;
                    }
                    if (this.stackPointer >= 0) {
                        doAggregate = ((GroupByColumnSelectorStrategy)this.dims[this.stackPointer].getColumnSelectorStrategy()).checkRowIndexAndAddValueToGroupingKey(this.dims[this.stackPointer].getKeyBufferPosition(), this.valuess[this.stackPointer], this.stack[this.stackPointer], this.keyBuffer);
                        if (doAggregate) {
                            this.checkIfMultiValueGroupingIsAllowed(this.dims[this.stackPointer].getName());
                            int n = this.stackPointer;
                            this.stack[n] = this.stack[n] + 1;
                            for (int i = this.stackPointer + 1; i < this.stack.length; ++i) {
                                ((GroupByColumnSelectorStrategy)this.dims[i].getColumnSelectorStrategy()).initGroupingKeyColumnValue(this.dims[i].getKeyBufferPosition(), i, this.valuess[i], this.keyBuffer, this.stack);
                            }
                            this.stackPointer = this.stack.length - 1;
                            continue;
                        }
                        --this.stackPointer;
                        continue;
                    }
                    --this.stackPointer;
                }
                this.cursor.advance();
                this.currentRowWasPartiallyAggregated = false;
                if (this.selectorInternalFootprint <= this.maxSelectorFootprint) continue;
                return;
            }
        }

        @Override
        protected void putToRow(ByteBuffer key, ResultRow resultRow) {
            for (GroupByColumnSelectorPlus selectorPlus : this.dims) {
                ((GroupByColumnSelectorStrategy)selectorPlus.getColumnSelectorStrategy()).processValueFromGroupingKey(selectorPlus, key, resultRow, selectorPlus.getKeyBufferPosition());
            }
        }
    }

    private static abstract class GroupByEngineIterator<KeyType>
    implements Iterator<ResultRow>,
    Closeable {
        protected final GroupByQuery query;
        protected final GroupByQueryConfig querySpecificConfig;
        protected final Cursor cursor;
        protected final ByteBuffer buffer;
        protected final Grouper.KeySerde<ByteBuffer> keySerde;
        protected final GroupByColumnSelectorPlus[] dims;
        protected final DateTime timestamp;
        @Nullable
        protected CloseableGrouperIterator<KeyType, ResultRow> delegate = null;
        protected final boolean allSingleValueDims;
        protected final boolean allowMultiValueGrouping;
        protected final long maxSelectorFootprint;

        public GroupByEngineIterator(GroupByQuery query, GroupByQueryConfig querySpecificConfig, DruidProcessingConfig processingConfig, Cursor cursor, ByteBuffer buffer, @Nullable DateTime fudgeTimestamp, GroupByColumnSelectorPlus[] dims, boolean allSingleValueDims) {
            this.query = query;
            this.querySpecificConfig = querySpecificConfig;
            this.maxSelectorFootprint = querySpecificConfig.getActualMaxSelectorDictionarySize(processingConfig);
            this.cursor = cursor;
            this.buffer = buffer;
            this.keySerde = new GroupByEngineKeySerde(dims, query);
            this.dims = dims;
            this.timestamp = fudgeTimestamp != null ? fudgeTimestamp : cursor.getTime();
            this.allSingleValueDims = allSingleValueDims;
            this.allowMultiValueGrouping = query.context().getBoolean("groupByEnableMultiValueUnnesting", true);
        }

        private CloseableGrouperIterator<KeyType, ResultRow> initNewDelegate() {
            Grouper<KeyType> grouper = this.newGrouper();
            grouper.init();
            if (this.allSingleValueDims) {
                this.aggregateSingleValueDims(grouper);
            } else {
                this.aggregateMultiValueDims(grouper);
            }
            boolean resultRowHasTimestamp = this.query.getResultRowHasTimestamp();
            int resultRowDimensionStart = this.query.getResultRowDimensionStart();
            int resultRowAggregatorStart = this.query.getResultRowAggregatorStart();
            return new CloseableGrouperIterator<KeyType, ResultRow>(grouper.iterator(false), entry -> {
                ResultRow resultRow = ResultRow.create(this.query.getResultRowSizeWithoutPostAggregators());
                if (resultRowHasTimestamp) {
                    resultRow.set(0, this.timestamp.getMillis());
                }
                this.putToRow(entry.getKey(), resultRow);
                GroupingEngine.convertRowTypesToOutputTypes(this.query.getDimensions(), resultRow, resultRowDimensionStart);
                for (int i = 0; i < entry.getValues().length; ++i) {
                    resultRow.set(resultRowAggregatorStart + i, entry.getValues()[i]);
                }
                return resultRow;
            }, grouper);
        }

        @Override
        public ResultRow next() {
            if (this.delegate == null || !this.delegate.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.delegate.next();
        }

        @Override
        public boolean hasNext() {
            if (this.delegate != null && this.delegate.hasNext()) {
                return true;
            }
            if (!this.cursor.isDone()) {
                if (this.delegate != null) {
                    this.delegate.close();
                }
                this.delegate = this.initNewDelegate();
                return this.delegate.hasNext();
            }
            return false;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            if (this.delegate != null) {
                this.delegate.close();
            }
        }

        protected abstract Grouper<KeyType> newGrouper();

        protected abstract void aggregateSingleValueDims(Grouper<KeyType> var1);

        protected abstract void aggregateMultiValueDims(Grouper<KeyType> var1);

        protected abstract void putToRow(KeyType var1, ResultRow var2);

        protected int getSingleValue(IndexedInts indexedInts) {
            Preconditions.checkArgument((indexedInts.size() < 2 ? 1 : 0) != 0, (Object)"should be single value");
            return indexedInts.size() == 1 ? indexedInts.get(0) : -1;
        }

        protected void checkIfMultiValueGroupingIsAllowed(String dimName) {
            if (!this.allowMultiValueGrouping) {
                throw new UnexpectedMultiValueDimensionException(dimName);
            }
        }
    }
}

