/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.validation.constraints.Min;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.utils.JvmUtils;

public class LookupConfig {
    static int DEFAULT_COORDINATOR_RETRY_DELAY = 60000;
    @JsonProperty(value="snapshotWorkingDir")
    private String snapshotWorkingDir;
    @JsonProperty(value="enableLookupSyncOnStartup")
    private boolean enableLookupSyncOnStartup = true;
    @Min(value=1L)
    @JsonProperty(value="numLookupLoadingThreads")
    private @Min(value=1L) int numLookupLoadingThreads = Math.max(1, JvmUtils.getRuntimeInfo().getAvailableProcessors() / 2);
    @Min(value=1L)
    @JsonProperty(value="coordinatorFetchRetries")
    private @Min(value=1L) int coordinatorFetchRetries = 3;
    @Min(value=0L)
    @JsonProperty(value="coordinatorRetryDelay")
    private @Min(value=0L) int coordinatorRetryDelay = DEFAULT_COORDINATOR_RETRY_DELAY;
    @Min(value=1L)
    @JsonProperty(value="lookupStartRetries")
    private @Min(value=1L) int lookupStartRetries = 3;

    @JsonCreator
    public LookupConfig(@JsonProperty(value="snapshotWorkingDir") String snapshotWorkingDir) {
        this.snapshotWorkingDir = StringUtils.nullToEmptyNonDruidDataString(snapshotWorkingDir);
    }

    public String getSnapshotWorkingDir() {
        return this.snapshotWorkingDir;
    }

    public int getNumLookupLoadingThreads() {
        return this.numLookupLoadingThreads;
    }

    public boolean getEnableLookupSyncOnStartup() {
        return this.enableLookupSyncOnStartup;
    }

    public int getCoordinatorFetchRetries() {
        return this.coordinatorFetchRetries;
    }

    public int getLookupStartRetries() {
        return this.lookupStartRetries;
    }

    public int getCoordinatorRetryDelay() {
        return this.coordinatorRetryDelay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LookupConfig)) {
            return false;
        }
        LookupConfig that = (LookupConfig)o;
        return Objects.equals(this.snapshotWorkingDir, that.snapshotWorkingDir) && this.enableLookupSyncOnStartup == that.enableLookupSyncOnStartup && this.numLookupLoadingThreads == that.numLookupLoadingThreads && this.coordinatorFetchRetries == that.coordinatorFetchRetries && this.lookupStartRetries == that.lookupStartRetries && this.coordinatorRetryDelay == that.coordinatorRetryDelay;
    }

    public int hashCode() {
        return Objects.hash(this.snapshotWorkingDir, this.enableLookupSyncOnStartup, this.numLookupLoadingThreads, this.coordinatorFetchRetries, this.lookupStartRetries, this.coordinatorRetryDelay);
    }

    public String toString() {
        return "LookupConfig{snapshotWorkingDir='" + this.snapshotWorkingDir + '\'' + ", enableLookupSyncOnStartup=" + this.enableLookupSyncOnStartup + ", numLookupLoadingThreads=" + this.numLookupLoadingThreads + ", coordinatorFetchRetries=" + this.coordinatorFetchRetries + ", lookupStartRetries=" + this.lookupStartRetries + ", coordinatorRetryDelay=" + this.coordinatorRetryDelay + '}';
    }
}

