/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class OffsetLimit {
    protected final long offset;
    protected final long limit;
    public static final OffsetLimit NONE = new OffsetLimit(0L, -1L);

    @JsonCreator
    public OffsetLimit(@JsonProperty(value="offset") long offset, @JsonProperty(value="limit") long limit) {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset >= 0");
        this.offset = offset;
        this.limit = limit < 0L ? -1L : limit;
    }

    @JsonProperty(value="offset")
    public long getOffset() {
        return this.offset;
    }

    @JsonProperty(value="limit")
    public long getLimit() {
        return this.limit;
    }

    public boolean isPresent() {
        return this.hasOffset() || this.hasLimit();
    }

    public boolean hasOffset() {
        return this.offset > 0L;
    }

    public boolean hasLimit() {
        return this.limit >= 0L;
    }

    public static OffsetLimit limit(int limit2) {
        return new OffsetLimit(0L, limit2);
    }

    public long getLimitOrMax() {
        if (this.limit < 0L) {
            return Long.MAX_VALUE;
        }
        return this.limit;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OffsetLimit)) {
            return false;
        }
        OffsetLimit that = (OffsetLimit)o;
        return this.limit == that.limit && this.offset == that.offset;
    }

    public final int hashCode() {
        return Objects.hash(this.limit, this.offset);
    }

    public String toString() {
        return "OffsetLimit{offset=" + this.offset + ", limit=" + this.limit + '}';
    }

    public long getFromIndex(long maxIndex) {
        if (maxIndex <= this.offset) {
            return 0L;
        }
        return this.offset;
    }

    public long getToIndex(long maxIndex) {
        if (maxIndex <= this.offset) {
            return 0L;
        }
        if (this.hasLimit()) {
            long toIndex = this.limit + this.offset;
            return Math.min(maxIndex, toIndex);
        }
        return maxIndex;
    }
}

