/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.window.ranking;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.druid.query.operator.window.Processor;
import org.apache.druid.query.operator.window.ranking.WindowRankingProcessorBase;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.DoubleArrayColumn;
import org.apache.druid.query.rowsandcols.column.IntArrayColumn;

public class WindowRankProcessor
extends WindowRankingProcessorBase {
    private final boolean asPercent;

    @JsonCreator
    public WindowRankProcessor(@JsonProperty(value="group") List<String> groupingCols, @JsonProperty(value="outputColumn") String outputColumn, @JsonProperty(value="asPercent") boolean asPercent) {
        super(groupingCols, outputColumn);
        this.asPercent = asPercent;
    }

    @JsonProperty(value="asPercent")
    public boolean isAsPercent() {
        return this.asPercent;
    }

    @Override
    public RowsAndColumns process(RowsAndColumns incomingPartition) {
        if (this.asPercent) {
            return this.processInternal(incomingPartition, groupings -> {
                double[] percentages = new double[incomingPartition.numRows()];
                if (percentages.length > 1) {
                    double denominator = percentages.length - 1;
                    for (int i = 1; i < ((int[])groupings).length; ++i) {
                        int start = groupings[i - 1];
                        int end = groupings[i];
                        Arrays.fill(percentages, start, end, (double)start / denominator);
                    }
                }
                return new DoubleArrayColumn(percentages);
            });
        }
        return this.processInternal(incomingPartition, groupings -> {
            int[] ranks = new int[incomingPartition.numRows()];
            for (int i = 1; i < ((int[])groupings).length; ++i) {
                int start = groupings[i - 1];
                int end = groupings[i];
                Arrays.fill(ranks, start, end, start + 1);
            }
            return new IntArrayColumn(ranks);
        });
    }

    @Override
    public boolean validateEquivalent(Processor otherProcessor) {
        if (otherProcessor instanceof WindowRankProcessor) {
            WindowRankProcessor other = (WindowRankProcessor)otherProcessor;
            return this.asPercent == other.asPercent && this.intervalValidation(other);
        }
        return false;
    }

    @Override
    public String toString() {
        return "WindowRankProcessor{" + this.internalToString() + ", asPercent=" + this.asPercent + '}';
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.asPercent);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WindowRankProcessor other = (WindowRankProcessor)obj;
        return this.asPercent == other.asPercent;
    }
}

