/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.rowsandcols.AppendableMapOfColumns;
import org.apache.druid.query.rowsandcols.SemanticCreator;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.semantic.AppendableRowsAndColumns;

public interface RowsAndColumns {
    @Nonnull
    public static AppendableRowsAndColumns expectAppendable(RowsAndColumns input) {
        if (input instanceof AppendableRowsAndColumns) {
            return (AppendableRowsAndColumns)input;
        }
        AppendableRowsAndColumns retVal = input.as(AppendableRowsAndColumns.class);
        if (retVal == null) {
            retVal = new AppendableMapOfColumns(input);
        }
        return retVal;
    }

    public static <T> Map<Class<?>, Function<T, ?>> makeAsMap(Class<T> clazz) {
        HashMap retVal = new HashMap();
        for (Method method : clazz.getMethods()) {
            if (!method.isAnnotationPresent(SemanticCreator.class)) continue;
            if (method.getParameterCount() != 0) {
                throw DruidException.defensive("Method [%s] annotated with SemanticCreator was not 0-argument.", method);
            }
            retVal.put(method.getReturnType(), arg -> {
                try {
                    return method.invoke(arg, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw DruidException.defensive().build(e, "Problem invoking method [%s]", method);
                }
            });
        }
        return retVal;
    }

    public Collection<String> getColumnNames();

    public int numRows();

    @Nullable
    public Column findColumn(String var1);

    @Nullable
    public <T> T as(Class<T> var1);
}

