/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.concrete;

import java.io.Closeable;
import java.io.IOException;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.ReadableOffset;

public class ColumnHolderRACColumn
implements Column,
Closeable {
    private final ColumnHolder holder;
    private BaseColumn baseColumn;

    public ColumnHolderRACColumn(ColumnHolder holder) {
        this.holder = holder;
    }

    @Override
    @Nonnull
    public ColumnAccessor toAccessor() {
        BaseColumn baseColumn = this.getBaseColumn();
        final AtomicInteger offset = new AtomicInteger(0);
        final ColumnValueSelector<?> valueSelector = baseColumn.makeColumnValueSelector(new AtomicIntegerReadableOffset(offset));
        final ColumnType columnType = this.holder.getCapabilities().toColumnType();
        final Comparator<Object> comparator = Comparator.nullsFirst(columnType.getStrategy());
        return new ColumnAccessor(){

            @Override
            public ColumnType getType() {
                return columnType;
            }

            @Override
            public int numRows() {
                return ColumnHolderRACColumn.this.holder.getLength();
            }

            @Override
            public boolean isNull(int rowNum) {
                offset.set(rowNum);
                return valueSelector.isNull();
            }

            @Override
            @Nullable
            public Object getObject(int rowNum) {
                offset.set(rowNum);
                return valueSelector.getObject();
            }

            @Override
            public double getDouble(int rowNum) {
                offset.set(rowNum);
                return valueSelector.getDouble();
            }

            @Override
            public float getFloat(int rowNum) {
                offset.set(rowNum);
                return valueSelector.getFloat();
            }

            @Override
            public long getLong(int rowNum) {
                offset.set(rowNum);
                return valueSelector.getLong();
            }

            @Override
            public int getInt(int rowNum) {
                offset.set(rowNum);
                return (int)valueSelector.getLong();
            }

            @Override
            public int compareRows(int lhsRowNum, int rhsRowNum) {
                return comparator.compare(this.getObject(lhsRowNum), this.getObject(rhsRowNum));
            }
        };
    }

    @Override
    @Nullable
    public <T> T as(Class<? extends T> clazz) {
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.baseColumn != null) {
            this.baseColumn.close();
        }
    }

    public BaseColumn getBaseColumn() {
        if (this.baseColumn == null) {
            this.baseColumn = this.holder.getColumn();
        }
        return this.baseColumn;
    }

    private static class AtomicIntegerReadableOffset
    implements ReadableOffset {
        private final AtomicInteger offset;

        public AtomicIntegerReadableOffset(AtomicInteger offset) {
            this.offset = offset;
        }

        @Override
        public int getOffset() {
            return this.offset.get();
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        }
    }
}

