/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.MemoryAllocatorFactory;
import org.apache.druid.frame.segment.FrameCursorUtils;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.frame.write.FrameWriterUtils;
import org.apache.druid.frame.write.FrameWriters;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.FrameSignaturePair;
import org.apache.druid.query.IterableRowsCursorHelper;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.query.scan.ScanResultValueIterator;
import org.apache.druid.query.scan.SettableCursorColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.column.RowSignature;

public class ScanResultValueFramesIterable
implements Iterable<FrameSignaturePair> {
    final Sequence<ScanResultValue> resultSequence;
    final MemoryAllocatorFactory memoryAllocatorFactory;
    final boolean useNestedForUnknownTypes;
    final RowSignature defaultRowSignature;
    final Function<RowSignature, Function<?, Object[]>> resultFormatMapper;

    public ScanResultValueFramesIterable(Sequence<ScanResultValue> resultSequence, MemoryAllocatorFactory memoryAllocatorFactory, boolean useNestedForUnknownTypes, RowSignature defaultRowSignature, Function<RowSignature, Function<?, Object[]>> resultFormatMapper) {
        this.resultSequence = resultSequence;
        this.memoryAllocatorFactory = memoryAllocatorFactory;
        this.useNestedForUnknownTypes = useNestedForUnknownTypes;
        this.defaultRowSignature = defaultRowSignature;
        this.resultFormatMapper = resultFormatMapper;
    }

    @Override
    public Iterator<FrameSignaturePair> iterator() {
        return new ScanResultValueFramesIterator(this.resultSequence, this.memoryAllocatorFactory, this.useNestedForUnknownTypes, this.defaultRowSignature, this.resultFormatMapper);
    }

    private static class ScanResultValueFramesIterator
    implements Iterator<FrameSignaturePair> {
        final MemoryAllocatorFactory memoryAllocatorFactory;
        final boolean useNestedForUnknownTypes;
        final RowSignature defaultRowSignature;
        final Function<RowSignature, Function<?, Object[]>> resultFormatMapper;
        final Closer closer = Closer.create();
        final ScanResultValueIterator resultSequenceIterator;
        Cursor currentCursor = null;
        RowSignature currentRowSignature = null;

        public ScanResultValueFramesIterator(Sequence<ScanResultValue> resultSequence, MemoryAllocatorFactory memoryAllocatorFactory, boolean useNestedForUnknownTypes, RowSignature defaultRowSignature, Function<RowSignature, Function<?, Object[]>> resultFormatMapper) {
            this.memoryAllocatorFactory = memoryAllocatorFactory;
            this.useNestedForUnknownTypes = useNestedForUnknownTypes;
            this.defaultRowSignature = defaultRowSignature;
            this.resultFormatMapper = resultFormatMapper;
            this.resultSequenceIterator = new ScanResultValueIterator(resultSequence);
            this.closer.register(this.resultSequenceIterator);
            this.populateCursor();
        }

        @Override
        public boolean hasNext() {
            return !this.done();
        }

        @Override
        public FrameSignaturePair next() {
            Frame frame;
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more frames to produce. Call `hasNext()` before calling `next()`");
            }
            this.populateCursor();
            boolean firstRowWritten = false;
            RowSignature writtenSignature = this.currentRowSignature;
            FrameWriterFactory frameWriterFactory = FrameWriters.makeFrameWriterFactory(FrameType.COLUMNAR, this.memoryAllocatorFactory, this.currentRowSignature, Collections.emptyList());
            try (FrameWriter frameWriter = frameWriterFactory.newFrameWriter(new SettableCursorColumnSelectorFactory(() -> this.currentCursor, this.currentRowSignature));){
                while (this.populateCursor() && frameWriter.addSelection()) {
                    firstRowWritten = true;
                    this.currentCursor.advance();
                }
                if (!firstRowWritten) {
                    throw FrameCursorUtils.SUBQUERY_ROW_TOO_LARGE_EXCEPTION;
                }
                frame = Frame.wrap(frameWriter.toByteArray());
            }
            return new FrameSignaturePair(frame, writtenSignature);
        }

        private boolean done() {
            return (this.currentCursor == null || this.currentCursor.isDone()) && !this.resultSequenceIterator.hasNext();
        }

        private boolean populateCursor() {
            if (this.currentCursor != null && !this.currentCursor.isDone()) {
                return true;
            }
            if (this.done()) {
                return false;
            }
            ScanResultValue scanResultValue = this.resultSequenceIterator.next();
            RowSignature rowSignature = scanResultValue.getRowSignature() != null ? scanResultValue.getRowSignature() : this.defaultRowSignature;
            RowSignature modifiedRowSignature = this.useNestedForUnknownTypes ? FrameWriterUtils.replaceUnknownTypesWithNestedColumns(rowSignature) : rowSignature;
            boolean compatible = modifiedRowSignature != null && modifiedRowSignature.equals(this.currentRowSignature);
            List rows = (List)scanResultValue.getEvents();
            ArrayList formattedRows = Lists.newArrayList((Iterable)Iterables.transform((Iterable)rows, (Function)((Function)this.resultFormatMapper.apply((Object)modifiedRowSignature))));
            Pair<Cursor, Closeable> cursorAndCloseable = IterableRowsCursorHelper.getCursorFromIterable(formattedRows, modifiedRowSignature);
            this.currentCursor = (Cursor)cursorAndCloseable.lhs;
            this.closer.register((Closeable)cursorAndCloseable.rhs);
            if (this.currentCursor.isDone()) {
                return this.populateCursor();
            }
            this.currentRowSignature = modifiedRowSignature;
            return compatible;
        }
    }
}

