/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.druid.query.ColumnSelectorPlus;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.topn.BaseTopNAlgorithm;
import org.apache.druid.query.topn.TopNParams;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNResultBuilder;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.column.ColumnType;

public class TimeExtractionTopNAlgorithm
extends BaseTopNAlgorithm<int[], Map<Object, Aggregator[]>, TopNParams> {
    private static final int[] EMPTY_INTS = new int[0];
    private final TopNQuery query;
    private final Function<Object, Object> dimensionValueConverter;

    public TimeExtractionTopNAlgorithm(StorageAdapter storageAdapter, TopNQuery query) {
        super(storageAdapter);
        this.query = query;
        this.dimensionValueConverter = DimensionHandlerUtils.converterFromTypeToType(ColumnType.STRING, query.getDimensionSpec().getOutputType());
    }

    @Override
    public TopNParams makeInitParams(ColumnSelectorPlus selectorPlus, Cursor cursor) {
        return new TopNParams(selectorPlus, cursor, Integer.MAX_VALUE);
    }

    @Override
    protected int[] makeDimValSelector(TopNParams params, int numProcessed, int numToProcess) {
        return EMPTY_INTS;
    }

    @Override
    protected int[] updateDimValSelector(int[] dimValSelector, int numProcessed, int numToProcess) {
        return dimValSelector;
    }

    @Override
    protected Map<Object, Aggregator[]> makeDimValAggregateStore(TopNParams params) {
        return new HashMap<Object, Aggregator[]>();
    }

    @Override
    protected long scanAndAggregate(TopNParams params, int[] dimValSelector, Map<Object, Aggregator[]> aggregatesStore) {
        Cursor cursor = params.getCursor();
        DimensionSelector dimSelector = params.getDimSelector();
        long processedRows = 0L;
        while (!cursor.isDone()) {
            Aggregator[] theAggregators;
            Object key = this.dimensionValueConverter.apply(dimSelector.lookupName(dimSelector.getRow().get(0)));
            for (Aggregator aggregator : theAggregators = aggregatesStore.computeIfAbsent(key, k -> TimeExtractionTopNAlgorithm.makeAggregators(cursor, this.query.getAggregatorSpecs()))) {
                aggregator.aggregate();
            }
            cursor.advance();
            ++processedRows;
        }
        return processedRows;
    }

    @Override
    protected void updateResults(TopNParams params, int[] dimValSelector, Map<Object, Aggregator[]> aggregatesStore, TopNResultBuilder resultBuilder) {
        for (Map.Entry<Object, Aggregator[]> entry : aggregatesStore.entrySet()) {
            Aggregator[] aggs = entry.getValue();
            if (aggs == null) continue;
            Object[] vals = new Object[aggs.length];
            for (int i = 0; i < aggs.length; ++i) {
                vals[i] = aggs[i].get();
            }
            resultBuilder.addEntry(entry.getKey(), entry.getKey(), vals);
        }
    }

    @Override
    protected void resetAggregators(Map<Object, Aggregator[]> stringMap) {
        for (Aggregator[] aggregators : stringMap.values()) {
            for (Aggregator agg : aggregators) {
                agg.close();
            }
        }
    }

    @Override
    public void cleanup(TopNParams params) {
    }
}

